/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fpmlenum.FxStraddleTypeEnum;
import fpml.consolidated.fx.FxEuropeanExercise;
import fpml.consolidated.fx.FxStraddlePremium;
import fpml.consolidated.fx.meta.FxStraddleMeta;
import fpml.consolidated.shared.AdjustableOrAdjustedDate;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.ExerciseProcedure;
import fpml.consolidated.shared.FxCashSettlementSimple;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxStraddle", builder=FxStraddleBuilderImpl.class, version="1.1.0")
@RuneDataType(value="FxStraddle", model="fpml", builder=FxStraddleBuilderImpl.class, version="1.1.0")
public interface FxStraddle
extends RosettaModelObject {
    public static final FxStraddleMeta metaData = new FxStraddleMeta();

    public FxStraddleTypeEnum getStraddleType();

    public Period getTenorPeriod();

    public FxEuropeanExercise getEuropeanExercise();

    public ExerciseProcedure getExerciseProcedure();

    public NonNegativeMoney getNotional();

    public Currency getCounterCurrency();

    public List<? extends FxStraddlePremium> getPremium();

    public AdjustableOrAdjustedDate getSettlementDate();

    public FxCashSettlementSimple getCashSettlement();

    public FxStraddle build();

    public FxStraddleBuilder toBuilder();

    public static FxStraddleBuilder builder() {
        return new FxStraddleBuilderImpl();
    }

    default public RosettaMetaData<? extends FxStraddle> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxStraddle> getType() {
        return FxStraddle.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("straddleType"), FxStraddleTypeEnum.class, (Object)this.getStraddleType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.class, this.getTenorPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("europeanExercise"), processor, FxEuropeanExercise.class, this.getEuropeanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterCurrency"), processor, Currency.class, this.getCounterCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, FxStraddlePremium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.class, this.getCashSettlement(), new AttributeMeta[0]);
    }

    public static class FxStraddleBuilderImpl
    implements FxStraddleBuilder {
        protected FxStraddleTypeEnum straddleType;
        protected Period.PeriodBuilder tenorPeriod;
        protected FxEuropeanExercise.FxEuropeanExerciseBuilder europeanExercise;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected NonNegativeMoney.NonNegativeMoneyBuilder notional;
        protected Currency.CurrencyBuilder counterCurrency;
        protected List<FxStraddlePremium.FxStraddlePremiumBuilder> premium = new ArrayList<FxStraddlePremium.FxStraddlePremiumBuilder>();
        protected AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder settlementDate;
        protected FxCashSettlementSimple.FxCashSettlementSimpleBuilder cashSettlement;

        @Override
        @RosettaAttribute(value="straddleType", isRequired=true)
        @RuneAttribute(value="straddleType", isRequired=true)
        public FxStraddleTypeEnum getStraddleType() {
            return this.straddleType;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public Period.PeriodBuilder getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTenorPeriod() {
            Period.PeriodBuilder result = this.tenorPeriod != null ? this.tenorPeriod : (this.tenorPeriod = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="europeanExercise", isRequired=true)
        @RuneAttribute(value="europeanExercise", isRequired=true)
        public FxEuropeanExercise.FxEuropeanExerciseBuilder getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        public FxEuropeanExercise.FxEuropeanExerciseBuilder getOrCreateEuropeanExercise() {
            FxEuropeanExercise.FxEuropeanExerciseBuilder result = this.europeanExercise != null ? this.europeanExercise : (this.europeanExercise = FxEuropeanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional() {
            return this.notional;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.notional != null ? this.notional : (this.notional = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterCurrency", isRequired=true)
        @RuneAttribute(value="counterCurrency", isRequired=true)
        public Currency.CurrencyBuilder getCounterCurrency() {
            return this.counterCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCounterCurrency() {
            Currency.CurrencyBuilder result = this.counterCurrency != null ? this.counterCurrency : (this.counterCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxStraddlePremium.FxStraddlePremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public FxStraddlePremium.FxStraddlePremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<FxStraddlePremium.FxStraddlePremiumBuilder>();
            }
            return (FxStraddlePremium.FxStraddlePremiumBuilder)this.getIndex(this.premium, index, () -> {
                FxStraddlePremium.FxStraddlePremiumBuilder newPremium = FxStraddlePremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreateSettlementDate() {
            AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableOrAdjustedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement() {
            FxCashSettlementSimple.FxCashSettlementSimpleBuilder result = this.cashSettlement != null ? this.cashSettlement : (this.cashSettlement = FxCashSettlementSimple.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="straddleType", isRequired=true)
        @RuneAttribute(value="straddleType", isRequired=true)
        public FxStraddleBuilder setStraddleType(FxStraddleTypeEnum _straddleType) {
            this.straddleType = _straddleType == null ? null : _straddleType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public FxStraddleBuilder setTenorPeriod(Period _tenorPeriod) {
            this.tenorPeriod = _tenorPeriod == null ? null : _tenorPeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="europeanExercise", isRequired=true)
        @RuneAttribute(value="europeanExercise", isRequired=true)
        public FxStraddleBuilder setEuropeanExercise(FxEuropeanExercise _europeanExercise) {
            this.europeanExercise = _europeanExercise == null ? null : _europeanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public FxStraddleBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public FxStraddleBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterCurrency", isRequired=true)
        @RuneAttribute(value="counterCurrency", isRequired=true)
        public FxStraddleBuilder setCounterCurrency(Currency _counterCurrency) {
            this.counterCurrency = _counterCurrency == null ? null : _counterCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxStraddleBuilder addPremium(FxStraddlePremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public FxStraddleBuilder addPremium(FxStraddlePremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public FxStraddleBuilder addPremium(List<? extends FxStraddlePremium> premiums) {
            if (premiums != null) {
                for (FxStraddlePremium fxStraddlePremium : premiums) {
                    this.premium.add(fxStraddlePremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public FxStraddleBuilder setPremium(List<? extends FxStraddlePremium> premiums) {
            this.premium = premiums == null ? new ArrayList<FxStraddlePremium.FxStraddlePremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public FxStraddleBuilder setSettlementDate(AdjustableOrAdjustedDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxStraddleBuilder setCashSettlement(FxCashSettlementSimple _cashSettlement) {
            this.cashSettlement = _cashSettlement == null ? null : _cashSettlement.toBuilder();
            return this;
        }

        @Override
        public FxStraddle build() {
            return new FxStraddleImpl(this);
        }

        @Override
        public FxStraddleBuilder toBuilder() {
            return this;
        }

        @Override
        public FxStraddleBuilder prune() {
            if (this.tenorPeriod != null && !this.tenorPeriod.prune().hasData()) {
                this.tenorPeriod = null;
            }
            if (this.europeanExercise != null && !this.europeanExercise.prune().hasData()) {
                this.europeanExercise = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            if (this.counterCurrency != null && !this.counterCurrency.prune().hasData()) {
                this.counterCurrency = null;
            }
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            if (this.cashSettlement != null && !this.cashSettlement.prune().hasData()) {
                this.cashSettlement = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStraddleType() != null) {
                return true;
            }
            if (this.getTenorPeriod() != null && this.getTenorPeriod().hasData()) {
                return true;
            }
            if (this.getEuropeanExercise() != null && this.getEuropeanExercise().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            if (this.getCounterCurrency() != null && this.getCounterCurrency().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSettlementDate() != null && this.getSettlementDate().hasData()) {
                return true;
            }
            return this.getCashSettlement() != null && this.getCashSettlement().hasData();
        }

        public FxStraddleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxStraddleBuilder o = (FxStraddleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTenorPeriod(), (RosettaModelObjectBuilder)o.getTenorPeriod(), this::setTenorPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEuropeanExercise(), (RosettaModelObjectBuilder)o.getEuropeanExercise(), this::setEuropeanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterCurrency(), (RosettaModelObjectBuilder)o.getCounterCurrency(), this::setCounterCurrency);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlement(), (RosettaModelObjectBuilder)o.getCashSettlement(), this::setCashSettlement);
            merger.mergeBasic((Object)this.getStraddleType(), (Object)o.getStraddleType(), this::setStraddleType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxStraddle _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.straddleType, (Object)_that.getStraddleType())) {
                return false;
            }
            if (!Objects.equals(this.tenorPeriod, _that.getTenorPeriod())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.counterCurrency, _that.getCounterCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.cashSettlement, _that.getCashSettlement());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.straddleType != null ? ((Object)((Object)this.straddleType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrency != null ? this.counterCurrency.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxStraddleBuilder {straddleType=" + (Object)((Object)this.straddleType) + ", tenorPeriod=" + this.tenorPeriod + ", europeanExercise=" + this.europeanExercise + ", exerciseProcedure=" + this.exerciseProcedure + ", notional=" + this.notional + ", counterCurrency=" + this.counterCurrency + ", premium=" + this.premium + ", settlementDate=" + this.settlementDate + ", cashSettlement=" + this.cashSettlement + '}';
        }
    }

    public static interface FxStraddleBuilder
    extends FxStraddle,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateTenorPeriod();

        @Override
        public Period.PeriodBuilder getTenorPeriod();

        public FxEuropeanExercise.FxEuropeanExerciseBuilder getOrCreateEuropeanExercise();

        @Override
        public FxEuropeanExercise.FxEuropeanExerciseBuilder getEuropeanExercise();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional();

        public Currency.CurrencyBuilder getOrCreateCounterCurrency();

        @Override
        public Currency.CurrencyBuilder getCounterCurrency();

        public FxStraddlePremium.FxStraddlePremiumBuilder getOrCreatePremium(int var1);

        public List<? extends FxStraddlePremium.FxStraddlePremiumBuilder> getPremium();

        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getSettlementDate();

        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement();

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement();

        public FxStraddleBuilder setStraddleType(FxStraddleTypeEnum var1);

        public FxStraddleBuilder setTenorPeriod(Period var1);

        public FxStraddleBuilder setEuropeanExercise(FxEuropeanExercise var1);

        public FxStraddleBuilder setExerciseProcedure(ExerciseProcedure var1);

        public FxStraddleBuilder setNotional(NonNegativeMoney var1);

        public FxStraddleBuilder setCounterCurrency(Currency var1);

        public FxStraddleBuilder addPremium(FxStraddlePremium var1);

        public FxStraddleBuilder addPremium(FxStraddlePremium var1, int var2);

        public FxStraddleBuilder addPremium(List<? extends FxStraddlePremium> var1);

        public FxStraddleBuilder setPremium(List<? extends FxStraddlePremium> var1);

        public FxStraddleBuilder setSettlementDate(AdjustableOrAdjustedDate var1);

        public FxStraddleBuilder setCashSettlement(FxCashSettlementSimple var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("straddleType"), FxStraddleTypeEnum.class, (Object)this.getStraddleType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.PeriodBuilder.class, this.getTenorPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("europeanExercise"), processor, FxEuropeanExercise.FxEuropeanExerciseBuilder.class, this.getEuropeanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterCurrency"), processor, Currency.CurrencyBuilder.class, this.getCounterCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, FxStraddlePremium.FxStraddlePremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.FxCashSettlementSimpleBuilder.class, this.getCashSettlement(), new AttributeMeta[0]);
        }

        public FxStraddleBuilder prune();
    }

    public static class FxStraddleImpl
    implements FxStraddle {
        private final FxStraddleTypeEnum straddleType;
        private final Period tenorPeriod;
        private final FxEuropeanExercise europeanExercise;
        private final ExerciseProcedure exerciseProcedure;
        private final NonNegativeMoney notional;
        private final Currency counterCurrency;
        private final List<? extends FxStraddlePremium> premium;
        private final AdjustableOrAdjustedDate settlementDate;
        private final FxCashSettlementSimple cashSettlement;

        protected FxStraddleImpl(FxStraddleBuilder builder) {
            this.straddleType = builder.getStraddleType();
            this.tenorPeriod = Optional.ofNullable(builder.getTenorPeriod()).map(f -> f.build()).orElse(null);
            this.europeanExercise = Optional.ofNullable(builder.getEuropeanExercise()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.counterCurrency = Optional.ofNullable(builder.getCounterCurrency()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
            this.cashSettlement = Optional.ofNullable(builder.getCashSettlement()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="straddleType", isRequired=true)
        @RuneAttribute(value="straddleType", isRequired=true)
        public FxStraddleTypeEnum getStraddleType() {
            return this.straddleType;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public Period getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        @RosettaAttribute(value="europeanExercise", isRequired=true)
        @RuneAttribute(value="europeanExercise", isRequired=true)
        public FxEuropeanExercise getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public NonNegativeMoney getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="counterCurrency", isRequired=true)
        @RuneAttribute(value="counterCurrency", isRequired=true)
        public Currency getCounterCurrency() {
            return this.counterCurrency;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxStraddlePremium> getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="settlementDate")
        @RuneAttribute(value="settlementDate")
        public AdjustableOrAdjustedDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxStraddle build() {
            return this;
        }

        @Override
        public FxStraddleBuilder toBuilder() {
            FxStraddleBuilder builder = FxStraddle.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxStraddleBuilder builder) {
            Optional.ofNullable(this.getStraddleType()).ifPresent(builder::setStraddleType);
            Optional.ofNullable(this.getTenorPeriod()).ifPresent(builder::setTenorPeriod);
            Optional.ofNullable(this.getEuropeanExercise()).ifPresent(builder::setEuropeanExercise);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getCounterCurrency()).ifPresent(builder::setCounterCurrency);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getCashSettlement()).ifPresent(builder::setCashSettlement);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxStraddle _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.straddleType, (Object)_that.getStraddleType())) {
                return false;
            }
            if (!Objects.equals(this.tenorPeriod, _that.getTenorPeriod())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.counterCurrency, _that.getCounterCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.premium, _that.getPremium())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.cashSettlement, _that.getCashSettlement());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.straddleType != null ? ((Object)((Object)this.straddleType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrency != null ? this.counterCurrency.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxStraddle {straddleType=" + (Object)((Object)this.straddleType) + ", tenorPeriod=" + this.tenorPeriod + ", europeanExercise=" + this.europeanExercise + ", exerciseProcedure=" + this.exerciseProcedure + ", notional=" + this.notional + ", counterCurrency=" + this.counterCurrency + ", premium=" + this.premium + ", settlementDate=" + this.settlementDate + ", cashSettlement=" + this.cashSettlement + '}';
        }
    }
}

