/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.eq.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.eq.shared.meta.EquityStrikeSequenceMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityStrikeSequence", builder=EquityStrikeSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EquityStrikeSequence", model="fpml", builder=EquityStrikeSequenceBuilderImpl.class, version="1.1.0")
public interface EquityStrikeSequence
extends RosettaModelObject {
    public static final EquityStrikeSequenceMeta metaData = new EquityStrikeSequenceMeta();

    public BigDecimal getStrikePercentage();

    public AdjustableOrRelativeDate getStrikeDeterminationDate();

    public EquityStrikeSequence build();

    public EquityStrikeSequenceBuilder toBuilder();

    public static EquityStrikeSequenceBuilder builder() {
        return new EquityStrikeSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityStrikeSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityStrikeSequence> getType() {
        return EquityStrikeSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("strikePercentage"), BigDecimal.class, (Object)this.getStrikePercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikeDeterminationDate"), processor, AdjustableOrRelativeDate.class, this.getStrikeDeterminationDate(), new AttributeMeta[0]);
    }

    public static class EquityStrikeSequenceBuilderImpl
    implements EquityStrikeSequenceBuilder {
        protected BigDecimal strikePercentage;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder strikeDeterminationDate;

        @Override
        @RosettaAttribute(value="strikePercentage")
        @RuneAttribute(value="strikePercentage")
        public BigDecimal getStrikePercentage() {
            return this.strikePercentage;
        }

        @Override
        @RosettaAttribute(value="strikeDeterminationDate")
        @RuneAttribute(value="strikeDeterminationDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStrikeDeterminationDate() {
            return this.strikeDeterminationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStrikeDeterminationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.strikeDeterminationDate != null ? this.strikeDeterminationDate : (this.strikeDeterminationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePercentage")
        @RuneAttribute(value="strikePercentage")
        public EquityStrikeSequenceBuilder setStrikePercentage(BigDecimal _strikePercentage) {
            this.strikePercentage = _strikePercentage == null ? null : _strikePercentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikeDeterminationDate")
        @RuneAttribute(value="strikeDeterminationDate")
        public EquityStrikeSequenceBuilder setStrikeDeterminationDate(AdjustableOrRelativeDate _strikeDeterminationDate) {
            this.strikeDeterminationDate = _strikeDeterminationDate == null ? null : _strikeDeterminationDate.toBuilder();
            return this;
        }

        @Override
        public EquityStrikeSequence build() {
            return new EquityStrikeSequenceImpl(this);
        }

        @Override
        public EquityStrikeSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityStrikeSequenceBuilder prune() {
            if (this.strikeDeterminationDate != null && !this.strikeDeterminationDate.prune().hasData()) {
                this.strikeDeterminationDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrikePercentage() != null) {
                return true;
            }
            return this.getStrikeDeterminationDate() != null && this.getStrikeDeterminationDate().hasData();
        }

        public EquityStrikeSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EquityStrikeSequenceBuilder o = (EquityStrikeSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikeDeterminationDate(), (RosettaModelObjectBuilder)o.getStrikeDeterminationDate(), this::setStrikeDeterminationDate);
            merger.mergeBasic((Object)this.getStrikePercentage(), (Object)o.getStrikePercentage(), this::setStrikePercentage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityStrikeSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strikePercentage, _that.getStrikePercentage())) {
                return false;
            }
            return Objects.equals(this.strikeDeterminationDate, _that.getStrikeDeterminationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikePercentage != null ? this.strikePercentage.hashCode() : 0);
            _result = 31 * _result + (this.strikeDeterminationDate != null ? this.strikeDeterminationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityStrikeSequenceBuilder {strikePercentage=" + this.strikePercentage + ", strikeDeterminationDate=" + this.strikeDeterminationDate + '}';
        }
    }

    public static interface EquityStrikeSequenceBuilder
    extends EquityStrikeSequence,
    RosettaModelObjectBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStrikeDeterminationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStrikeDeterminationDate();

        public EquityStrikeSequenceBuilder setStrikePercentage(BigDecimal var1);

        public EquityStrikeSequenceBuilder setStrikeDeterminationDate(AdjustableOrRelativeDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("strikePercentage"), BigDecimal.class, (Object)this.getStrikePercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikeDeterminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getStrikeDeterminationDate(), new AttributeMeta[0]);
        }

        public EquityStrikeSequenceBuilder prune();
    }

    public static class EquityStrikeSequenceImpl
    implements EquityStrikeSequence {
        private final BigDecimal strikePercentage;
        private final AdjustableOrRelativeDate strikeDeterminationDate;

        protected EquityStrikeSequenceImpl(EquityStrikeSequenceBuilder builder) {
            this.strikePercentage = builder.getStrikePercentage();
            this.strikeDeterminationDate = Optional.ofNullable(builder.getStrikeDeterminationDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strikePercentage")
        @RuneAttribute(value="strikePercentage")
        public BigDecimal getStrikePercentage() {
            return this.strikePercentage;
        }

        @Override
        @RosettaAttribute(value="strikeDeterminationDate")
        @RuneAttribute(value="strikeDeterminationDate")
        public AdjustableOrRelativeDate getStrikeDeterminationDate() {
            return this.strikeDeterminationDate;
        }

        @Override
        public EquityStrikeSequence build() {
            return this;
        }

        @Override
        public EquityStrikeSequenceBuilder toBuilder() {
            EquityStrikeSequenceBuilder builder = EquityStrikeSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityStrikeSequenceBuilder builder) {
            Optional.ofNullable(this.getStrikePercentage()).ifPresent(builder::setStrikePercentage);
            Optional.ofNullable(this.getStrikeDeterminationDate()).ifPresent(builder::setStrikeDeterminationDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityStrikeSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strikePercentage, _that.getStrikePercentage())) {
                return false;
            }
            return Objects.equals(this.strikeDeterminationDate, _that.getStrikeDeterminationDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikePercentage != null ? this.strikePercentage.hashCode() : 0);
            _result = 31 * _result + (this.strikeDeterminationDate != null ? this.strikeDeterminationDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityStrikeSequence {strikePercentage=" + this.strikePercentage + ", strikeDeterminationDate=" + this.strikeDeterminationDate + '}';
        }
    }
}

