/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.BasicQuotation;
import fpml.consolidated.doc.meta.InstrumentTradePricingMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="InstrumentTradePricing", builder=InstrumentTradePricingBuilderImpl.class, version="1.1.0")
@RuneDataType(value="InstrumentTradePricing", model="fpml", builder=InstrumentTradePricingBuilderImpl.class, version="1.1.0")
public interface InstrumentTradePricing
extends RosettaModelObject {
    public static final InstrumentTradePricingMeta metaData = new InstrumentTradePricingMeta();

    public List<? extends BasicQuotation> getQuote();

    public ZonedDateTime getCouponStartDate();

    public ZonedDateTime getExDividendDate();

    public Boolean getTradedFlatOfAccrued();

    public InstrumentTradePricing build();

    public InstrumentTradePricingBuilder toBuilder();

    public static InstrumentTradePricingBuilder builder() {
        return new InstrumentTradePricingBuilderImpl();
    }

    default public RosettaMetaData<? extends InstrumentTradePricing> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InstrumentTradePricing> getType() {
        return InstrumentTradePricing.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quote"), processor, BasicQuotation.class, this.getQuote(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("couponStartDate"), ZonedDateTime.class, (Object)this.getCouponStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exDividendDate"), ZonedDateTime.class, (Object)this.getExDividendDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradedFlatOfAccrued"), Boolean.class, (Object)this.getTradedFlatOfAccrued(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class InstrumentTradePricingBuilderImpl
    implements InstrumentTradePricingBuilder {
        protected List<BasicQuotation.BasicQuotationBuilder> quote = new ArrayList<BasicQuotation.BasicQuotationBuilder>();
        protected ZonedDateTime couponStartDate;
        protected ZonedDateTime exDividendDate;
        protected Boolean tradedFlatOfAccrued;

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends BasicQuotation.BasicQuotationBuilder> getQuote() {
            return this.quote;
        }

        @Override
        public BasicQuotation.BasicQuotationBuilder getOrCreateQuote(int index) {
            if (this.quote == null) {
                this.quote = new ArrayList<BasicQuotation.BasicQuotationBuilder>();
            }
            return (BasicQuotation.BasicQuotationBuilder)this.getIndex(this.quote, index, () -> {
                BasicQuotation.BasicQuotationBuilder newQuote = BasicQuotation.builder();
                return newQuote;
            });
        }

        @Override
        @RosettaAttribute(value="couponStartDate")
        @RuneAttribute(value="couponStartDate")
        public ZonedDateTime getCouponStartDate() {
            return this.couponStartDate;
        }

        @Override
        @RosettaAttribute(value="exDividendDate")
        @RuneAttribute(value="exDividendDate")
        public ZonedDateTime getExDividendDate() {
            return this.exDividendDate;
        }

        @Override
        @RosettaAttribute(value="tradedFlatOfAccrued")
        @RuneAttribute(value="tradedFlatOfAccrued")
        public Boolean getTradedFlatOfAccrued() {
            return this.tradedFlatOfAccrued;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public InstrumentTradePricingBuilder addQuote(BasicQuotation _quote) {
            if (_quote != null) {
                this.quote.add(_quote.toBuilder());
            }
            return this;
        }

        @Override
        public InstrumentTradePricingBuilder addQuote(BasicQuotation _quote, int idx) {
            this.getIndex(this.quote, idx, () -> _quote.toBuilder());
            return this;
        }

        @Override
        public InstrumentTradePricingBuilder addQuote(List<? extends BasicQuotation> quotes) {
            if (quotes != null) {
                for (BasicQuotation basicQuotation : quotes) {
                    this.quote.add(basicQuotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quote")
        public InstrumentTradePricingBuilder setQuote(List<? extends BasicQuotation> quotes) {
            this.quote = quotes == null ? new ArrayList<BasicQuotation.BasicQuotationBuilder>() : (List)quotes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="couponStartDate")
        @RuneAttribute(value="couponStartDate")
        public InstrumentTradePricingBuilder setCouponStartDate(ZonedDateTime _couponStartDate) {
            this.couponStartDate = _couponStartDate == null ? null : _couponStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exDividendDate")
        @RuneAttribute(value="exDividendDate")
        public InstrumentTradePricingBuilder setExDividendDate(ZonedDateTime _exDividendDate) {
            this.exDividendDate = _exDividendDate == null ? null : _exDividendDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradedFlatOfAccrued")
        @RuneAttribute(value="tradedFlatOfAccrued")
        public InstrumentTradePricingBuilder setTradedFlatOfAccrued(Boolean _tradedFlatOfAccrued) {
            this.tradedFlatOfAccrued = _tradedFlatOfAccrued == null ? null : _tradedFlatOfAccrued;
            return this;
        }

        @Override
        public InstrumentTradePricing build() {
            return new InstrumentTradePricingImpl(this);
        }

        @Override
        public InstrumentTradePricingBuilder toBuilder() {
            return this;
        }

        @Override
        public InstrumentTradePricingBuilder prune() {
            this.quote = this.quote.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getQuote() != null && this.getQuote().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCouponStartDate() != null) {
                return true;
            }
            if (this.getExDividendDate() != null) {
                return true;
            }
            return this.getTradedFlatOfAccrued() != null;
        }

        public InstrumentTradePricingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InstrumentTradePricingBuilder o = (InstrumentTradePricingBuilder)other;
            merger.mergeRosetta(this.getQuote(), o.getQuote(), this::getOrCreateQuote);
            merger.mergeBasic((Object)this.getCouponStartDate(), (Object)o.getCouponStartDate(), this::setCouponStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExDividendDate(), (Object)o.getExDividendDate(), this::setExDividendDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradedFlatOfAccrued(), (Object)o.getTradedFlatOfAccrued(), this::setTradedFlatOfAccrued, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InstrumentTradePricing _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.quote, _that.getQuote())) {
                return false;
            }
            if (!Objects.equals(this.couponStartDate, _that.getCouponStartDate())) {
                return false;
            }
            if (!Objects.equals(this.exDividendDate, _that.getExDividendDate())) {
                return false;
            }
            return Objects.equals(this.tradedFlatOfAccrued, _that.getTradedFlatOfAccrued());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            _result = 31 * _result + (this.couponStartDate != null ? this.couponStartDate.hashCode() : 0);
            _result = 31 * _result + (this.exDividendDate != null ? this.exDividendDate.hashCode() : 0);
            _result = 31 * _result + (this.tradedFlatOfAccrued != null ? this.tradedFlatOfAccrued.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InstrumentTradePricingBuilder {quote=" + this.quote + ", couponStartDate=" + this.couponStartDate + ", exDividendDate=" + this.exDividendDate + ", tradedFlatOfAccrued=" + this.tradedFlatOfAccrued + '}';
        }
    }

    public static interface InstrumentTradePricingBuilder
    extends InstrumentTradePricing,
    RosettaModelObjectBuilder {
        public BasicQuotation.BasicQuotationBuilder getOrCreateQuote(int var1);

        public List<? extends BasicQuotation.BasicQuotationBuilder> getQuote();

        public InstrumentTradePricingBuilder addQuote(BasicQuotation var1);

        public InstrumentTradePricingBuilder addQuote(BasicQuotation var1, int var2);

        public InstrumentTradePricingBuilder addQuote(List<? extends BasicQuotation> var1);

        public InstrumentTradePricingBuilder setQuote(List<? extends BasicQuotation> var1);

        public InstrumentTradePricingBuilder setCouponStartDate(ZonedDateTime var1);

        public InstrumentTradePricingBuilder setExDividendDate(ZonedDateTime var1);

        public InstrumentTradePricingBuilder setTradedFlatOfAccrued(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quote"), processor, BasicQuotation.BasicQuotationBuilder.class, this.getQuote(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("couponStartDate"), ZonedDateTime.class, (Object)this.getCouponStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exDividendDate"), ZonedDateTime.class, (Object)this.getExDividendDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradedFlatOfAccrued"), Boolean.class, (Object)this.getTradedFlatOfAccrued(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public InstrumentTradePricingBuilder prune();
    }

    public static class InstrumentTradePricingImpl
    implements InstrumentTradePricing {
        private final List<? extends BasicQuotation> quote;
        private final ZonedDateTime couponStartDate;
        private final ZonedDateTime exDividendDate;
        private final Boolean tradedFlatOfAccrued;

        protected InstrumentTradePricingImpl(InstrumentTradePricingBuilder builder) {
            this.quote = Optional.ofNullable(builder.getQuote()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.couponStartDate = builder.getCouponStartDate();
            this.exDividendDate = builder.getExDividendDate();
            this.tradedFlatOfAccrued = builder.getTradedFlatOfAccrued();
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends BasicQuotation> getQuote() {
            return this.quote;
        }

        @Override
        @RosettaAttribute(value="couponStartDate")
        @RuneAttribute(value="couponStartDate")
        public ZonedDateTime getCouponStartDate() {
            return this.couponStartDate;
        }

        @Override
        @RosettaAttribute(value="exDividendDate")
        @RuneAttribute(value="exDividendDate")
        public ZonedDateTime getExDividendDate() {
            return this.exDividendDate;
        }

        @Override
        @RosettaAttribute(value="tradedFlatOfAccrued")
        @RuneAttribute(value="tradedFlatOfAccrued")
        public Boolean getTradedFlatOfAccrued() {
            return this.tradedFlatOfAccrued;
        }

        @Override
        public InstrumentTradePricing build() {
            return this;
        }

        @Override
        public InstrumentTradePricingBuilder toBuilder() {
            InstrumentTradePricingBuilder builder = InstrumentTradePricing.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InstrumentTradePricingBuilder builder) {
            Optional.ofNullable(this.getQuote()).ifPresent(builder::setQuote);
            Optional.ofNullable(this.getCouponStartDate()).ifPresent(builder::setCouponStartDate);
            Optional.ofNullable(this.getExDividendDate()).ifPresent(builder::setExDividendDate);
            Optional.ofNullable(this.getTradedFlatOfAccrued()).ifPresent(builder::setTradedFlatOfAccrued);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InstrumentTradePricing _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.quote, _that.getQuote())) {
                return false;
            }
            if (!Objects.equals(this.couponStartDate, _that.getCouponStartDate())) {
                return false;
            }
            if (!Objects.equals(this.exDividendDate, _that.getExDividendDate())) {
                return false;
            }
            return Objects.equals(this.tradedFlatOfAccrued, _that.getTradedFlatOfAccrued());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            _result = 31 * _result + (this.couponStartDate != null ? this.couponStartDate.hashCode() : 0);
            _result = 31 * _result + (this.exDividendDate != null ? this.exDividendDate.hashCode() : 0);
            _result = 31 * _result + (this.tradedFlatOfAccrued != null ? this.tradedFlatOfAccrued.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InstrumentTradePricing {quote=" + this.quote + ", couponStartDate=" + this.couponStartDate + ", exDividendDate=" + this.exDividendDate + ", tradedFlatOfAccrued=" + this.tradedFlatOfAccrued + '}';
        }
    }
}

