/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.meta.WeatherLegCalculationMeta;
import fpml.consolidated.fpmlenum.WeatherSettlementLevelEnum;
import fpml.consolidated.shared.BusinessCenter;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.Rounding;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="WeatherLegCalculation", builder=WeatherLegCalculationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="WeatherLegCalculation", model="fpml", builder=WeatherLegCalculationBuilderImpl.class, version="1.1.0")
public interface WeatherLegCalculation
extends RosettaModelObject {
    public static final WeatherLegCalculationMeta metaData = new WeatherLegCalculationMeta();

    public WeatherSettlementLevelEnum getSettlementLevel();

    public Boolean getReferenceLevelEqualsZero();

    public Period getCalculationDate();

    public BusinessCenter getBusinessDays();

    public Boolean getDataCorrection();

    public Period getCorrectionPeriod();

    public NonNegativeMoney getMaximumPaymentAmount();

    public NonNegativeMoney getMaximumTransactionPaymentAmount();

    public Rounding getRounding();

    public WeatherLegCalculation build();

    public WeatherLegCalculationBuilder toBuilder();

    public static WeatherLegCalculationBuilder builder() {
        return new WeatherLegCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends WeatherLegCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends WeatherLegCalculation> getType() {
        return WeatherLegCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("settlementLevel"), WeatherSettlementLevelEnum.class, (Object)this.getSettlementLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceLevelEqualsZero"), Boolean.class, (Object)this.getReferenceLevelEqualsZero(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("calculationDate"), processor, Period.class, this.getCalculationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessDays"), processor, BusinessCenter.class, this.getBusinessDays(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("dataCorrection"), Boolean.class, (Object)this.getDataCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correctionPeriod"), processor, Period.class, this.getCorrectionPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maximumPaymentAmount"), processor, NonNegativeMoney.class, this.getMaximumPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("maximumTransactionPaymentAmount"), processor, NonNegativeMoney.class, this.getMaximumTransactionPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, Rounding.class, this.getRounding(), new AttributeMeta[0]);
    }

    public static class WeatherLegCalculationBuilderImpl
    implements WeatherLegCalculationBuilder {
        protected WeatherSettlementLevelEnum settlementLevel;
        protected Boolean referenceLevelEqualsZero;
        protected Period.PeriodBuilder calculationDate;
        protected BusinessCenter.BusinessCenterBuilder businessDays;
        protected Boolean dataCorrection;
        protected Period.PeriodBuilder correctionPeriod;
        protected NonNegativeMoney.NonNegativeMoneyBuilder maximumPaymentAmount;
        protected NonNegativeMoney.NonNegativeMoneyBuilder maximumTransactionPaymentAmount;
        protected Rounding.RoundingBuilder rounding;

        @Override
        @RosettaAttribute(value="settlementLevel", isRequired=true)
        @RuneAttribute(value="settlementLevel", isRequired=true)
        public WeatherSettlementLevelEnum getSettlementLevel() {
            return this.settlementLevel;
        }

        @Override
        @RosettaAttribute(value="referenceLevelEqualsZero", isRequired=true)
        @RuneAttribute(value="referenceLevelEqualsZero", isRequired=true)
        public Boolean getReferenceLevelEqualsZero() {
            return this.referenceLevelEqualsZero;
        }

        @Override
        @RosettaAttribute(value="calculationDate")
        @RuneAttribute(value="calculationDate")
        public Period.PeriodBuilder getCalculationDate() {
            return this.calculationDate;
        }

        @Override
        public Period.PeriodBuilder getOrCreateCalculationDate() {
            Period.PeriodBuilder result = this.calculationDate != null ? this.calculationDate : (this.calculationDate = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessDays")
        @RuneAttribute(value="businessDays")
        public BusinessCenter.BusinessCenterBuilder getBusinessDays() {
            return this.businessDays;
        }

        @Override
        public BusinessCenter.BusinessCenterBuilder getOrCreateBusinessDays() {
            BusinessCenter.BusinessCenterBuilder result = this.businessDays != null ? this.businessDays : (this.businessDays = BusinessCenter.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dataCorrection")
        @RuneAttribute(value="dataCorrection")
        public Boolean getDataCorrection() {
            return this.dataCorrection;
        }

        @Override
        @RosettaAttribute(value="correctionPeriod")
        @RuneAttribute(value="correctionPeriod")
        public Period.PeriodBuilder getCorrectionPeriod() {
            return this.correctionPeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateCorrectionPeriod() {
            Period.PeriodBuilder result = this.correctionPeriod != null ? this.correctionPeriod : (this.correctionPeriod = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="maximumPaymentAmount")
        @RuneAttribute(value="maximumPaymentAmount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getMaximumPaymentAmount() {
            return this.maximumPaymentAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateMaximumPaymentAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.maximumPaymentAmount != null ? this.maximumPaymentAmount : (this.maximumPaymentAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="maximumTransactionPaymentAmount")
        @RuneAttribute(value="maximumTransactionPaymentAmount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getMaximumTransactionPaymentAmount() {
            return this.maximumTransactionPaymentAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateMaximumTransactionPaymentAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.maximumTransactionPaymentAmount != null ? this.maximumTransactionPaymentAmount : (this.maximumTransactionPaymentAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding.RoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public Rounding.RoundingBuilder getOrCreateRounding() {
            Rounding.RoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = Rounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementLevel", isRequired=true)
        @RuneAttribute(value="settlementLevel", isRequired=true)
        public WeatherLegCalculationBuilder setSettlementLevel(WeatherSettlementLevelEnum _settlementLevel) {
            this.settlementLevel = _settlementLevel == null ? null : _settlementLevel;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceLevelEqualsZero", isRequired=true)
        @RuneAttribute(value="referenceLevelEqualsZero", isRequired=true)
        public WeatherLegCalculationBuilder setReferenceLevelEqualsZero(Boolean _referenceLevelEqualsZero) {
            this.referenceLevelEqualsZero = _referenceLevelEqualsZero == null ? null : _referenceLevelEqualsZero;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationDate")
        @RuneAttribute(value="calculationDate")
        public WeatherLegCalculationBuilder setCalculationDate(Period _calculationDate) {
            this.calculationDate = _calculationDate == null ? null : _calculationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessDays")
        @RuneAttribute(value="businessDays")
        public WeatherLegCalculationBuilder setBusinessDays(BusinessCenter _businessDays) {
            this.businessDays = _businessDays == null ? null : _businessDays.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dataCorrection")
        @RuneAttribute(value="dataCorrection")
        public WeatherLegCalculationBuilder setDataCorrection(Boolean _dataCorrection) {
            this.dataCorrection = _dataCorrection == null ? null : _dataCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correctionPeriod")
        @RuneAttribute(value="correctionPeriod")
        public WeatherLegCalculationBuilder setCorrectionPeriod(Period _correctionPeriod) {
            this.correctionPeriod = _correctionPeriod == null ? null : _correctionPeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="maximumPaymentAmount")
        @RuneAttribute(value="maximumPaymentAmount")
        public WeatherLegCalculationBuilder setMaximumPaymentAmount(NonNegativeMoney _maximumPaymentAmount) {
            this.maximumPaymentAmount = _maximumPaymentAmount == null ? null : _maximumPaymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="maximumTransactionPaymentAmount")
        @RuneAttribute(value="maximumTransactionPaymentAmount")
        public WeatherLegCalculationBuilder setMaximumTransactionPaymentAmount(NonNegativeMoney _maximumTransactionPaymentAmount) {
            this.maximumTransactionPaymentAmount = _maximumTransactionPaymentAmount == null ? null : _maximumTransactionPaymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public WeatherLegCalculationBuilder setRounding(Rounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        public WeatherLegCalculation build() {
            return new WeatherLegCalculationImpl(this);
        }

        @Override
        public WeatherLegCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public WeatherLegCalculationBuilder prune() {
            if (this.calculationDate != null && !this.calculationDate.prune().hasData()) {
                this.calculationDate = null;
            }
            if (this.businessDays != null && !this.businessDays.prune().hasData()) {
                this.businessDays = null;
            }
            if (this.correctionPeriod != null && !this.correctionPeriod.prune().hasData()) {
                this.correctionPeriod = null;
            }
            if (this.maximumPaymentAmount != null && !this.maximumPaymentAmount.prune().hasData()) {
                this.maximumPaymentAmount = null;
            }
            if (this.maximumTransactionPaymentAmount != null && !this.maximumTransactionPaymentAmount.prune().hasData()) {
                this.maximumTransactionPaymentAmount = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementLevel() != null) {
                return true;
            }
            if (this.getReferenceLevelEqualsZero() != null) {
                return true;
            }
            if (this.getCalculationDate() != null && this.getCalculationDate().hasData()) {
                return true;
            }
            if (this.getBusinessDays() != null && this.getBusinessDays().hasData()) {
                return true;
            }
            if (this.getDataCorrection() != null) {
                return true;
            }
            if (this.getCorrectionPeriod() != null && this.getCorrectionPeriod().hasData()) {
                return true;
            }
            if (this.getMaximumPaymentAmount() != null && this.getMaximumPaymentAmount().hasData()) {
                return true;
            }
            if (this.getMaximumTransactionPaymentAmount() != null && this.getMaximumTransactionPaymentAmount().hasData()) {
                return true;
            }
            return this.getRounding() != null && this.getRounding().hasData();
        }

        public WeatherLegCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            WeatherLegCalculationBuilder o = (WeatherLegCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCalculationDate(), (RosettaModelObjectBuilder)o.getCalculationDate(), this::setCalculationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessDays(), (RosettaModelObjectBuilder)o.getBusinessDays(), this::setBusinessDays);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCorrectionPeriod(), (RosettaModelObjectBuilder)o.getCorrectionPeriod(), this::setCorrectionPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaximumPaymentAmount(), (RosettaModelObjectBuilder)o.getMaximumPaymentAmount(), this::setMaximumPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaximumTransactionPaymentAmount(), (RosettaModelObjectBuilder)o.getMaximumTransactionPaymentAmount(), this::setMaximumTransactionPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeBasic((Object)this.getSettlementLevel(), (Object)o.getSettlementLevel(), this::setSettlementLevel, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReferenceLevelEqualsZero(), (Object)o.getReferenceLevelEqualsZero(), this::setReferenceLevelEqualsZero, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDataCorrection(), (Object)o.getDataCorrection(), this::setDataCorrection, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WeatherLegCalculation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.settlementLevel, (Object)_that.getSettlementLevel())) {
                return false;
            }
            if (!Objects.equals(this.referenceLevelEqualsZero, _that.getReferenceLevelEqualsZero())) {
                return false;
            }
            if (!Objects.equals(this.calculationDate, _that.getCalculationDate())) {
                return false;
            }
            if (!Objects.equals(this.businessDays, _that.getBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.dataCorrection, _that.getDataCorrection())) {
                return false;
            }
            if (!Objects.equals(this.correctionPeriod, _that.getCorrectionPeriod())) {
                return false;
            }
            if (!Objects.equals(this.maximumPaymentAmount, _that.getMaximumPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.maximumTransactionPaymentAmount, _that.getMaximumTransactionPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.rounding, _that.getRounding());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementLevel != null ? ((Object)((Object)this.settlementLevel)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceLevelEqualsZero != null ? this.referenceLevelEqualsZero.hashCode() : 0);
            _result = 31 * _result + (this.calculationDate != null ? this.calculationDate.hashCode() : 0);
            _result = 31 * _result + (this.businessDays != null ? this.businessDays.hashCode() : 0);
            _result = 31 * _result + (this.dataCorrection != null ? this.dataCorrection.hashCode() : 0);
            _result = 31 * _result + (this.correctionPeriod != null ? this.correctionPeriod.hashCode() : 0);
            _result = 31 * _result + (this.maximumPaymentAmount != null ? this.maximumPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.maximumTransactionPaymentAmount != null ? this.maximumTransactionPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WeatherLegCalculationBuilder {settlementLevel=" + (Object)((Object)this.settlementLevel) + ", referenceLevelEqualsZero=" + this.referenceLevelEqualsZero + ", calculationDate=" + this.calculationDate + ", businessDays=" + this.businessDays + ", dataCorrection=" + this.dataCorrection + ", correctionPeriod=" + this.correctionPeriod + ", maximumPaymentAmount=" + this.maximumPaymentAmount + ", maximumTransactionPaymentAmount=" + this.maximumTransactionPaymentAmount + ", rounding=" + this.rounding + '}';
        }
    }

    public static interface WeatherLegCalculationBuilder
    extends WeatherLegCalculation,
    RosettaModelObjectBuilder {
        public Period.PeriodBuilder getOrCreateCalculationDate();

        @Override
        public Period.PeriodBuilder getCalculationDate();

        public BusinessCenter.BusinessCenterBuilder getOrCreateBusinessDays();

        @Override
        public BusinessCenter.BusinessCenterBuilder getBusinessDays();

        public Period.PeriodBuilder getOrCreateCorrectionPeriod();

        @Override
        public Period.PeriodBuilder getCorrectionPeriod();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateMaximumPaymentAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getMaximumPaymentAmount();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateMaximumTransactionPaymentAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getMaximumTransactionPaymentAmount();

        public Rounding.RoundingBuilder getOrCreateRounding();

        @Override
        public Rounding.RoundingBuilder getRounding();

        public WeatherLegCalculationBuilder setSettlementLevel(WeatherSettlementLevelEnum var1);

        public WeatherLegCalculationBuilder setReferenceLevelEqualsZero(Boolean var1);

        public WeatherLegCalculationBuilder setCalculationDate(Period var1);

        public WeatherLegCalculationBuilder setBusinessDays(BusinessCenter var1);

        public WeatherLegCalculationBuilder setDataCorrection(Boolean var1);

        public WeatherLegCalculationBuilder setCorrectionPeriod(Period var1);

        public WeatherLegCalculationBuilder setMaximumPaymentAmount(NonNegativeMoney var1);

        public WeatherLegCalculationBuilder setMaximumTransactionPaymentAmount(NonNegativeMoney var1);

        public WeatherLegCalculationBuilder setRounding(Rounding var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("settlementLevel"), WeatherSettlementLevelEnum.class, (Object)this.getSettlementLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceLevelEqualsZero"), Boolean.class, (Object)this.getReferenceLevelEqualsZero(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("calculationDate"), processor, Period.PeriodBuilder.class, this.getCalculationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessDays"), processor, BusinessCenter.BusinessCenterBuilder.class, this.getBusinessDays(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("dataCorrection"), Boolean.class, (Object)this.getDataCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correctionPeriod"), processor, Period.PeriodBuilder.class, this.getCorrectionPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maximumPaymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getMaximumPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("maximumTransactionPaymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getMaximumTransactionPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, Rounding.RoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
        }

        public WeatherLegCalculationBuilder prune();
    }

    public static class WeatherLegCalculationImpl
    implements WeatherLegCalculation {
        private final WeatherSettlementLevelEnum settlementLevel;
        private final Boolean referenceLevelEqualsZero;
        private final Period calculationDate;
        private final BusinessCenter businessDays;
        private final Boolean dataCorrection;
        private final Period correctionPeriod;
        private final NonNegativeMoney maximumPaymentAmount;
        private final NonNegativeMoney maximumTransactionPaymentAmount;
        private final Rounding rounding;

        protected WeatherLegCalculationImpl(WeatherLegCalculationBuilder builder) {
            this.settlementLevel = builder.getSettlementLevel();
            this.referenceLevelEqualsZero = builder.getReferenceLevelEqualsZero();
            this.calculationDate = Optional.ofNullable(builder.getCalculationDate()).map(f -> f.build()).orElse(null);
            this.businessDays = Optional.ofNullable(builder.getBusinessDays()).map(f -> f.build()).orElse(null);
            this.dataCorrection = builder.getDataCorrection();
            this.correctionPeriod = Optional.ofNullable(builder.getCorrectionPeriod()).map(f -> f.build()).orElse(null);
            this.maximumPaymentAmount = Optional.ofNullable(builder.getMaximumPaymentAmount()).map(f -> f.build()).orElse(null);
            this.maximumTransactionPaymentAmount = Optional.ofNullable(builder.getMaximumTransactionPaymentAmount()).map(f -> f.build()).orElse(null);
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementLevel", isRequired=true)
        @RuneAttribute(value="settlementLevel", isRequired=true)
        public WeatherSettlementLevelEnum getSettlementLevel() {
            return this.settlementLevel;
        }

        @Override
        @RosettaAttribute(value="referenceLevelEqualsZero", isRequired=true)
        @RuneAttribute(value="referenceLevelEqualsZero", isRequired=true)
        public Boolean getReferenceLevelEqualsZero() {
            return this.referenceLevelEqualsZero;
        }

        @Override
        @RosettaAttribute(value="calculationDate")
        @RuneAttribute(value="calculationDate")
        public Period getCalculationDate() {
            return this.calculationDate;
        }

        @Override
        @RosettaAttribute(value="businessDays")
        @RuneAttribute(value="businessDays")
        public BusinessCenter getBusinessDays() {
            return this.businessDays;
        }

        @Override
        @RosettaAttribute(value="dataCorrection")
        @RuneAttribute(value="dataCorrection")
        public Boolean getDataCorrection() {
            return this.dataCorrection;
        }

        @Override
        @RosettaAttribute(value="correctionPeriod")
        @RuneAttribute(value="correctionPeriod")
        public Period getCorrectionPeriod() {
            return this.correctionPeriod;
        }

        @Override
        @RosettaAttribute(value="maximumPaymentAmount")
        @RuneAttribute(value="maximumPaymentAmount")
        public NonNegativeMoney getMaximumPaymentAmount() {
            return this.maximumPaymentAmount;
        }

        @Override
        @RosettaAttribute(value="maximumTransactionPaymentAmount")
        @RuneAttribute(value="maximumTransactionPaymentAmount")
        public NonNegativeMoney getMaximumTransactionPaymentAmount() {
            return this.maximumTransactionPaymentAmount;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public Rounding getRounding() {
            return this.rounding;
        }

        @Override
        public WeatherLegCalculation build() {
            return this;
        }

        @Override
        public WeatherLegCalculationBuilder toBuilder() {
            WeatherLegCalculationBuilder builder = WeatherLegCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(WeatherLegCalculationBuilder builder) {
            Optional.ofNullable(this.getSettlementLevel()).ifPresent(builder::setSettlementLevel);
            Optional.ofNullable(this.getReferenceLevelEqualsZero()).ifPresent(builder::setReferenceLevelEqualsZero);
            Optional.ofNullable(this.getCalculationDate()).ifPresent(builder::setCalculationDate);
            Optional.ofNullable(this.getBusinessDays()).ifPresent(builder::setBusinessDays);
            Optional.ofNullable(this.getDataCorrection()).ifPresent(builder::setDataCorrection);
            Optional.ofNullable(this.getCorrectionPeriod()).ifPresent(builder::setCorrectionPeriod);
            Optional.ofNullable(this.getMaximumPaymentAmount()).ifPresent(builder::setMaximumPaymentAmount);
            Optional.ofNullable(this.getMaximumTransactionPaymentAmount()).ifPresent(builder::setMaximumTransactionPaymentAmount);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            WeatherLegCalculation _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.settlementLevel, (Object)_that.getSettlementLevel())) {
                return false;
            }
            if (!Objects.equals(this.referenceLevelEqualsZero, _that.getReferenceLevelEqualsZero())) {
                return false;
            }
            if (!Objects.equals(this.calculationDate, _that.getCalculationDate())) {
                return false;
            }
            if (!Objects.equals(this.businessDays, _that.getBusinessDays())) {
                return false;
            }
            if (!Objects.equals(this.dataCorrection, _that.getDataCorrection())) {
                return false;
            }
            if (!Objects.equals(this.correctionPeriod, _that.getCorrectionPeriod())) {
                return false;
            }
            if (!Objects.equals(this.maximumPaymentAmount, _that.getMaximumPaymentAmount())) {
                return false;
            }
            if (!Objects.equals(this.maximumTransactionPaymentAmount, _that.getMaximumTransactionPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.rounding, _that.getRounding());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementLevel != null ? ((Object)((Object)this.settlementLevel)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.referenceLevelEqualsZero != null ? this.referenceLevelEqualsZero.hashCode() : 0);
            _result = 31 * _result + (this.calculationDate != null ? this.calculationDate.hashCode() : 0);
            _result = 31 * _result + (this.businessDays != null ? this.businessDays.hashCode() : 0);
            _result = 31 * _result + (this.dataCorrection != null ? this.dataCorrection.hashCode() : 0);
            _result = 31 * _result + (this.correctionPeriod != null ? this.correctionPeriod.hashCode() : 0);
            _result = 31 * _result + (this.maximumPaymentAmount != null ? this.maximumPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.maximumTransactionPaymentAmount != null ? this.maximumTransactionPaymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WeatherLegCalculation {settlementLevel=" + (Object)((Object)this.settlementLevel) + ", referenceLevelEqualsZero=" + this.referenceLevelEqualsZero + ", calculationDate=" + this.calculationDate + ", businessDays=" + this.businessDays + ", dataCorrection=" + this.dataCorrection + ", correctionPeriod=" + this.correctionPeriod + ", maximumPaymentAmount=" + this.maximumPaymentAmount + ", maximumTransactionPaymentAmount=" + this.maximumTransactionPaymentAmount + ", rounding=" + this.rounding + '}';
        }
    }
}

