/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.CommodityClassification;
import fpml.consolidated.com.EEPParameters;
import fpml.consolidated.com.EnvironmentalProduct;
import fpml.consolidated.com.PhysicalSwapLeg;
import fpml.consolidated.com.UnitQuantity;
import fpml.consolidated.com.meta.EnvironmentalPhysicalLegMeta;
import fpml.consolidated.fpmlenum.EnvironmentalAbandonmentOfSchemeEnum;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.BusinessCentersOrReferenceModel;
import fpml.consolidated.shared.DateOffset;
import fpml.consolidated.shared.PayerReceiverModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EnvironmentalPhysicalLeg", builder=EnvironmentalPhysicalLegBuilderImpl.class, version="1.1.0")
@RuneDataType(value="EnvironmentalPhysicalLeg", model="fpml", builder=EnvironmentalPhysicalLegBuilderImpl.class, version="1.1.0")
public interface EnvironmentalPhysicalLeg
extends PhysicalSwapLeg {
    public static final EnvironmentalPhysicalLegMeta metaData = new EnvironmentalPhysicalLegMeta();

    public UnitQuantity getNumberOfAllowances();

    public EnvironmentalProduct getEnvironmental();

    public EnvironmentalAbandonmentOfSchemeEnum getAbandonmentOfScheme();

    public AdjustableOrRelativeDate getDeliveryDate();

    public DateOffset getPaymentDate();

    public BusinessCentersOrReferenceModel getBusinessCentersOrReferenceModel();

    public Boolean getFailureToDeliverApplicable();

    public EEPParameters getEEPParameters();

    @Override
    public EnvironmentalPhysicalLeg build();

    @Override
    public EnvironmentalPhysicalLegBuilder toBuilder();

    public static EnvironmentalPhysicalLegBuilder builder() {
        return new EnvironmentalPhysicalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends EnvironmentalPhysicalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EnvironmentalPhysicalLeg> getType() {
        return EnvironmentalPhysicalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("numberOfAllowances"), processor, UnitQuantity.class, this.getNumberOfAllowances(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("environmental"), processor, EnvironmentalProduct.class, this.getEnvironmental(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("abandonmentOfScheme"), EnvironmentalAbandonmentOfSchemeEnum.class, (Object)this.getAbandonmentOfScheme(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDate"), processor, AdjustableOrRelativeDate.class, this.getDeliveryDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, DateOffset.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCentersOrReferenceModel"), processor, BusinessCentersOrReferenceModel.class, this.getBusinessCentersOrReferenceModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("failureToDeliverApplicable"), Boolean.class, (Object)this.getFailureToDeliverApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eEPParameters"), processor, EEPParameters.class, this.getEEPParameters(), new AttributeMeta[0]);
    }

    public static class EnvironmentalPhysicalLegBuilderImpl
    extends PhysicalSwapLeg.PhysicalSwapLegBuilderImpl
    implements EnvironmentalPhysicalLegBuilder {
        protected UnitQuantity.UnitQuantityBuilder numberOfAllowances;
        protected EnvironmentalProduct.EnvironmentalProductBuilder environmental;
        protected EnvironmentalAbandonmentOfSchemeEnum abandonmentOfScheme;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder deliveryDate;
        protected DateOffset.DateOffsetBuilder paymentDate;
        protected BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder businessCentersOrReferenceModel;
        protected Boolean failureToDeliverApplicable;
        protected EEPParameters.EEPParametersBuilder eEPParameters;

        @Override
        @RosettaAttribute(value="numberOfAllowances", isRequired=true)
        @RuneAttribute(value="numberOfAllowances", isRequired=true)
        public UnitQuantity.UnitQuantityBuilder getNumberOfAllowances() {
            return this.numberOfAllowances;
        }

        @Override
        public UnitQuantity.UnitQuantityBuilder getOrCreateNumberOfAllowances() {
            UnitQuantity.UnitQuantityBuilder result = this.numberOfAllowances != null ? this.numberOfAllowances : (this.numberOfAllowances = UnitQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="environmental", isRequired=true)
        @RuneAttribute(value="environmental", isRequired=true)
        public EnvironmentalProduct.EnvironmentalProductBuilder getEnvironmental() {
            return this.environmental;
        }

        @Override
        public EnvironmentalProduct.EnvironmentalProductBuilder getOrCreateEnvironmental() {
            EnvironmentalProduct.EnvironmentalProductBuilder result = this.environmental != null ? this.environmental : (this.environmental = EnvironmentalProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="abandonmentOfScheme")
        @RuneAttribute(value="abandonmentOfScheme")
        public EnvironmentalAbandonmentOfSchemeEnum getAbandonmentOfScheme() {
            return this.abandonmentOfScheme;
        }

        @Override
        @RosettaAttribute(value="deliveryDate")
        @RuneAttribute(value="deliveryDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getDeliveryDate() {
            return this.deliveryDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateDeliveryDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.deliveryDate != null ? this.deliveryDate : (this.deliveryDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public DateOffset.DateOffsetBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public DateOffset.DateOffsetBuilder getOrCreatePaymentDate() {
            DateOffset.DateOffsetBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = DateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getBusinessCentersOrReferenceModel() {
            return this.businessCentersOrReferenceModel;
        }

        @Override
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getOrCreateBusinessCentersOrReferenceModel() {
            BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder result = this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel : (this.businessCentersOrReferenceModel = BusinessCentersOrReferenceModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="failureToDeliverApplicable")
        @RuneAttribute(value="failureToDeliverApplicable")
        public Boolean getFailureToDeliverApplicable() {
            return this.failureToDeliverApplicable;
        }

        @Override
        @RosettaAttribute(value="eEPParameters")
        @RuneAttribute(value="eEPParameters")
        public EEPParameters.EEPParametersBuilder getEEPParameters() {
            return this.eEPParameters;
        }

        @Override
        public EEPParameters.EEPParametersBuilder getOrCreateEEPParameters() {
            EEPParameters.EEPParametersBuilder result = this.eEPParameters != null ? this.eEPParameters : (this.eEPParameters = EEPParameters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EnvironmentalPhysicalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public EnvironmentalPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public EnvironmentalPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public EnvironmentalPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public EnvironmentalPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public EnvironmentalPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfAllowances", isRequired=true)
        @RuneAttribute(value="numberOfAllowances", isRequired=true)
        public EnvironmentalPhysicalLegBuilder setNumberOfAllowances(UnitQuantity _numberOfAllowances) {
            this.numberOfAllowances = _numberOfAllowances == null ? null : _numberOfAllowances.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="environmental", isRequired=true)
        @RuneAttribute(value="environmental", isRequired=true)
        public EnvironmentalPhysicalLegBuilder setEnvironmental(EnvironmentalProduct _environmental) {
            this.environmental = _environmental == null ? null : _environmental.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="abandonmentOfScheme")
        @RuneAttribute(value="abandonmentOfScheme")
        public EnvironmentalPhysicalLegBuilder setAbandonmentOfScheme(EnvironmentalAbandonmentOfSchemeEnum _abandonmentOfScheme) {
            this.abandonmentOfScheme = _abandonmentOfScheme == null ? null : _abandonmentOfScheme;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryDate")
        @RuneAttribute(value="deliveryDate")
        public EnvironmentalPhysicalLegBuilder setDeliveryDate(AdjustableOrRelativeDate _deliveryDate) {
            this.deliveryDate = _deliveryDate == null ? null : _deliveryDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public EnvironmentalPhysicalLegBuilder setPaymentDate(DateOffset _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public EnvironmentalPhysicalLegBuilder setBusinessCentersOrReferenceModel(BusinessCentersOrReferenceModel _businessCentersOrReferenceModel) {
            this.businessCentersOrReferenceModel = _businessCentersOrReferenceModel == null ? null : _businessCentersOrReferenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="failureToDeliverApplicable")
        @RuneAttribute(value="failureToDeliverApplicable")
        public EnvironmentalPhysicalLegBuilder setFailureToDeliverApplicable(Boolean _failureToDeliverApplicable) {
            this.failureToDeliverApplicable = _failureToDeliverApplicable == null ? null : _failureToDeliverApplicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="eEPParameters")
        @RuneAttribute(value="eEPParameters")
        public EnvironmentalPhysicalLegBuilder setEEPParameters(EEPParameters _eEPParameters) {
            this.eEPParameters = _eEPParameters == null ? null : _eEPParameters.toBuilder();
            return this;
        }

        @Override
        public EnvironmentalPhysicalLeg build() {
            return new EnvironmentalPhysicalLegImpl(this);
        }

        @Override
        public EnvironmentalPhysicalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public EnvironmentalPhysicalLegBuilder prune() {
            super.prune();
            if (this.numberOfAllowances != null && !this.numberOfAllowances.prune().hasData()) {
                this.numberOfAllowances = null;
            }
            if (this.environmental != null && !this.environmental.prune().hasData()) {
                this.environmental = null;
            }
            if (this.deliveryDate != null && !this.deliveryDate.prune().hasData()) {
                this.deliveryDate = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.businessCentersOrReferenceModel != null && !this.businessCentersOrReferenceModel.prune().hasData()) {
                this.businessCentersOrReferenceModel = null;
            }
            if (this.eEPParameters != null && !this.eEPParameters.prune().hasData()) {
                this.eEPParameters = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getNumberOfAllowances() != null && this.getNumberOfAllowances().hasData()) {
                return true;
            }
            if (this.getEnvironmental() != null && this.getEnvironmental().hasData()) {
                return true;
            }
            if (this.getAbandonmentOfScheme() != null) {
                return true;
            }
            if (this.getDeliveryDate() != null && this.getDeliveryDate().hasData()) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            if (this.getBusinessCentersOrReferenceModel() != null && this.getBusinessCentersOrReferenceModel().hasData()) {
                return true;
            }
            if (this.getFailureToDeliverApplicable() != null) {
                return true;
            }
            return this.getEEPParameters() != null && this.getEEPParameters().hasData();
        }

        @Override
        public EnvironmentalPhysicalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EnvironmentalPhysicalLegBuilder o = (EnvironmentalPhysicalLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNumberOfAllowances(), (RosettaModelObjectBuilder)o.getNumberOfAllowances(), this::setNumberOfAllowances);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEnvironmental(), (RosettaModelObjectBuilder)o.getEnvironmental(), this::setEnvironmental);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDate(), (RosettaModelObjectBuilder)o.getDeliveryDate(), this::setDeliveryDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCentersOrReferenceModel(), (RosettaModelObjectBuilder)o.getBusinessCentersOrReferenceModel(), this::setBusinessCentersOrReferenceModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEEPParameters(), (RosettaModelObjectBuilder)o.getEEPParameters(), this::setEEPParameters);
            merger.mergeBasic((Object)this.getAbandonmentOfScheme(), (Object)o.getAbandonmentOfScheme(), this::setAbandonmentOfScheme, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFailureToDeliverApplicable(), (Object)o.getFailureToDeliverApplicable(), this::setFailureToDeliverApplicable, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EnvironmentalPhysicalLeg _that = (EnvironmentalPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.numberOfAllowances, _that.getNumberOfAllowances())) {
                return false;
            }
            if (!Objects.equals(this.environmental, _that.getEnvironmental())) {
                return false;
            }
            if (!Objects.equals((Object)this.abandonmentOfScheme, (Object)_that.getAbandonmentOfScheme())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDate, _that.getDeliveryDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersOrReferenceModel, _that.getBusinessCentersOrReferenceModel())) {
                return false;
            }
            if (!Objects.equals(this.failureToDeliverApplicable, _that.getFailureToDeliverApplicable())) {
                return false;
            }
            return Objects.equals(this.eEPParameters, _that.getEEPParameters());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.numberOfAllowances != null ? this.numberOfAllowances.hashCode() : 0);
            _result = 31 * _result + (this.environmental != null ? this.environmental.hashCode() : 0);
            _result = 31 * _result + (this.abandonmentOfScheme != null ? ((Object)((Object)this.abandonmentOfScheme)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryDate != null ? this.deliveryDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.failureToDeliverApplicable != null ? this.failureToDeliverApplicable.hashCode() : 0);
            _result = 31 * _result + (this.eEPParameters != null ? this.eEPParameters.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EnvironmentalPhysicalLegBuilder {numberOfAllowances=" + this.numberOfAllowances + ", environmental=" + this.environmental + ", abandonmentOfScheme=" + (Object)((Object)this.abandonmentOfScheme) + ", deliveryDate=" + this.deliveryDate + ", paymentDate=" + this.paymentDate + ", businessCentersOrReferenceModel=" + this.businessCentersOrReferenceModel + ", failureToDeliverApplicable=" + this.failureToDeliverApplicable + ", eEPParameters=" + this.eEPParameters + '}' + " " + super.toString();
        }
    }

    public static interface EnvironmentalPhysicalLegBuilder
    extends EnvironmentalPhysicalLeg,
    PhysicalSwapLeg.PhysicalSwapLegBuilder {
        public UnitQuantity.UnitQuantityBuilder getOrCreateNumberOfAllowances();

        @Override
        public UnitQuantity.UnitQuantityBuilder getNumberOfAllowances();

        public EnvironmentalProduct.EnvironmentalProductBuilder getOrCreateEnvironmental();

        @Override
        public EnvironmentalProduct.EnvironmentalProductBuilder getEnvironmental();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateDeliveryDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getDeliveryDate();

        public DateOffset.DateOffsetBuilder getOrCreatePaymentDate();

        @Override
        public DateOffset.DateOffsetBuilder getPaymentDate();

        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getOrCreateBusinessCentersOrReferenceModel();

        @Override
        public BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder getBusinessCentersOrReferenceModel();

        public EEPParameters.EEPParametersBuilder getOrCreateEEPParameters();

        @Override
        public EEPParameters.EEPParametersBuilder getEEPParameters();

        @Override
        public EnvironmentalPhysicalLegBuilder setId(String var1);

        @Override
        public EnvironmentalPhysicalLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public EnvironmentalPhysicalLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public EnvironmentalPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public EnvironmentalPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public EnvironmentalPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public EnvironmentalPhysicalLegBuilder setNumberOfAllowances(UnitQuantity var1);

        public EnvironmentalPhysicalLegBuilder setEnvironmental(EnvironmentalProduct var1);

        public EnvironmentalPhysicalLegBuilder setAbandonmentOfScheme(EnvironmentalAbandonmentOfSchemeEnum var1);

        public EnvironmentalPhysicalLegBuilder setDeliveryDate(AdjustableOrRelativeDate var1);

        public EnvironmentalPhysicalLegBuilder setPaymentDate(DateOffset var1);

        public EnvironmentalPhysicalLegBuilder setBusinessCentersOrReferenceModel(BusinessCentersOrReferenceModel var1);

        public EnvironmentalPhysicalLegBuilder setFailureToDeliverApplicable(Boolean var1);

        public EnvironmentalPhysicalLegBuilder setEEPParameters(EEPParameters var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("numberOfAllowances"), processor, UnitQuantity.UnitQuantityBuilder.class, this.getNumberOfAllowances(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("environmental"), processor, EnvironmentalProduct.EnvironmentalProductBuilder.class, this.getEnvironmental(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("abandonmentOfScheme"), EnvironmentalAbandonmentOfSchemeEnum.class, (Object)this.getAbandonmentOfScheme(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getDeliveryDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, DateOffset.DateOffsetBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCentersOrReferenceModel"), processor, BusinessCentersOrReferenceModel.BusinessCentersOrReferenceModelBuilder.class, this.getBusinessCentersOrReferenceModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("failureToDeliverApplicable"), Boolean.class, (Object)this.getFailureToDeliverApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eEPParameters"), processor, EEPParameters.EEPParametersBuilder.class, this.getEEPParameters(), new AttributeMeta[0]);
        }

        @Override
        public EnvironmentalPhysicalLegBuilder prune();
    }

    public static class EnvironmentalPhysicalLegImpl
    extends PhysicalSwapLeg.PhysicalSwapLegImpl
    implements EnvironmentalPhysicalLeg {
        private final UnitQuantity numberOfAllowances;
        private final EnvironmentalProduct environmental;
        private final EnvironmentalAbandonmentOfSchemeEnum abandonmentOfScheme;
        private final AdjustableOrRelativeDate deliveryDate;
        private final DateOffset paymentDate;
        private final BusinessCentersOrReferenceModel businessCentersOrReferenceModel;
        private final Boolean failureToDeliverApplicable;
        private final EEPParameters eEPParameters;

        protected EnvironmentalPhysicalLegImpl(EnvironmentalPhysicalLegBuilder builder) {
            super(builder);
            this.numberOfAllowances = Optional.ofNullable(builder.getNumberOfAllowances()).map(f -> f.build()).orElse(null);
            this.environmental = Optional.ofNullable(builder.getEnvironmental()).map(f -> f.build()).orElse(null);
            this.abandonmentOfScheme = builder.getAbandonmentOfScheme();
            this.deliveryDate = Optional.ofNullable(builder.getDeliveryDate()).map(f -> f.build()).orElse(null);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.businessCentersOrReferenceModel = Optional.ofNullable(builder.getBusinessCentersOrReferenceModel()).map(f -> f.build()).orElse(null);
            this.failureToDeliverApplicable = builder.getFailureToDeliverApplicable();
            this.eEPParameters = Optional.ofNullable(builder.getEEPParameters()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="numberOfAllowances", isRequired=true)
        @RuneAttribute(value="numberOfAllowances", isRequired=true)
        public UnitQuantity getNumberOfAllowances() {
            return this.numberOfAllowances;
        }

        @Override
        @RosettaAttribute(value="environmental", isRequired=true)
        @RuneAttribute(value="environmental", isRequired=true)
        public EnvironmentalProduct getEnvironmental() {
            return this.environmental;
        }

        @Override
        @RosettaAttribute(value="abandonmentOfScheme")
        @RuneAttribute(value="abandonmentOfScheme")
        public EnvironmentalAbandonmentOfSchemeEnum getAbandonmentOfScheme() {
            return this.abandonmentOfScheme;
        }

        @Override
        @RosettaAttribute(value="deliveryDate")
        @RuneAttribute(value="deliveryDate")
        public AdjustableOrRelativeDate getDeliveryDate() {
            return this.deliveryDate;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public DateOffset getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="businessCentersOrReferenceModel")
        @RuneAttribute(value="businessCentersOrReferenceModel")
        public BusinessCentersOrReferenceModel getBusinessCentersOrReferenceModel() {
            return this.businessCentersOrReferenceModel;
        }

        @Override
        @RosettaAttribute(value="failureToDeliverApplicable")
        @RuneAttribute(value="failureToDeliverApplicable")
        public Boolean getFailureToDeliverApplicable() {
            return this.failureToDeliverApplicable;
        }

        @Override
        @RosettaAttribute(value="eEPParameters")
        @RuneAttribute(value="eEPParameters")
        public EEPParameters getEEPParameters() {
            return this.eEPParameters;
        }

        @Override
        public EnvironmentalPhysicalLeg build() {
            return this;
        }

        @Override
        public EnvironmentalPhysicalLegBuilder toBuilder() {
            EnvironmentalPhysicalLegBuilder builder = EnvironmentalPhysicalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EnvironmentalPhysicalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getNumberOfAllowances()).ifPresent(builder::setNumberOfAllowances);
            Optional.ofNullable(this.getEnvironmental()).ifPresent(builder::setEnvironmental);
            Optional.ofNullable(this.getAbandonmentOfScheme()).ifPresent(builder::setAbandonmentOfScheme);
            Optional.ofNullable(this.getDeliveryDate()).ifPresent(builder::setDeliveryDate);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getBusinessCentersOrReferenceModel()).ifPresent(builder::setBusinessCentersOrReferenceModel);
            Optional.ofNullable(this.getFailureToDeliverApplicable()).ifPresent(builder::setFailureToDeliverApplicable);
            Optional.ofNullable(this.getEEPParameters()).ifPresent(builder::setEEPParameters);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EnvironmentalPhysicalLeg _that = (EnvironmentalPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.numberOfAllowances, _that.getNumberOfAllowances())) {
                return false;
            }
            if (!Objects.equals(this.environmental, _that.getEnvironmental())) {
                return false;
            }
            if (!Objects.equals((Object)this.abandonmentOfScheme, (Object)_that.getAbandonmentOfScheme())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDate, _that.getDeliveryDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.businessCentersOrReferenceModel, _that.getBusinessCentersOrReferenceModel())) {
                return false;
            }
            if (!Objects.equals(this.failureToDeliverApplicable, _that.getFailureToDeliverApplicable())) {
                return false;
            }
            return Objects.equals(this.eEPParameters, _that.getEEPParameters());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.numberOfAllowances != null ? this.numberOfAllowances.hashCode() : 0);
            _result = 31 * _result + (this.environmental != null ? this.environmental.hashCode() : 0);
            _result = 31 * _result + (this.abandonmentOfScheme != null ? ((Object)((Object)this.abandonmentOfScheme)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryDate != null ? this.deliveryDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.businessCentersOrReferenceModel != null ? this.businessCentersOrReferenceModel.hashCode() : 0);
            _result = 31 * _result + (this.failureToDeliverApplicable != null ? this.failureToDeliverApplicable.hashCode() : 0);
            _result = 31 * _result + (this.eEPParameters != null ? this.eEPParameters.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EnvironmentalPhysicalLeg {numberOfAllowances=" + this.numberOfAllowances + ", environmental=" + this.environmental + ", abandonmentOfScheme=" + (Object)((Object)this.abandonmentOfScheme) + ", deliveryDate=" + this.deliveryDate + ", paymentDate=" + this.paymentDate + ", businessCentersOrReferenceModel=" + this.businessCentersOrReferenceModel + ", failureToDeliverApplicable=" + this.failureToDeliverApplicable + ", eEPParameters=" + this.eEPParameters + '}' + " " + super.toString();
        }
    }
}

