/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.QuantityUnit;
import fpml.consolidated.com.CommodityNotionalQuantity;
import fpml.consolidated.com.CommodityQuantityFrequency;
import fpml.consolidated.com.SettlementPeriodsReference;
import fpml.consolidated.com.meta.ElectricityPhysicalDeliveryQuantityMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ElectricityPhysicalDeliveryQuantity", builder=ElectricityPhysicalDeliveryQuantityBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ElectricityPhysicalDeliveryQuantity", model="fpml", builder=ElectricityPhysicalDeliveryQuantityBuilderImpl.class, version="1.1.0")
public interface ElectricityPhysicalDeliveryQuantity
extends CommodityNotionalQuantity {
    public static final ElectricityPhysicalDeliveryQuantityMeta metaData = new ElectricityPhysicalDeliveryQuantityMeta();

    public List<? extends SettlementPeriodsReference> getSettlementPeriodsReference();

    @Override
    public ElectricityPhysicalDeliveryQuantity build();

    @Override
    public ElectricityPhysicalDeliveryQuantityBuilder toBuilder();

    public static ElectricityPhysicalDeliveryQuantityBuilder builder() {
        return new ElectricityPhysicalDeliveryQuantityBuilderImpl();
    }

    default public RosettaMetaData<? extends ElectricityPhysicalDeliveryQuantity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ElectricityPhysicalDeliveryQuantity> getType() {
        return ElectricityPhysicalDeliveryQuantity.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quantityUnit"), processor, QuantityUnit.class, this.getQuantityUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quantityFrequency"), processor, CommodityQuantityFrequency.class, this.getQuantityFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, (Object)this.getQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodsReference"), processor, SettlementPeriodsReference.class, this.getSettlementPeriodsReference(), new AttributeMeta[0]);
    }

    public static class ElectricityPhysicalDeliveryQuantityBuilderImpl
    extends CommodityNotionalQuantity.CommodityNotionalQuantityBuilderImpl
    implements ElectricityPhysicalDeliveryQuantityBuilder {
        protected List<SettlementPeriodsReference.SettlementPeriodsReferenceBuilder> settlementPeriodsReference = new ArrayList<SettlementPeriodsReference.SettlementPeriodsReferenceBuilder>();

        @Override
        @RosettaAttribute(value="settlementPeriodsReference")
        @RuneAttribute(value="settlementPeriodsReference")
        public List<? extends SettlementPeriodsReference.SettlementPeriodsReferenceBuilder> getSettlementPeriodsReference() {
            return this.settlementPeriodsReference;
        }

        @Override
        public SettlementPeriodsReference.SettlementPeriodsReferenceBuilder getOrCreateSettlementPeriodsReference(int index) {
            if (this.settlementPeriodsReference == null) {
                this.settlementPeriodsReference = new ArrayList<SettlementPeriodsReference.SettlementPeriodsReferenceBuilder>();
            }
            return (SettlementPeriodsReference.SettlementPeriodsReferenceBuilder)this.getIndex(this.settlementPeriodsReference, index, () -> {
                SettlementPeriodsReference.SettlementPeriodsReferenceBuilder newSettlementPeriodsReference = SettlementPeriodsReference.builder();
                return newSettlementPeriodsReference;
            });
        }

        @Override
        @RosettaAttribute(value="quantityUnit", isRequired=true)
        @RuneAttribute(value="quantityUnit", isRequired=true)
        public ElectricityPhysicalDeliveryQuantityBuilder setQuantityUnit(QuantityUnit _quantityUnit) {
            this.quantityUnit = _quantityUnit == null ? null : _quantityUnit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public ElectricityPhysicalDeliveryQuantityBuilder setQuantityFrequency(CommodityQuantityFrequency _quantityFrequency) {
            this.quantityFrequency = _quantityFrequency == null ? null : _quantityFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public ElectricityPhysicalDeliveryQuantityBuilder setQuantity(BigDecimal _quantity) {
            this.quantity = _quantity == null ? null : _quantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ElectricityPhysicalDeliveryQuantityBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsReference")
        @RuneAttribute(value="settlementPeriodsReference")
        public ElectricityPhysicalDeliveryQuantityBuilder addSettlementPeriodsReference(SettlementPeriodsReference _settlementPeriodsReference) {
            if (_settlementPeriodsReference != null) {
                this.settlementPeriodsReference.add(_settlementPeriodsReference.toBuilder());
            }
            return this;
        }

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder addSettlementPeriodsReference(SettlementPeriodsReference _settlementPeriodsReference, int idx) {
            this.getIndex(this.settlementPeriodsReference, idx, () -> _settlementPeriodsReference.toBuilder());
            return this;
        }

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder addSettlementPeriodsReference(List<? extends SettlementPeriodsReference> settlementPeriodsReferences) {
            if (settlementPeriodsReferences != null) {
                for (SettlementPeriodsReference settlementPeriodsReference : settlementPeriodsReferences) {
                    this.settlementPeriodsReference.add(settlementPeriodsReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="settlementPeriodsReference")
        public ElectricityPhysicalDeliveryQuantityBuilder setSettlementPeriodsReference(List<? extends SettlementPeriodsReference> settlementPeriodsReferences) {
            this.settlementPeriodsReference = settlementPeriodsReferences == null ? new ArrayList<SettlementPeriodsReference.SettlementPeriodsReferenceBuilder>() : (List)settlementPeriodsReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ElectricityPhysicalDeliveryQuantity build() {
            return new ElectricityPhysicalDeliveryQuantityImpl(this);
        }

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder toBuilder() {
            return this;
        }

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder prune() {
            super.prune();
            this.settlementPeriodsReference = this.settlementPeriodsReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getSettlementPeriodsReference() != null && this.getSettlementPeriodsReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ElectricityPhysicalDeliveryQuantityBuilder o = (ElectricityPhysicalDeliveryQuantityBuilder)other;
            merger.mergeRosetta(this.getSettlementPeriodsReference(), o.getSettlementPeriodsReference(), this::getOrCreateSettlementPeriodsReference);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ElectricityPhysicalDeliveryQuantity _that = (ElectricityPhysicalDeliveryQuantity)this.getType().cast(o);
            return ListEquals.listEquals(this.settlementPeriodsReference, _that.getSettlementPeriodsReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementPeriodsReference != null ? this.settlementPeriodsReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ElectricityPhysicalDeliveryQuantityBuilder {settlementPeriodsReference=" + this.settlementPeriodsReference + '}' + " " + super.toString();
        }
    }

    public static interface ElectricityPhysicalDeliveryQuantityBuilder
    extends ElectricityPhysicalDeliveryQuantity,
    CommodityNotionalQuantity.CommodityNotionalQuantityBuilder {
        public SettlementPeriodsReference.SettlementPeriodsReferenceBuilder getOrCreateSettlementPeriodsReference(int var1);

        public List<? extends SettlementPeriodsReference.SettlementPeriodsReferenceBuilder> getSettlementPeriodsReference();

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder setQuantityUnit(QuantityUnit var1);

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder setQuantityFrequency(CommodityQuantityFrequency var1);

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder setQuantity(BigDecimal var1);

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder setId(String var1);

        public ElectricityPhysicalDeliveryQuantityBuilder addSettlementPeriodsReference(SettlementPeriodsReference var1);

        public ElectricityPhysicalDeliveryQuantityBuilder addSettlementPeriodsReference(SettlementPeriodsReference var1, int var2);

        public ElectricityPhysicalDeliveryQuantityBuilder addSettlementPeriodsReference(List<? extends SettlementPeriodsReference> var1);

        public ElectricityPhysicalDeliveryQuantityBuilder setSettlementPeriodsReference(List<? extends SettlementPeriodsReference> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quantityUnit"), processor, QuantityUnit.QuantityUnitBuilder.class, (RosettaModelObjectBuilder)this.getQuantityUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quantityFrequency"), processor, CommodityQuantityFrequency.CommodityQuantityFrequencyBuilder.class, (RosettaModelObjectBuilder)this.getQuantityFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantity"), BigDecimal.class, (Object)this.getQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodsReference"), processor, SettlementPeriodsReference.SettlementPeriodsReferenceBuilder.class, this.getSettlementPeriodsReference(), new AttributeMeta[0]);
        }

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder prune();
    }

    public static class ElectricityPhysicalDeliveryQuantityImpl
    extends CommodityNotionalQuantity.CommodityNotionalQuantityImpl
    implements ElectricityPhysicalDeliveryQuantity {
        private final List<? extends SettlementPeriodsReference> settlementPeriodsReference;

        protected ElectricityPhysicalDeliveryQuantityImpl(ElectricityPhysicalDeliveryQuantityBuilder builder) {
            super(builder);
            this.settlementPeriodsReference = Optional.ofNullable(builder.getSettlementPeriodsReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsReference")
        @RuneAttribute(value="settlementPeriodsReference")
        public List<? extends SettlementPeriodsReference> getSettlementPeriodsReference() {
            return this.settlementPeriodsReference;
        }

        @Override
        public ElectricityPhysicalDeliveryQuantity build() {
            return this;
        }

        @Override
        public ElectricityPhysicalDeliveryQuantityBuilder toBuilder() {
            ElectricityPhysicalDeliveryQuantityBuilder builder = ElectricityPhysicalDeliveryQuantity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ElectricityPhysicalDeliveryQuantityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSettlementPeriodsReference()).ifPresent(builder::setSettlementPeriodsReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ElectricityPhysicalDeliveryQuantity _that = (ElectricityPhysicalDeliveryQuantity)this.getType().cast(o);
            return ListEquals.listEquals(this.settlementPeriodsReference, _that.getSettlementPeriodsReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.settlementPeriodsReference != null ? this.settlementPeriodsReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ElectricityPhysicalDeliveryQuantity {settlementPeriodsReference=" + this.settlementPeriodsReference + '}' + " " + super.toString();
        }
    }
}

