/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.QuantityUnit;
import fpml.consolidated.com.meta.CommoditySpreadMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.Money;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommoditySpread", builder=CommoditySpreadBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommoditySpread", model="fpml", builder=CommoditySpreadBuilderImpl.class, version="1.1.0")
public interface CommoditySpread
extends Money {
    public static final CommoditySpreadMeta metaData = new CommoditySpreadMeta();

    public BigDecimal getSpreadConversionFactor();

    public QuantityUnit getSpreadUnit();

    @Override
    public CommoditySpread build();

    @Override
    public CommoditySpreadBuilder toBuilder();

    public static CommoditySpreadBuilder builder() {
        return new CommoditySpreadBuilderImpl();
    }

    default public RosettaMetaData<? extends CommoditySpread> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommoditySpread> getType() {
        return CommoditySpread.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadConversionFactor"), BigDecimal.class, (Object)this.getSpreadConversionFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spreadUnit"), processor, QuantityUnit.class, this.getSpreadUnit(), new AttributeMeta[0]);
    }

    public static class CommoditySpreadBuilderImpl
    extends Money.MoneyBuilderImpl
    implements CommoditySpreadBuilder {
        protected BigDecimal spreadConversionFactor;
        protected QuantityUnit.QuantityUnitBuilder spreadUnit;

        @Override
        @RosettaAttribute(value="spreadConversionFactor")
        @RuneAttribute(value="spreadConversionFactor")
        public BigDecimal getSpreadConversionFactor() {
            return this.spreadConversionFactor;
        }

        @Override
        @RosettaAttribute(value="spreadUnit")
        @RuneAttribute(value="spreadUnit")
        public QuantityUnit.QuantityUnitBuilder getSpreadUnit() {
            return this.spreadUnit;
        }

        @Override
        public QuantityUnit.QuantityUnitBuilder getOrCreateSpreadUnit() {
            QuantityUnit.QuantityUnitBuilder result = this.spreadUnit != null ? this.spreadUnit : (this.spreadUnit = QuantityUnit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currency", isRequired=true)
        @RuneAttribute(value="currency", isRequired=true)
        public CommoditySpreadBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public CommoditySpreadBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public CommoditySpreadBuilder setAmount(BigDecimal _amount) {
            this.amount = _amount == null ? null : _amount;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadConversionFactor")
        @RuneAttribute(value="spreadConversionFactor")
        public CommoditySpreadBuilder setSpreadConversionFactor(BigDecimal _spreadConversionFactor) {
            this.spreadConversionFactor = _spreadConversionFactor == null ? null : _spreadConversionFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadUnit")
        @RuneAttribute(value="spreadUnit")
        public CommoditySpreadBuilder setSpreadUnit(QuantityUnit _spreadUnit) {
            this.spreadUnit = _spreadUnit == null ? null : _spreadUnit.toBuilder();
            return this;
        }

        @Override
        public CommoditySpread build() {
            return new CommoditySpreadImpl(this);
        }

        @Override
        public CommoditySpreadBuilder toBuilder() {
            return this;
        }

        @Override
        public CommoditySpreadBuilder prune() {
            super.prune();
            if (this.spreadUnit != null && !this.spreadUnit.prune().hasData()) {
                this.spreadUnit = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSpreadConversionFactor() != null) {
                return true;
            }
            return this.getSpreadUnit() != null && this.getSpreadUnit().hasData();
        }

        @Override
        public CommoditySpreadBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommoditySpreadBuilder o = (CommoditySpreadBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpreadUnit(), (RosettaModelObjectBuilder)o.getSpreadUnit(), this::setSpreadUnit);
            merger.mergeBasic((Object)this.getSpreadConversionFactor(), (Object)o.getSpreadConversionFactor(), this::setSpreadConversionFactor, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommoditySpread _that = (CommoditySpread)this.getType().cast(o);
            if (!Objects.equals(this.spreadConversionFactor, _that.getSpreadConversionFactor())) {
                return false;
            }
            return Objects.equals(this.spreadUnit, _that.getSpreadUnit());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.spreadConversionFactor != null ? this.spreadConversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.spreadUnit != null ? this.spreadUnit.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommoditySpreadBuilder {spreadConversionFactor=" + this.spreadConversionFactor + ", spreadUnit=" + this.spreadUnit + '}' + " " + super.toString();
        }
    }

    public static interface CommoditySpreadBuilder
    extends CommoditySpread,
    Money.MoneyBuilder {
        public QuantityUnit.QuantityUnitBuilder getOrCreateSpreadUnit();

        @Override
        public QuantityUnit.QuantityUnitBuilder getSpreadUnit();

        @Override
        public CommoditySpreadBuilder setCurrency(Currency var1);

        @Override
        public CommoditySpreadBuilder setId(String var1);

        @Override
        public CommoditySpreadBuilder setAmount(BigDecimal var1);

        public CommoditySpreadBuilder setSpreadConversionFactor(BigDecimal var1);

        public CommoditySpreadBuilder setSpreadUnit(QuantityUnit var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amount"), BigDecimal.class, (Object)this.getAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadConversionFactor"), BigDecimal.class, (Object)this.getSpreadConversionFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spreadUnit"), processor, QuantityUnit.QuantityUnitBuilder.class, this.getSpreadUnit(), new AttributeMeta[0]);
        }

        @Override
        public CommoditySpreadBuilder prune();
    }

    public static class CommoditySpreadImpl
    extends Money.MoneyImpl
    implements CommoditySpread {
        private final BigDecimal spreadConversionFactor;
        private final QuantityUnit spreadUnit;

        protected CommoditySpreadImpl(CommoditySpreadBuilder builder) {
            super(builder);
            this.spreadConversionFactor = builder.getSpreadConversionFactor();
            this.spreadUnit = Optional.ofNullable(builder.getSpreadUnit()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="spreadConversionFactor")
        @RuneAttribute(value="spreadConversionFactor")
        public BigDecimal getSpreadConversionFactor() {
            return this.spreadConversionFactor;
        }

        @Override
        @RosettaAttribute(value="spreadUnit")
        @RuneAttribute(value="spreadUnit")
        public QuantityUnit getSpreadUnit() {
            return this.spreadUnit;
        }

        @Override
        public CommoditySpread build() {
            return this;
        }

        @Override
        public CommoditySpreadBuilder toBuilder() {
            CommoditySpreadBuilder builder = CommoditySpread.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommoditySpreadBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSpreadConversionFactor()).ifPresent(builder::setSpreadConversionFactor);
            Optional.ofNullable(this.getSpreadUnit()).ifPresent(builder::setSpreadUnit);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommoditySpread _that = (CommoditySpread)this.getType().cast(o);
            if (!Objects.equals(this.spreadConversionFactor, _that.getSpreadConversionFactor())) {
                return false;
            }
            return Objects.equals(this.spreadUnit, _that.getSpreadUnit());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.spreadConversionFactor != null ? this.spreadConversionFactor.hashCode() : 0);
            _result = 31 * _result + (this.spreadUnit != null ? this.spreadUnit.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommoditySpread {spreadConversionFactor=" + this.spreadConversionFactor + ", spreadUnit=" + this.spreadUnit + '}' + " " + super.toString();
        }
    }
}

