/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.com;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.com.meta.CommodityFixedInterestCalculationMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.IdentifiedRate;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommodityFixedInterestCalculation", builder=CommodityFixedInterestCalculationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="CommodityFixedInterestCalculation", model="fpml", builder=CommodityFixedInterestCalculationBuilderImpl.class, version="1.1.0")
public interface CommodityFixedInterestCalculation
extends RosettaModelObject {
    public static final CommodityFixedInterestCalculationMeta metaData = new CommodityFixedInterestCalculationMeta();

    public IdentifiedRate getFixedRate();

    public DayCountFraction getDayCountFraction();

    public CommodityFixedInterestCalculation build();

    public CommodityFixedInterestCalculationBuilder toBuilder();

    public static CommodityFixedInterestCalculationBuilder builder() {
        return new CommodityFixedInterestCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityFixedInterestCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityFixedInterestCalculation> getType() {
        return CommodityFixedInterestCalculation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fixedRate"), processor, IdentifiedRate.class, this.getFixedRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
    }

    public static class CommodityFixedInterestCalculationBuilderImpl
    implements CommodityFixedInterestCalculationBuilder {
        protected IdentifiedRate.IdentifiedRateBuilder fixedRate;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public IdentifiedRate.IdentifiedRateBuilder getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public IdentifiedRate.IdentifiedRateBuilder getOrCreateFixedRate() {
            IdentifiedRate.IdentifiedRateBuilder result = this.fixedRate != null ? this.fixedRate : (this.fixedRate = IdentifiedRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public CommodityFixedInterestCalculationBuilder setFixedRate(IdentifiedRate _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public CommodityFixedInterestCalculationBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        public CommodityFixedInterestCalculation build() {
            return new CommodityFixedInterestCalculationImpl(this);
        }

        @Override
        public CommodityFixedInterestCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityFixedInterestCalculationBuilder prune() {
            if (this.fixedRate != null && !this.fixedRate.prune().hasData()) {
                this.fixedRate = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFixedRate() != null && this.getFixedRate().hasData()) {
                return true;
            }
            return this.getDayCountFraction() != null && this.getDayCountFraction().hasData();
        }

        public CommodityFixedInterestCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityFixedInterestCalculationBuilder o = (CommodityFixedInterestCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedRate(), (RosettaModelObjectBuilder)o.getFixedRate(), this::setFixedRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityFixedInterestCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityFixedInterestCalculationBuilder {fixedRate=" + this.fixedRate + ", dayCountFraction=" + this.dayCountFraction + '}';
        }
    }

    public static interface CommodityFixedInterestCalculationBuilder
    extends CommodityFixedInterestCalculation,
    RosettaModelObjectBuilder {
        public IdentifiedRate.IdentifiedRateBuilder getOrCreateFixedRate();

        @Override
        public IdentifiedRate.IdentifiedRateBuilder getFixedRate();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public CommodityFixedInterestCalculationBuilder setFixedRate(IdentifiedRate var1);

        public CommodityFixedInterestCalculationBuilder setDayCountFraction(DayCountFraction var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fixedRate"), processor, IdentifiedRate.IdentifiedRateBuilder.class, this.getFixedRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
        }

        public CommodityFixedInterestCalculationBuilder prune();
    }

    public static class CommodityFixedInterestCalculationImpl
    implements CommodityFixedInterestCalculation {
        private final IdentifiedRate fixedRate;
        private final DayCountFraction dayCountFraction;

        protected CommodityFixedInterestCalculationImpl(CommodityFixedInterestCalculationBuilder builder) {
            this.fixedRate = Optional.ofNullable(builder.getFixedRate()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public IdentifiedRate getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public CommodityFixedInterestCalculation build() {
            return this;
        }

        @Override
        public CommodityFixedInterestCalculationBuilder toBuilder() {
            CommodityFixedInterestCalculationBuilder builder = CommodityFixedInterestCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityFixedInterestCalculationBuilder builder) {
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityFixedInterestCalculation _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityFixedInterestCalculation {fixedRate=" + this.fixedRate + ", dayCountFraction=" + this.dayCountFraction + '}';
        }
    }
}

