/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.cd.meta.SpecifiedCurrencyMeta;
import fpml.consolidated.shared.Currency;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SpecifiedCurrency", builder=SpecifiedCurrencyBuilderImpl.class, version="1.1.0")
@RuneDataType(value="SpecifiedCurrency", model="fpml", builder=SpecifiedCurrencyBuilderImpl.class, version="1.1.0")
public interface SpecifiedCurrency
extends RosettaModelObject {
    public static final SpecifiedCurrencyMeta metaData = new SpecifiedCurrencyMeta();

    public Boolean getApplicable();

    public List<? extends Currency> getCurrency();

    public SpecifiedCurrency build();

    public SpecifiedCurrencyBuilder toBuilder();

    public static SpecifiedCurrencyBuilder builder() {
        return new SpecifiedCurrencyBuilderImpl();
    }

    default public RosettaMetaData<? extends SpecifiedCurrency> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SpecifiedCurrency> getType() {
        return SpecifiedCurrency.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class SpecifiedCurrencyBuilderImpl
    implements SpecifiedCurrencyBuilder {
        protected Boolean applicable;
        protected List<Currency.CurrencyBuilder> currency = new ArrayList<Currency.CurrencyBuilder>();

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public List<? extends Currency.CurrencyBuilder> getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency(int index) {
            if (this.currency == null) {
                this.currency = new ArrayList<Currency.CurrencyBuilder>();
            }
            return (Currency.CurrencyBuilder)this.getIndex(this.currency, index, () -> {
                Currency.CurrencyBuilder newCurrency = Currency.builder();
                return newCurrency;
            });
        }

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public SpecifiedCurrencyBuilder setApplicable(Boolean _applicable) {
            this.applicable = _applicable == null ? null : _applicable;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public SpecifiedCurrencyBuilder addCurrency(Currency _currency) {
            if (_currency != null) {
                this.currency.add(_currency.toBuilder());
            }
            return this;
        }

        @Override
        public SpecifiedCurrencyBuilder addCurrency(Currency _currency, int idx) {
            this.getIndex(this.currency, idx, () -> _currency.toBuilder());
            return this;
        }

        @Override
        public SpecifiedCurrencyBuilder addCurrency(List<? extends Currency> currencys) {
            if (currencys != null) {
                for (Currency currency : currencys) {
                    this.currency.add(currency.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="currency")
        public SpecifiedCurrencyBuilder setCurrency(List<? extends Currency> currencys) {
            this.currency = currencys == null ? new ArrayList<Currency.CurrencyBuilder>() : (List)currencys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public SpecifiedCurrency build() {
            return new SpecifiedCurrencyImpl(this);
        }

        @Override
        public SpecifiedCurrencyBuilder toBuilder() {
            return this;
        }

        @Override
        public SpecifiedCurrencyBuilder prune() {
            this.currency = this.currency.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getApplicable() != null) {
                return true;
            }
            return this.getCurrency() != null && this.getCurrency().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public SpecifiedCurrencyBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SpecifiedCurrencyBuilder o = (SpecifiedCurrencyBuilder)other;
            merger.mergeRosetta(this.getCurrency(), o.getCurrency(), this::getOrCreateCurrency);
            merger.mergeBasic((Object)this.getApplicable(), (Object)o.getApplicable(), this::setApplicable, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SpecifiedCurrency _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            return ListEquals.listEquals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SpecifiedCurrencyBuilder {applicable=" + this.applicable + ", currency=" + this.currency + '}';
        }
    }

    public static interface SpecifiedCurrencyBuilder
    extends SpecifiedCurrency,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateCurrency(int var1);

        public List<? extends Currency.CurrencyBuilder> getCurrency();

        public SpecifiedCurrencyBuilder setApplicable(Boolean var1);

        public SpecifiedCurrencyBuilder addCurrency(Currency var1);

        public SpecifiedCurrencyBuilder addCurrency(Currency var1, int var2);

        public SpecifiedCurrencyBuilder addCurrency(List<? extends Currency> var1);

        public SpecifiedCurrencyBuilder setCurrency(List<? extends Currency> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("applicable"), Boolean.class, (Object)this.getApplicable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        public SpecifiedCurrencyBuilder prune();
    }

    public static class SpecifiedCurrencyImpl
    implements SpecifiedCurrency {
        private final Boolean applicable;
        private final List<? extends Currency> currency;

        protected SpecifiedCurrencyImpl(SpecifiedCurrencyBuilder builder) {
            this.applicable = builder.getApplicable();
            this.currency = Optional.ofNullable(builder.getCurrency()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="applicable")
        @RuneAttribute(value="applicable")
        public Boolean getApplicable() {
            return this.applicable;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public List<? extends Currency> getCurrency() {
            return this.currency;
        }

        @Override
        public SpecifiedCurrency build() {
            return this;
        }

        @Override
        public SpecifiedCurrencyBuilder toBuilder() {
            SpecifiedCurrencyBuilder builder = SpecifiedCurrency.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SpecifiedCurrencyBuilder builder) {
            Optional.ofNullable(this.getApplicable()).ifPresent(builder::setApplicable);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SpecifiedCurrency _that = this.getType().cast(o);
            if (!Objects.equals(this.applicable, _that.getApplicable())) {
                return false;
            }
            return ListEquals.listEquals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.applicable != null ? this.applicable.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SpecifiedCurrency {applicable=" + this.applicable + ", currency=" + this.currency + '}';
        }
    }
}

