/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.asset.Future;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FutureChoice")
@ImplementedBy(value=Default.class)
public interface FutureChoice
extends Validator<Future> {
    public static final String NAME = "FutureChoice";
    public static final String DEFINITION = "optional choice maturity, contractYearMonth";

    public static class NoOp
    implements FutureChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Future future) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FutureChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Future future) {
            ComparisonResult result = this.executeDataRule(future);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FutureChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Future", (RosettaPath)path, (String)FutureChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FutureChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Future", (RosettaPath)path, (String)FutureChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Future future) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)future), Arrays.asList("maturity", "contractYearMonth"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

