/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.observable.asset.Price;
import cdm.observable.asset.ReferenceSwapCurve;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.metafields.ReferenceWithMetaFixedRateSpecification;
import cdm.product.template.AveragingStrikeFeature;
import cdm.product.template.meta.OptionStrikeMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="OptionStrike", builder=OptionStrikeBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="OptionStrike", model="cdm", builder=OptionStrikeBuilderImpl.class, version="7.0.0-dev.52")
public interface OptionStrike
extends RosettaModelObject {
    public static final OptionStrikeMeta metaData = new OptionStrikeMeta();

    public Price getStrikePrice();

    public ReferenceWithMetaFixedRateSpecification getStrikeReference();

    public ReferenceSwapCurve getReferenceSwapCurve();

    public AveragingStrikeFeature getAveragingStrikeFeature();

    public OptionStrike build();

    public OptionStrikeBuilder toBuilder();

    public static OptionStrikeBuilder builder() {
        return new OptionStrikeBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionStrike> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionStrike> getType() {
        return OptionStrike.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("strikePrice"), processor, Price.class, this.getStrikePrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikeReference"), processor, ReferenceWithMetaFixedRateSpecification.class, this.getStrikeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceSwapCurve"), processor, ReferenceSwapCurve.class, this.getReferenceSwapCurve(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averagingStrikeFeature"), processor, AveragingStrikeFeature.class, this.getAveragingStrikeFeature(), new AttributeMeta[0]);
    }

    public static class OptionStrikeBuilderImpl
    implements OptionStrikeBuilder {
        protected Price.PriceBuilder strikePrice;
        protected ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder strikeReference;
        protected ReferenceSwapCurve.ReferenceSwapCurveBuilder referenceSwapCurve;
        protected AveragingStrikeFeature.AveragingStrikeFeatureBuilder averagingStrikeFeature;

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public Price.PriceBuilder getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        public Price.PriceBuilder getOrCreateStrikePrice() {
            Price.PriceBuilder result = this.strikePrice != null ? this.strikePrice : (this.strikePrice = Price.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikeReference")
        @RuneAttribute(value="strikeReference")
        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getStrikeReference() {
            return this.strikeReference;
        }

        @Override
        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getOrCreateStrikeReference() {
            ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder result = this.strikeReference != null ? this.strikeReference : (this.strikeReference = ReferenceWithMetaFixedRateSpecification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceSwapCurve")
        @RuneAttribute(value="referenceSwapCurve")
        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getReferenceSwapCurve() {
            return this.referenceSwapCurve;
        }

        @Override
        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getOrCreateReferenceSwapCurve() {
            ReferenceSwapCurve.ReferenceSwapCurveBuilder result = this.referenceSwapCurve != null ? this.referenceSwapCurve : (this.referenceSwapCurve = ReferenceSwapCurve.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averagingStrikeFeature")
        @RuneAttribute(value="averagingStrikeFeature")
        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getAveragingStrikeFeature() {
            return this.averagingStrikeFeature;
        }

        @Override
        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getOrCreateAveragingStrikeFeature() {
            AveragingStrikeFeature.AveragingStrikeFeatureBuilder result = this.averagingStrikeFeature != null ? this.averagingStrikeFeature : (this.averagingStrikeFeature = AveragingStrikeFeature.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public OptionStrikeBuilder setStrikePrice(Price _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikeReference")
        @RuneAttribute(value="strikeReference")
        public OptionStrikeBuilder setStrikeReference(ReferenceWithMetaFixedRateSpecification _strikeReference) {
            this.strikeReference = _strikeReference == null ? null : _strikeReference.toBuilder();
            return this;
        }

        @Override
        public OptionStrikeBuilder setStrikeReferenceValue(FixedRateSpecification _strikeReference) {
            this.getOrCreateStrikeReference().setValue(_strikeReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceSwapCurve")
        @RuneAttribute(value="referenceSwapCurve")
        public OptionStrikeBuilder setReferenceSwapCurve(ReferenceSwapCurve _referenceSwapCurve) {
            this.referenceSwapCurve = _referenceSwapCurve == null ? null : _referenceSwapCurve.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averagingStrikeFeature")
        @RuneAttribute(value="averagingStrikeFeature")
        public OptionStrikeBuilder setAveragingStrikeFeature(AveragingStrikeFeature _averagingStrikeFeature) {
            this.averagingStrikeFeature = _averagingStrikeFeature == null ? null : _averagingStrikeFeature.toBuilder();
            return this;
        }

        @Override
        public OptionStrike build() {
            return new OptionStrikeImpl(this);
        }

        @Override
        public OptionStrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionStrikeBuilder prune() {
            if (this.strikePrice != null && !this.strikePrice.prune().hasData()) {
                this.strikePrice = null;
            }
            if (this.strikeReference != null && !this.strikeReference.prune().hasData()) {
                this.strikeReference = null;
            }
            if (this.referenceSwapCurve != null && !this.referenceSwapCurve.prune().hasData()) {
                this.referenceSwapCurve = null;
            }
            if (this.averagingStrikeFeature != null && !this.averagingStrikeFeature.prune().hasData()) {
                this.averagingStrikeFeature = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrikePrice() != null && this.getStrikePrice().hasData()) {
                return true;
            }
            if (this.getStrikeReference() != null && this.getStrikeReference().hasData()) {
                return true;
            }
            if (this.getReferenceSwapCurve() != null && this.getReferenceSwapCurve().hasData()) {
                return true;
            }
            return this.getAveragingStrikeFeature() != null && this.getAveragingStrikeFeature().hasData();
        }

        public OptionStrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            OptionStrikeBuilder o = (OptionStrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikePrice(), (RosettaModelObjectBuilder)o.getStrikePrice(), this::setStrikePrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrikeReference(), (RosettaModelObjectBuilder)o.getStrikeReference(), this::setStrikeReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceSwapCurve(), (RosettaModelObjectBuilder)o.getReferenceSwapCurve(), this::setReferenceSwapCurve);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAveragingStrikeFeature(), (RosettaModelObjectBuilder)o.getAveragingStrikeFeature(), this::setAveragingStrikeFeature);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.strikeReference, _that.getStrikeReference())) {
                return false;
            }
            if (!Objects.equals(this.referenceSwapCurve, _that.getReferenceSwapCurve())) {
                return false;
            }
            return Objects.equals(this.averagingStrikeFeature, _that.getAveragingStrikeFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikeReference != null ? this.strikeReference.hashCode() : 0);
            _result = 31 * _result + (this.referenceSwapCurve != null ? this.referenceSwapCurve.hashCode() : 0);
            _result = 31 * _result + (this.averagingStrikeFeature != null ? this.averagingStrikeFeature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionStrikeBuilder {strikePrice=" + this.strikePrice + ", strikeReference=" + this.strikeReference + ", referenceSwapCurve=" + this.referenceSwapCurve + ", averagingStrikeFeature=" + this.averagingStrikeFeature + '}';
        }
    }

    public static interface OptionStrikeBuilder
    extends OptionStrike,
    RosettaModelObjectBuilder {
        public Price.PriceBuilder getOrCreateStrikePrice();

        @Override
        public Price.PriceBuilder getStrikePrice();

        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getOrCreateStrikeReference();

        @Override
        public ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder getStrikeReference();

        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getOrCreateReferenceSwapCurve();

        @Override
        public ReferenceSwapCurve.ReferenceSwapCurveBuilder getReferenceSwapCurve();

        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getOrCreateAveragingStrikeFeature();

        @Override
        public AveragingStrikeFeature.AveragingStrikeFeatureBuilder getAveragingStrikeFeature();

        public OptionStrikeBuilder setStrikePrice(Price var1);

        public OptionStrikeBuilder setStrikeReference(ReferenceWithMetaFixedRateSpecification var1);

        public OptionStrikeBuilder setStrikeReferenceValue(FixedRateSpecification var1);

        public OptionStrikeBuilder setReferenceSwapCurve(ReferenceSwapCurve var1);

        public OptionStrikeBuilder setAveragingStrikeFeature(AveragingStrikeFeature var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("strikePrice"), processor, Price.PriceBuilder.class, this.getStrikePrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikeReference"), processor, ReferenceWithMetaFixedRateSpecification.ReferenceWithMetaFixedRateSpecificationBuilder.class, this.getStrikeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceSwapCurve"), processor, ReferenceSwapCurve.ReferenceSwapCurveBuilder.class, this.getReferenceSwapCurve(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averagingStrikeFeature"), processor, AveragingStrikeFeature.AveragingStrikeFeatureBuilder.class, this.getAveragingStrikeFeature(), new AttributeMeta[0]);
        }

        public OptionStrikeBuilder prune();
    }

    public static class OptionStrikeImpl
    implements OptionStrike {
        private final Price strikePrice;
        private final ReferenceWithMetaFixedRateSpecification strikeReference;
        private final ReferenceSwapCurve referenceSwapCurve;
        private final AveragingStrikeFeature averagingStrikeFeature;

        protected OptionStrikeImpl(OptionStrikeBuilder builder) {
            this.strikePrice = Optional.ofNullable(builder.getStrikePrice()).map(f -> f.build()).orElse(null);
            this.strikeReference = Optional.ofNullable(builder.getStrikeReference()).map(f -> f.build()).orElse(null);
            this.referenceSwapCurve = Optional.ofNullable(builder.getReferenceSwapCurve()).map(f -> f.build()).orElse(null);
            this.averagingStrikeFeature = Optional.ofNullable(builder.getAveragingStrikeFeature()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public Price getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="strikeReference")
        @RuneAttribute(value="strikeReference")
        public ReferenceWithMetaFixedRateSpecification getStrikeReference() {
            return this.strikeReference;
        }

        @Override
        @RosettaAttribute(value="referenceSwapCurve")
        @RuneAttribute(value="referenceSwapCurve")
        public ReferenceSwapCurve getReferenceSwapCurve() {
            return this.referenceSwapCurve;
        }

        @Override
        @RosettaAttribute(value="averagingStrikeFeature")
        @RuneAttribute(value="averagingStrikeFeature")
        public AveragingStrikeFeature getAveragingStrikeFeature() {
            return this.averagingStrikeFeature;
        }

        @Override
        public OptionStrike build() {
            return this;
        }

        @Override
        public OptionStrikeBuilder toBuilder() {
            OptionStrikeBuilder builder = OptionStrike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionStrikeBuilder builder) {
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getStrikeReference()).ifPresent(builder::setStrikeReference);
            Optional.ofNullable(this.getReferenceSwapCurve()).ifPresent(builder::setReferenceSwapCurve);
            Optional.ofNullable(this.getAveragingStrikeFeature()).ifPresent(builder::setAveragingStrikeFeature);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            OptionStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.strikeReference, _that.getStrikeReference())) {
                return false;
            }
            if (!Objects.equals(this.referenceSwapCurve, _that.getReferenceSwapCurve())) {
                return false;
            }
            return Objects.equals(this.averagingStrikeFeature, _that.getAveragingStrikeFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.strikeReference != null ? this.strikeReference.hashCode() : 0);
            _result = 31 * _result + (this.referenceSwapCurve != null ? this.referenceSwapCurve.hashCode() : 0);
            _result = 31 * _result + (this.averagingStrikeFeature != null ? this.averagingStrikeFeature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "OptionStrike {strikePrice=" + this.strikePrice + ", strikeReference=" + this.strikeReference + ", referenceSwapCurve=" + this.referenceSwapCurve + ", averagingStrikeFeature=" + this.averagingStrikeFeature + '}';
        }
    }
}

