/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.product.collateral.CheckEligibilityResult;
import cdm.product.collateral.CollateralCriteria;
import cdm.product.collateral.EligibilityQuery;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.collateral.EligibleCollateralSpecification;
import cdm.product.collateral.functions.CheckCriteria;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CheckEligibilityByDetailsDefault.class)
public abstract class CheckEligibilityByDetails
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CheckCriteria checkCriteria;

    public CheckEligibilityResult evaluate(EligibleCollateralSpecification specification, EligibilityQuery query) {
        CheckEligibilityResult eligibilityResult;
        CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResultBuilder = this.doEvaluate(specification, query);
        if (eligibilityResultBuilder == null) {
            eligibilityResult = null;
        } else {
            eligibilityResult = eligibilityResultBuilder.build();
            this.objectValidator.validate(CheckEligibilityResult.class, (RosettaModelObject)eligibilityResult);
        }
        return eligibilityResult;
    }

    protected abstract CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(EligibleCollateralSpecification var1, EligibilityQuery var2);

    protected abstract MapperC<? extends EligibleCollateralCriteria> filteredCriteria(EligibleCollateralSpecification var1, EligibilityQuery var2);

    protected abstract MapperC<? extends EligibleCollateralCriteria> checkedCriteria(EligibleCollateralSpecification var1, EligibilityQuery var2);

    public static class CheckEligibilityByDetailsDefault
    extends CheckEligibilityByDetails {
        @Override
        protected CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(EligibleCollateralSpecification specification, EligibilityQuery query) {
            CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult = CheckEligibilityResult.builder();
            return this.assignOutput(eligibilityResult, specification, query);
        }

        protected CheckEligibilityResult.CheckEligibilityResultBuilder assignOutput(CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult, EligibleCollateralSpecification specification, EligibilityQuery query) {
            eligibilityResult.setIsEligible(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)this.checkedCriteria(specification, query).resultCount()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).get());
            eligibilityResult.setEligibilityQuery(query);
            eligibilityResult.setSpecification(specification);
            eligibilityResult.addMatchingEligibleCriteria(this.checkedCriteria(specification, query).getMulti());
            return Optional.ofNullable(eligibilityResult).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends EligibleCollateralCriteria> filteredCriteria(EligibleCollateralSpecification specification, EligibilityQuery query) {
            return MapperS.of((Object)specification).mapC("getCriteria", eligibleCollateralSpecification -> eligibleCollateralSpecification.getCriteria()).filterItemNullSafe(item -> (Boolean)item.map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getIsIncluded", collateralTreatment -> collateralTreatment.getIsIncluded()).get());
        }

        @Override
        protected MapperC<? extends EligibleCollateralCriteria> checkedCriteria(EligibleCollateralSpecification specification, EligibilityQuery query) {
            return this.filteredCriteria(specification, query).filterItemNullSafe(item -> this.checkCriteria.evaluate((CollateralCriteria)item.map("getCollateralCriteria", eligibleCollateralCriteria -> eligibleCollateralCriteria.getCollateralCriteria()).get(), query));
        }
    }
}

