/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.RateSpecification;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="RateSpecificationChoice")
@ImplementedBy(value=Default.class)
public interface RateSpecificationChoice
extends Validator<RateSpecification> {
    public static final String NAME = "RateSpecificationChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements RateSpecificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RateSpecification rateSpecification) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements RateSpecificationChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RateSpecification rateSpecification) {
            ComparisonResult result = this.executeDataRule(rateSpecification);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)RateSpecificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RateSpecification", (RosettaPath)path, (String)RateSpecificationChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == RateSpecificationChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)RateSpecificationChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RateSpecification", (RosettaPath)path, (String)RateSpecificationChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(RateSpecification rateSpecification) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)rateSpecification), Arrays.asList("FixedRateSpecification", "FloatingRateSpecification", "InflationRateSpecification"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

