/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate;

import cdm.observable.asset.calculatedrate.meta.CalculatedRateObservationDatesAndWeightsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CalculatedRateObservationDatesAndWeights", builder=CalculatedRateObservationDatesAndWeightsBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="CalculatedRateObservationDatesAndWeights", model="cdm", builder=CalculatedRateObservationDatesAndWeightsBuilderImpl.class, version="7.0.0-dev.52")
public interface CalculatedRateObservationDatesAndWeights
extends RosettaModelObject {
    public static final CalculatedRateObservationDatesAndWeightsMeta metaData = new CalculatedRateObservationDatesAndWeightsMeta();

    public List<Date> getObservationDates();

    public List<BigDecimal> getWeights();

    public CalculatedRateObservationDatesAndWeights build();

    public CalculatedRateObservationDatesAndWeightsBuilder toBuilder();

    public static CalculatedRateObservationDatesAndWeightsBuilder builder() {
        return new CalculatedRateObservationDatesAndWeightsBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculatedRateObservationDatesAndWeights> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculatedRateObservationDatesAndWeights> getType() {
        return CalculatedRateObservationDatesAndWeights.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("observationDates"), Date.class, this.getObservationDates(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weights"), BigDecimal.class, this.getWeights(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculatedRateObservationDatesAndWeightsBuilderImpl
    implements CalculatedRateObservationDatesAndWeightsBuilder {
        protected List<Date> observationDates = new ArrayList<Date>();
        protected List<BigDecimal> weights = new ArrayList<BigDecimal>();

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public List<Date> getObservationDates() {
            return this.observationDates;
        }

        @Override
        @RosettaAttribute(value="weights")
        @RuneAttribute(value="weights")
        public List<BigDecimal> getWeights() {
            return this.weights;
        }

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public CalculatedRateObservationDatesAndWeightsBuilder addObservationDates(Date _observationDates) {
            if (_observationDates != null) {
                this.observationDates.add(_observationDates);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationDatesAndWeightsBuilder addObservationDates(Date _observationDates, int idx) {
            this.getIndex(this.observationDates, idx, () -> _observationDates);
            return this;
        }

        @Override
        public CalculatedRateObservationDatesAndWeightsBuilder addObservationDates(List<Date> observationDatess) {
            if (observationDatess != null) {
                for (Date toAdd : observationDatess) {
                    this.observationDates.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationDates")
        public CalculatedRateObservationDatesAndWeightsBuilder setObservationDates(List<Date> observationDatess) {
            this.observationDates = observationDatess == null ? new ArrayList<Date>() : (List)observationDatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="weights")
        @RuneAttribute(value="weights")
        public CalculatedRateObservationDatesAndWeightsBuilder addWeights(BigDecimal _weights) {
            if (_weights != null) {
                this.weights.add(_weights);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationDatesAndWeightsBuilder addWeights(BigDecimal _weights, int idx) {
            this.getIndex(this.weights, idx, () -> _weights);
            return this;
        }

        @Override
        public CalculatedRateObservationDatesAndWeightsBuilder addWeights(List<BigDecimal> weightss) {
            if (weightss != null) {
                for (BigDecimal toAdd : weightss) {
                    this.weights.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="weights")
        public CalculatedRateObservationDatesAndWeightsBuilder setWeights(List<BigDecimal> weightss) {
            this.weights = weightss == null ? new ArrayList<BigDecimal>() : (List)weightss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateObservationDatesAndWeights build() {
            return new CalculatedRateObservationDatesAndWeightsImpl(this);
        }

        @Override
        public CalculatedRateObservationDatesAndWeightsBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculatedRateObservationDatesAndWeightsBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getObservationDates() != null && !this.getObservationDates().isEmpty()) {
                return true;
            }
            return this.getWeights() != null && !this.getWeights().isEmpty();
        }

        public CalculatedRateObservationDatesAndWeightsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculatedRateObservationDatesAndWeightsBuilder o = (CalculatedRateObservationDatesAndWeightsBuilder)other;
            merger.mergeBasic(this.getObservationDates(), o.getObservationDates(), this::addObservationDates);
            merger.mergeBasic(this.getWeights(), o.getWeights(), this::addWeights);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateObservationDatesAndWeights _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            return ListEquals.listEquals(this.weights, _that.getWeights());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.weights != null ? this.weights.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateObservationDatesAndWeightsBuilder {observationDates=" + this.observationDates + ", weights=" + this.weights + '}';
        }
    }

    public static interface CalculatedRateObservationDatesAndWeightsBuilder
    extends CalculatedRateObservationDatesAndWeights,
    RosettaModelObjectBuilder {
        public CalculatedRateObservationDatesAndWeightsBuilder addObservationDates(Date var1);

        public CalculatedRateObservationDatesAndWeightsBuilder addObservationDates(Date var1, int var2);

        public CalculatedRateObservationDatesAndWeightsBuilder addObservationDates(List<Date> var1);

        public CalculatedRateObservationDatesAndWeightsBuilder setObservationDates(List<Date> var1);

        public CalculatedRateObservationDatesAndWeightsBuilder addWeights(BigDecimal var1);

        public CalculatedRateObservationDatesAndWeightsBuilder addWeights(BigDecimal var1, int var2);

        public CalculatedRateObservationDatesAndWeightsBuilder addWeights(List<BigDecimal> var1);

        public CalculatedRateObservationDatesAndWeightsBuilder setWeights(List<BigDecimal> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("observationDates"), Date.class, this.getObservationDates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weights"), BigDecimal.class, this.getWeights(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculatedRateObservationDatesAndWeightsBuilder prune();
    }

    public static class CalculatedRateObservationDatesAndWeightsImpl
    implements CalculatedRateObservationDatesAndWeights {
        private final List<Date> observationDates;
        private final List<BigDecimal> weights;

        protected CalculatedRateObservationDatesAndWeightsImpl(CalculatedRateObservationDatesAndWeightsBuilder builder) {
            this.observationDates = Optional.ofNullable(builder.getObservationDates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.weights = Optional.ofNullable(builder.getWeights()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public List<Date> getObservationDates() {
            return this.observationDates;
        }

        @Override
        @RosettaAttribute(value="weights")
        @RuneAttribute(value="weights")
        public List<BigDecimal> getWeights() {
            return this.weights;
        }

        @Override
        public CalculatedRateObservationDatesAndWeights build() {
            return this;
        }

        @Override
        public CalculatedRateObservationDatesAndWeightsBuilder toBuilder() {
            CalculatedRateObservationDatesAndWeightsBuilder builder = CalculatedRateObservationDatesAndWeights.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculatedRateObservationDatesAndWeightsBuilder builder) {
            Optional.ofNullable(this.getObservationDates()).ifPresent(builder::setObservationDates);
            Optional.ofNullable(this.getWeights()).ifPresent(builder::setWeights);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateObservationDatesAndWeights _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            return ListEquals.listEquals(this.weights, _that.getWeights());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.weights != null ? this.weights.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateObservationDatesAndWeights {observationDates=" + this.observationDates + ", weights=" + this.weights + '}';
        }
    }
}

