/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="PriceTypeEnum")
public enum PriceTypeEnum {
    ASSET_PRICE("AssetPrice", null),
    CASH_PRICE("CashPrice", null),
    CORRELATION("Correlation", null),
    DIVIDEND("Dividend", null),
    EXCHANGE_RATE("ExchangeRate", null),
    INTEREST_RATE("InterestRate", null),
    VARIANCE("Variance", null),
    VOLATILITY("Volatility", null);

    private static Map<String, PriceTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private PriceTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static PriceTypeEnum fromDisplayName(String name) {
        PriceTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, PriceTypeEnum> map = new ConcurrentHashMap<String, PriceTypeEnum>();
        for (PriceTypeEnum instance : PriceTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

