/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.ProcessAgentElection;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ProcessAgentElectionNotApplicable")
@ImplementedBy(value=Default.class)
public interface ProcessAgentElectionNotApplicable
extends Validator<ProcessAgentElection> {
    public static final String NAME = "ProcessAgentElectionNotApplicable";
    public static final String DEFINITION = "if isApplicable = False then processAgent is absent";

    public static class NoOp
    implements ProcessAgentElectionNotApplicable {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProcessAgentElection processAgentElection) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ProcessAgentElectionNotApplicable {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProcessAgentElection processAgentElection) {
            ComparisonResult result = this.executeDataRule(processAgentElection);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ProcessAgentElectionNotApplicable.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProcessAgentElection", (RosettaPath)path, (String)ProcessAgentElectionNotApplicable.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ProcessAgentElectionNotApplicable.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProcessAgentElection", (RosettaPath)path, (String)ProcessAgentElectionNotApplicable.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ProcessAgentElection processAgentElection) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)processAgentElection).map("getIsApplicable", _processAgentElection -> _processAgentElection.getIsApplicable()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)processAgentElection).map("getProcessAgent", _processAgentElection -> _processAgentElection.getProcessAgent()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

