/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.fra.functions;

import cdm.ingest.fpml.confirmation.product.fra.functions.MapFraFixedLegPriceQuantity;
import cdm.ingest.fpml.confirmation.product.fra.functions.MapFraFloatingLegPriceQuantity;
import cdm.observable.asset.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.ird.Fra;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapFraPriceQuantityListDefault.class)
public abstract class MapFraPriceQuantityList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapFraFixedLegPriceQuantity mapFraFixedLegPriceQuantity;
    @Inject
    protected MapFraFloatingLegPriceQuantity mapFraFloatingLegPriceQuantity;

    public List<? extends PriceQuantity> evaluate(Fra fpmlFra) {
        List priceQuantityList;
        List<PriceQuantity.PriceQuantityBuilder> priceQuantityListBuilder = this.doEvaluate(fpmlFra);
        if (priceQuantityListBuilder == null) {
            priceQuantityList = null;
        } else {
            priceQuantityList = priceQuantityListBuilder.stream().map(PriceQuantity::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceQuantity.class, priceQuantityList);
        }
        return priceQuantityList;
    }

    protected abstract List<PriceQuantity.PriceQuantityBuilder> doEvaluate(Fra var1);

    public static class MapFraPriceQuantityListDefault
    extends MapFraPriceQuantityList {
        @Override
        protected List<PriceQuantity.PriceQuantityBuilder> doEvaluate(Fra fpmlFra) {
            ArrayList<PriceQuantity.PriceQuantityBuilder> priceQuantityList = new ArrayList<PriceQuantity.PriceQuantityBuilder>();
            return this.assignOutput(priceQuantityList, fpmlFra);
        }

        protected List<PriceQuantity.PriceQuantityBuilder> assignOutput(List<PriceQuantity.PriceQuantityBuilder> priceQuantityList, Fra fpmlFra) {
            PriceQuantity priceQuantity0 = this.mapFraFixedLegPriceQuantity.evaluate(fpmlFra);
            if (priceQuantity0 == null) {
                priceQuantityList.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                priceQuantityList.addAll(this.toBuilder(Collections.singletonList(priceQuantity0)));
            }
            PriceQuantity priceQuantity1 = this.mapFraFloatingLegPriceQuantity.evaluate(fpmlFra);
            if (priceQuantity1 == null) {
                priceQuantityList.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                priceQuantityList.addAll(this.toBuilder(Collections.singletonList(priceQuantity1)));
            }
            return Optional.ofNullable(priceQuantityList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

