/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.creditdefaultswap.functions;

import cdm.base.math.UnitType;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.observable.asset.Price;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.consolidated.shared.Currency;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapReferencePriceDefault.class)
public abstract class MapReferencePrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapCurrency mapCurrency;

    public Price evaluate(BigDecimal fpmlReferencePrice, Currency fpmlCurrency) {
        Price price;
        Price.PriceBuilder priceBuilder = this.doEvaluate(fpmlReferencePrice, fpmlCurrency);
        if (priceBuilder == null) {
            price = null;
        } else {
            price = priceBuilder.build();
            this.objectValidator.validate(Price.class, (RosettaModelObject)price);
        }
        return price;
    }

    protected abstract Price.PriceBuilder doEvaluate(BigDecimal var1, Currency var2);

    protected abstract MapperS<? extends UnitType> priceUnits(BigDecimal var1, Currency var2);

    public static class MapReferencePriceDefault
    extends MapReferencePrice {
        @Override
        protected Price.PriceBuilder doEvaluate(BigDecimal fpmlReferencePrice, Currency fpmlCurrency) {
            Price.PriceBuilder price = Price.builder();
            return this.assignOutput(price, fpmlReferencePrice, fpmlCurrency);
        }

        protected Price.PriceBuilder assignOutput(Price.PriceBuilder price, BigDecimal fpmlReferencePrice, Currency fpmlCurrency) {
            price = ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlReferencePrice)).getOrDefault(Boolean.valueOf(false)) != false ? (Price.PriceBuilder)this.toBuilder(Price.builder().setValue(fpmlReferencePrice).setUnit((UnitType)this.priceUnits(fpmlReferencePrice, fpmlCurrency).get()).setPerUnitOf((UnitType)this.priceUnits(fpmlReferencePrice, fpmlCurrency).get()).setPriceType(PriceTypeEnum.ASSET_PRICE).build()) : null;
            return Optional.ofNullable(price).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends UnitType> priceUnits(BigDecimal fpmlReferencePrice, Currency fpmlCurrency) {
            return MapperS.of((Object)UnitType.builder().setCurrency(this.mapCurrency.evaluate(fpmlCurrency)).build());
        }
    }
}

