/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.CorporateActionTypeEnum;
import cdm.event.common.EventIntentEnum;
import cdm.event.common.Instruction;
import cdm.event.common.TradeState;
import cdm.event.common.meta.BusinessEventMeta;
import cdm.event.workflow.EventInstruction;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="BusinessEvent", builder=BusinessEventBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="BusinessEvent", model="cdm", builder=BusinessEventBuilderImpl.class, version="7.0.0-dev.52")
public interface BusinessEvent
extends EventInstruction,
GlobalKey {
    public static final BusinessEventMeta metaData = new BusinessEventMeta();

    public String getEventQualifier();

    public List<? extends TradeState> getAfter();

    public MetaFields getMeta();

    @Override
    public BusinessEvent build();

    @Override
    public BusinessEventBuilder toBuilder();

    public static BusinessEventBuilder builder() {
        return new BusinessEventBuilderImpl();
    }

    default public RosettaMetaData<? extends BusinessEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BusinessEvent> getType() {
        return BusinessEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("intent"), EventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.class, this.getPackageInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instruction"), processor, Instruction.class, this.getInstruction(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventQualifier"), String.class, (Object)this.getEventQualifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("after"), processor, TradeState.class, this.getAfter(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class BusinessEventBuilderImpl
    extends EventInstruction.EventInstructionBuilderImpl
    implements BusinessEventBuilder {
        protected String eventQualifier;
        protected List<TradeState.TradeStateBuilder> after = new ArrayList<TradeState.TradeStateBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="eventQualifier")
        @RuneAttribute(value="eventQualifier")
        public String getEventQualifier() {
            return this.eventQualifier;
        }

        @Override
        @RosettaAttribute(value="after")
        @RuneAttribute(value="after")
        public List<? extends TradeState.TradeStateBuilder> getAfter() {
            return this.after;
        }

        @Override
        public TradeState.TradeStateBuilder getOrCreateAfter(int index) {
            if (this.after == null) {
                this.after = new ArrayList<TradeState.TradeStateBuilder>();
            }
            return (TradeState.TradeStateBuilder)this.getIndex(this.after, index, () -> {
                TradeState.TradeStateBuilder newAfter = TradeState.builder();
                return newAfter;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intent")
        @RuneAttribute(value="intent")
        public BusinessEventBuilder setIntent(EventIntentEnum _intent) {
            this.intent = _intent == null ? null : _intent;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        @RuneAttribute(value="corporateActionIntent")
        public BusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum _corporateActionIntent) {
            this.corporateActionIntent = _corporateActionIntent == null ? null : _corporateActionIntent;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public BusinessEventBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public BusinessEventBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public BusinessEventBuilder setPackageInformation(IdentifiedList _packageInformation) {
            this.packageInformation = _packageInformation == null ? null : _packageInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instruction")
        @RuneAttribute(value="instruction")
        public BusinessEventBuilder addInstruction(Instruction _instruction) {
            if (_instruction != null) {
                this.instruction.add(_instruction.toBuilder());
            }
            return this;
        }

        @Override
        public BusinessEventBuilder addInstruction(Instruction _instruction, int idx) {
            this.getIndex(this.instruction, idx, () -> _instruction.toBuilder());
            return this;
        }

        @Override
        public BusinessEventBuilder addInstruction(List<? extends Instruction> instructions) {
            if (instructions != null) {
                for (Instruction instruction : instructions) {
                    this.instruction.add(instruction.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instruction")
        public BusinessEventBuilder setInstruction(List<? extends Instruction> instructions) {
            this.instruction = instructions == null ? new ArrayList() : (List)instructions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="eventQualifier")
        @RuneAttribute(value="eventQualifier")
        public BusinessEventBuilder setEventQualifier(String _eventQualifier) {
            this.eventQualifier = _eventQualifier == null ? null : _eventQualifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="after")
        @RuneAttribute(value="after")
        public BusinessEventBuilder addAfter(TradeState _after) {
            if (_after != null) {
                this.after.add(_after.toBuilder());
            }
            return this;
        }

        @Override
        public BusinessEventBuilder addAfter(TradeState _after, int idx) {
            this.getIndex(this.after, idx, () -> _after.toBuilder());
            return this;
        }

        @Override
        public BusinessEventBuilder addAfter(List<? extends TradeState> afters) {
            if (afters != null) {
                for (TradeState tradeState : afters) {
                    this.after.add(tradeState.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="after")
        public BusinessEventBuilder setAfter(List<? extends TradeState> afters) {
            this.after = afters == null ? new ArrayList<TradeState.TradeStateBuilder>() : (List)afters.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public BusinessEventBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public BusinessEvent build() {
            return new BusinessEventImpl(this);
        }

        @Override
        public BusinessEventBuilder toBuilder() {
            return this;
        }

        @Override
        public BusinessEventBuilder prune() {
            super.prune();
            this.after = this.after.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEventQualifier() != null) {
                return true;
            }
            return this.getAfter() != null && this.getAfter().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public BusinessEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BusinessEventBuilder o = (BusinessEventBuilder)other;
            merger.mergeRosetta(this.getAfter(), o.getAfter(), this::getOrCreateAfter);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getEventQualifier(), (Object)o.getEventQualifier(), this::setEventQualifier, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessEvent _that = (BusinessEvent)this.getType().cast(o);
            if (!Objects.equals(this.eventQualifier, _that.getEventQualifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.after, _that.getAfter())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventQualifier != null ? this.eventQualifier.hashCode() : 0);
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessEventBuilder {eventQualifier=" + this.eventQualifier + ", after=" + this.after + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface BusinessEventBuilder
    extends BusinessEvent,
    EventInstruction.EventInstructionBuilder,
    GlobalKey.GlobalKeyBuilder {
        public TradeState.TradeStateBuilder getOrCreateAfter(int var1);

        public List<? extends TradeState.TradeStateBuilder> getAfter();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        @Override
        public BusinessEventBuilder setIntent(EventIntentEnum var1);

        @Override
        public BusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum var1);

        @Override
        public BusinessEventBuilder setEventDate(Date var1);

        @Override
        public BusinessEventBuilder setEffectiveDate(Date var1);

        @Override
        public BusinessEventBuilder setPackageInformation(IdentifiedList var1);

        @Override
        public BusinessEventBuilder addInstruction(Instruction var1);

        @Override
        public BusinessEventBuilder addInstruction(Instruction var1, int var2);

        @Override
        public BusinessEventBuilder addInstruction(List<? extends Instruction> var1);

        @Override
        public BusinessEventBuilder setInstruction(List<? extends Instruction> var1);

        public BusinessEventBuilder setEventQualifier(String var1);

        public BusinessEventBuilder addAfter(TradeState var1);

        public BusinessEventBuilder addAfter(TradeState var1, int var2);

        public BusinessEventBuilder addAfter(List<? extends TradeState> var1);

        public BusinessEventBuilder setAfter(List<? extends TradeState> var1);

        public BusinessEventBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("intent"), EventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.IdentifiedListBuilder.class, (RosettaModelObjectBuilder)this.getPackageInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instruction"), processor, Instruction.InstructionBuilder.class, this.getInstruction(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventQualifier"), String.class, (Object)this.getEventQualifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("after"), processor, TradeState.TradeStateBuilder.class, this.getAfter(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public BusinessEventBuilder prune();
    }

    public static class BusinessEventImpl
    extends EventInstruction.EventInstructionImpl
    implements BusinessEvent {
        private final String eventQualifier;
        private final List<? extends TradeState> after;
        private final MetaFields meta;

        protected BusinessEventImpl(BusinessEventBuilder builder) {
            super(builder);
            this.eventQualifier = builder.getEventQualifier();
            this.after = Optional.ofNullable(builder.getAfter()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="eventQualifier")
        @RuneAttribute(value="eventQualifier")
        public String getEventQualifier() {
            return this.eventQualifier;
        }

        @Override
        @RosettaAttribute(value="after")
        @RuneAttribute(value="after")
        public List<? extends TradeState> getAfter() {
            return this.after;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public BusinessEvent build() {
            return this;
        }

        @Override
        public BusinessEventBuilder toBuilder() {
            BusinessEventBuilder builder = BusinessEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BusinessEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEventQualifier()).ifPresent(builder::setEventQualifier);
            Optional.ofNullable(this.getAfter()).ifPresent(builder::setAfter);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            BusinessEvent _that = (BusinessEvent)this.getType().cast(o);
            if (!Objects.equals(this.eventQualifier, _that.getEventQualifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.after, _that.getAfter())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.eventQualifier != null ? this.eventQualifier.hashCode() : 0);
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BusinessEvent {eventQualifier=" + this.eventQualifier + ", after=" + this.after + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }
}

