/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Taxonomy;
import cdm.base.staticdata.asset.common.meta.AssetBaseMeta;
import cdm.base.staticdata.party.LegalEntity;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetBase", builder=AssetBaseBuilderImpl.class, version="7.0.0-dev.52")
@RuneDataType(value="AssetBase", model="cdm", builder=AssetBaseBuilderImpl.class, version="7.0.0-dev.52")
public interface AssetBase
extends RosettaModelObject {
    public static final AssetBaseMeta metaData = new AssetBaseMeta();

    public List<? extends AssetIdentifier> getIdentifier();

    public List<? extends Taxonomy> getTaxonomy();

    public Boolean getIsExchangeListed();

    public LegalEntity getExchange();

    public List<? extends LegalEntity> getRelatedExchange();

    public AssetBase build();

    public AssetBaseBuilder toBuilder();

    public static AssetBaseBuilder builder() {
        return new AssetBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetBase> getType() {
        return AssetBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.class, this.getTaxonomy(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
    }

    public static class AssetBaseBuilderImpl
    implements AssetBaseBuilder {
        protected List<AssetIdentifier.AssetIdentifierBuilder> identifier = new ArrayList<AssetIdentifier.AssetIdentifierBuilder>();
        protected List<Taxonomy.TaxonomyBuilder> taxonomy = new ArrayList<Taxonomy.TaxonomyBuilder>();
        protected Boolean isExchangeListed;
        protected LegalEntity.LegalEntityBuilder exchange;
        protected List<LegalEntity.LegalEntityBuilder> relatedExchange = new ArrayList<LegalEntity.LegalEntityBuilder>();

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public List<? extends AssetIdentifier.AssetIdentifierBuilder> getIdentifier() {
            return this.identifier;
        }

        @Override
        public AssetIdentifier.AssetIdentifierBuilder getOrCreateIdentifier(int index) {
            if (this.identifier == null) {
                this.identifier = new ArrayList<AssetIdentifier.AssetIdentifierBuilder>();
            }
            return (AssetIdentifier.AssetIdentifierBuilder)this.getIndex(this.identifier, index, () -> {
                AssetIdentifier.AssetIdentifierBuilder newIdentifier = AssetIdentifier.builder();
                return newIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public List<? extends Taxonomy.TaxonomyBuilder> getTaxonomy() {
            return this.taxonomy;
        }

        @Override
        public Taxonomy.TaxonomyBuilder getOrCreateTaxonomy(int index) {
            if (this.taxonomy == null) {
                this.taxonomy = new ArrayList<Taxonomy.TaxonomyBuilder>();
            }
            return (Taxonomy.TaxonomyBuilder)this.getIndex(this.taxonomy, index, () -> {
                Taxonomy.TaxonomyBuilder newTaxonomy = Taxonomy.builder();
                return newTaxonomy;
            });
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public Boolean getIsExchangeListed() {
            return this.isExchangeListed;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public LegalEntity.LegalEntityBuilder getExchange() {
            return this.exchange;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateExchange() {
            LegalEntity.LegalEntityBuilder result = this.exchange != null ? this.exchange : (this.exchange = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public List<? extends LegalEntity.LegalEntityBuilder> getRelatedExchange() {
            return this.relatedExchange;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateRelatedExchange(int index) {
            if (this.relatedExchange == null) {
                this.relatedExchange = new ArrayList<LegalEntity.LegalEntityBuilder>();
            }
            return (LegalEntity.LegalEntityBuilder)this.getIndex(this.relatedExchange, index, () -> {
                LegalEntity.LegalEntityBuilder newRelatedExchange = LegalEntity.builder();
                return newRelatedExchange;
            });
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public AssetBaseBuilder addIdentifier(AssetIdentifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public AssetBaseBuilder addIdentifier(AssetIdentifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public AssetBaseBuilder addIdentifier(List<? extends AssetIdentifier> identifiers) {
            if (identifiers != null) {
                for (AssetIdentifier assetIdentifier : identifiers) {
                    this.identifier.add(assetIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public AssetBaseBuilder setIdentifier(List<? extends AssetIdentifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList<AssetIdentifier.AssetIdentifierBuilder>() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public AssetBaseBuilder addTaxonomy(Taxonomy _taxonomy) {
            if (_taxonomy != null) {
                this.taxonomy.add(_taxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public AssetBaseBuilder addTaxonomy(Taxonomy _taxonomy, int idx) {
            this.getIndex(this.taxonomy, idx, () -> _taxonomy.toBuilder());
            return this;
        }

        @Override
        public AssetBaseBuilder addTaxonomy(List<? extends Taxonomy> taxonomys) {
            if (taxonomys != null) {
                for (Taxonomy taxonomy : taxonomys) {
                    this.taxonomy.add(taxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="taxonomy")
        public AssetBaseBuilder setTaxonomy(List<? extends Taxonomy> taxonomys) {
            this.taxonomy = taxonomys == null ? new ArrayList<Taxonomy.TaxonomyBuilder>() : (List)taxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public AssetBaseBuilder setIsExchangeListed(Boolean _isExchangeListed) {
            this.isExchangeListed = _isExchangeListed == null ? null : _isExchangeListed;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public AssetBaseBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public AssetBaseBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public AssetBaseBuilder addRelatedExchange(LegalEntity _relatedExchange, int idx) {
            this.getIndex(this.relatedExchange, idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public AssetBaseBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public AssetBaseBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList<LegalEntity.LegalEntityBuilder>() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AssetBase build() {
            return new AssetBaseImpl(this);
        }

        @Override
        public AssetBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetBaseBuilder prune() {
            this.identifier = this.identifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.taxonomy = this.taxonomy.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.exchange != null && !this.exchange.prune().hasData()) {
                this.exchange = null;
            }
            this.relatedExchange = this.relatedExchange.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifier() != null && this.getIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTaxonomy() != null && this.getTaxonomy().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getIsExchangeListed() != null) {
                return true;
            }
            if (this.getExchange() != null && this.getExchange().hasData()) {
                return true;
            }
            return this.getRelatedExchange() != null && this.getRelatedExchange().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public AssetBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetBaseBuilder o = (AssetBaseBuilder)other;
            merger.mergeRosetta(this.getIdentifier(), o.getIdentifier(), this::getOrCreateIdentifier);
            merger.mergeRosetta(this.getTaxonomy(), o.getTaxonomy(), this::getOrCreateTaxonomy);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchange(), (RosettaModelObjectBuilder)o.getExchange(), this::setExchange);
            merger.mergeRosetta(this.getRelatedExchange(), o.getRelatedExchange(), this::getOrCreateRelatedExchange);
            merger.mergeBasic((Object)this.getIsExchangeListed(), (Object)o.getIsExchangeListed(), this::setIsExchangeListed, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.taxonomy, _that.getTaxonomy())) {
                return false;
            }
            if (!Objects.equals(this.isExchangeListed, _that.getIsExchangeListed())) {
                return false;
            }
            if (!Objects.equals(this.exchange, _that.getExchange())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedExchange, _that.getRelatedExchange());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.taxonomy != null ? this.taxonomy.hashCode() : 0);
            _result = 31 * _result + (this.isExchangeListed != null ? this.isExchangeListed.hashCode() : 0);
            _result = 31 * _result + (this.exchange != null ? this.exchange.hashCode() : 0);
            _result = 31 * _result + (this.relatedExchange != null ? this.relatedExchange.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetBaseBuilder {identifier=" + this.identifier + ", taxonomy=" + this.taxonomy + ", isExchangeListed=" + this.isExchangeListed + ", exchange=" + this.exchange + ", relatedExchange=" + this.relatedExchange + '}';
        }
    }

    public static interface AssetBaseBuilder
    extends AssetBase,
    RosettaModelObjectBuilder {
        public AssetIdentifier.AssetIdentifierBuilder getOrCreateIdentifier(int var1);

        public List<? extends AssetIdentifier.AssetIdentifierBuilder> getIdentifier();

        public Taxonomy.TaxonomyBuilder getOrCreateTaxonomy(int var1);

        public List<? extends Taxonomy.TaxonomyBuilder> getTaxonomy();

        public LegalEntity.LegalEntityBuilder getOrCreateExchange();

        @Override
        public LegalEntity.LegalEntityBuilder getExchange();

        public LegalEntity.LegalEntityBuilder getOrCreateRelatedExchange(int var1);

        public List<? extends LegalEntity.LegalEntityBuilder> getRelatedExchange();

        public AssetBaseBuilder addIdentifier(AssetIdentifier var1);

        public AssetBaseBuilder addIdentifier(AssetIdentifier var1, int var2);

        public AssetBaseBuilder addIdentifier(List<? extends AssetIdentifier> var1);

        public AssetBaseBuilder setIdentifier(List<? extends AssetIdentifier> var1);

        public AssetBaseBuilder addTaxonomy(Taxonomy var1);

        public AssetBaseBuilder addTaxonomy(Taxonomy var1, int var2);

        public AssetBaseBuilder addTaxonomy(List<? extends Taxonomy> var1);

        public AssetBaseBuilder setTaxonomy(List<? extends Taxonomy> var1);

        public AssetBaseBuilder setIsExchangeListed(Boolean var1);

        public AssetBaseBuilder setExchange(LegalEntity var1);

        public AssetBaseBuilder addRelatedExchange(LegalEntity var1);

        public AssetBaseBuilder addRelatedExchange(LegalEntity var1, int var2);

        public AssetBaseBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        public AssetBaseBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, AssetIdentifier.AssetIdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("taxonomy"), processor, Taxonomy.TaxonomyBuilder.class, this.getTaxonomy(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isExchangeListed"), Boolean.class, (Object)this.getIsExchangeListed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
        }

        public AssetBaseBuilder prune();
    }

    public static class AssetBaseImpl
    implements AssetBase {
        private final List<? extends AssetIdentifier> identifier;
        private final List<? extends Taxonomy> taxonomy;
        private final Boolean isExchangeListed;
        private final LegalEntity exchange;
        private final List<? extends LegalEntity> relatedExchange;

        protected AssetBaseImpl(AssetBaseBuilder builder) {
            this.identifier = Optional.ofNullable(builder.getIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.taxonomy = Optional.ofNullable(builder.getTaxonomy()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.isExchangeListed = builder.getIsExchangeListed();
            this.exchange = Optional.ofNullable(builder.getExchange()).map(f -> f.build()).orElse(null);
            this.relatedExchange = Optional.ofNullable(builder.getRelatedExchange()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public List<? extends AssetIdentifier> getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="taxonomy")
        @RuneAttribute(value="taxonomy")
        public List<? extends Taxonomy> getTaxonomy() {
            return this.taxonomy;
        }

        @Override
        @RosettaAttribute(value="isExchangeListed")
        @RuneAttribute(value="isExchangeListed")
        public Boolean getIsExchangeListed() {
            return this.isExchangeListed;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public LegalEntity getExchange() {
            return this.exchange;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public List<? extends LegalEntity> getRelatedExchange() {
            return this.relatedExchange;
        }

        @Override
        public AssetBase build() {
            return this;
        }

        @Override
        public AssetBaseBuilder toBuilder() {
            AssetBaseBuilder builder = AssetBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetBaseBuilder builder) {
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getTaxonomy()).ifPresent(builder::setTaxonomy);
            Optional.ofNullable(this.getIsExchangeListed()).ifPresent(builder::setIsExchangeListed);
            Optional.ofNullable(this.getExchange()).ifPresent(builder::setExchange);
            Optional.ofNullable(this.getRelatedExchange()).ifPresent(builder::setRelatedExchange);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetBase _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.taxonomy, _that.getTaxonomy())) {
                return false;
            }
            if (!Objects.equals(this.isExchangeListed, _that.getIsExchangeListed())) {
                return false;
            }
            if (!Objects.equals(this.exchange, _that.getExchange())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedExchange, _that.getRelatedExchange());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.taxonomy != null ? this.taxonomy.hashCode() : 0);
            _result = 31 * _result + (this.isExchangeListed != null ? this.isExchangeListed.hashCode() : 0);
            _result = 31 * _result + (this.exchange != null ? this.exchange.hashCode() : 0);
            _result = 31 * _result + (this.relatedExchange != null ? this.relatedExchange.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetBase {identifier=" + this.identifier + ", taxonomy=" + this.taxonomy + ", isExchangeListed=" + this.isExchangeListed + ", exchange=" + this.exchange + ", relatedExchange=" + this.relatedExchange + '}';
        }
    }
}

