/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.Withdrawal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="WithdrawalChoice")
@ImplementedBy(value=Default.class)
public interface WithdrawalChoice
extends Validator<Withdrawal> {
    public static final String NAME = "WithdrawalChoice";
    public static final String DEFINITION = "required choice withdrawalSequence, trade";

    public static class NoOp
    implements WithdrawalChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Withdrawal withdrawal) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements WithdrawalChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Withdrawal withdrawal) {
            ComparisonResult result = this.executeDataRule(withdrawal);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)WithdrawalChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Withdrawal", (RosettaPath)path, (String)WithdrawalChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)WithdrawalChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Withdrawal", (RosettaPath)path, (String)WithdrawalChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Withdrawal withdrawal) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)withdrawal), Arrays.asList("withdrawalSequence", "trade"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

