/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.UtilizationModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="UtilizationModelChoice")
@ImplementedBy(value=Default.class)
public interface UtilizationModelChoice
extends Validator<UtilizationModel> {
    public static final String NAME = "UtilizationModelChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements UtilizationModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, UtilizationModel utilizationModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements UtilizationModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, UtilizationModel utilizationModel) {
            ComparisonResult result = this.executeDataRule(utilizationModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)UtilizationModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"UtilizationModel", (RosettaPath)path, (String)UtilizationModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)UtilizationModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"UtilizationModel", (RosettaPath)path, (String)UtilizationModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(UtilizationModel utilizationModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)utilizationModel), Arrays.asList("utilizationModelSequence0", "utilizationModelSequence1"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

