/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.StubValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="StubValueChoice")
@ImplementedBy(value=Default.class)
public interface StubValueChoice
extends Validator<StubValue> {
    public static final String NAME = "StubValueChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements StubValueChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StubValue stubValue) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements StubValueChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, StubValue stubValue) {
            ComparisonResult result = this.executeDataRule(stubValue);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)StubValueChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StubValue", (RosettaPath)path, (String)StubValueChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)StubValueChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"StubValue", (RosettaPath)path, (String)StubValueChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(StubValue stubValue) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)stubValue), Arrays.asList("floatingRate", "stubRate", "stubAmount"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

