/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.PartySelector;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PartySelectorChoice")
@ImplementedBy(value=Default.class)
public interface PartySelectorChoice
extends Validator<PartySelector> {
    public static final String NAME = "PartySelectorChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements PartySelectorChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PartySelector partySelector) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PartySelectorChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PartySelector partySelector) {
            ComparisonResult result = this.executeDataRule(partySelector);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PartySelectorChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PartySelector", (RosettaPath)path, (String)PartySelectorChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PartySelectorChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PartySelector", (RosettaPath)path, (String)PartySelectorChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PartySelector partySelector) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)partySelector), Arrays.asList("partyReference", "partyDetermination"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

