/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.LoanChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LoanChoiceChoice")
@ImplementedBy(value=Default.class)
public interface LoanChoiceChoice
extends Validator<LoanChoice> {
    public static final String NAME = "LoanChoiceChoice";
    public static final String DEFINITION = "optional choice borrower, borrowerReference";

    public static class NoOp
    implements LoanChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LoanChoice loanChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LoanChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LoanChoice loanChoice) {
            ComparisonResult result = this.executeDataRule(loanChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LoanChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LoanChoice", (RosettaPath)path, (String)LoanChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LoanChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LoanChoice", (RosettaPath)path, (String)LoanChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LoanChoice loanChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)loanChoice), Arrays.asList("borrower", "borrowerReference"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

