/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.GasProduct;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="GasProductChoice")
@ImplementedBy(value=Default.class)
public interface GasProductChoice
extends Validator<GasProduct> {
    public static final String NAME = "GasProductChoice";
    public static final String DEFINITION = "optional choice calorificValue, quality";

    public static class NoOp
    implements GasProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, GasProduct gasProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements GasProductChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, GasProduct gasProduct) {
            ComparisonResult result = this.executeDataRule(gasProduct);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)GasProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"GasProduct", (RosettaPath)path, (String)GasProductChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)GasProductChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"GasProduct", (RosettaPath)path, (String)GasProductChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(GasProduct gasProduct) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)gasProduct), Arrays.asList("calorificValue", "quality"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

