/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.ExerciseProcedureOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ExerciseProcedureOptionChoice")
@ImplementedBy(value=Default.class)
public interface ExerciseProcedureOptionChoice
extends Validator<ExerciseProcedureOption> {
    public static final String NAME = "ExerciseProcedureOptionChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements ExerciseProcedureOptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExerciseProcedureOption exerciseProcedureOption) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ExerciseProcedureOptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExerciseProcedureOption exerciseProcedureOption) {
            ComparisonResult result = this.executeDataRule(exerciseProcedureOption);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ExerciseProcedureOptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExerciseProcedureOption", (RosettaPath)path, (String)ExerciseProcedureOptionChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ExerciseProcedureOptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ExerciseProcedureOption", (RosettaPath)path, (String)ExerciseProcedureOptionChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ExerciseProcedureOption exerciseProcedureOption) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)exerciseProcedureOption), Arrays.asList("manualExercise", "automaticExercise"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

