/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.Account;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AccountChoice")
@ImplementedBy(value=Default.class)
public interface AccountChoice
extends Validator<Account> {
    public static final String NAME = "AccountChoice";
    public static final String DEFINITION = "required choice accountSequence, servicingParty";

    public static class NoOp
    implements AccountChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Account account) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AccountChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Account account) {
            ComparisonResult result = this.executeDataRule(account);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AccountChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Account", (RosettaPath)path, (String)AccountChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AccountChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Account", (RosettaPath)path, (String)AccountChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Account account) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)account), Arrays.asList("accountSequence", "servicingParty"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

