/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.custom.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.custom.DocumentChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="DocumentChoiceChoice")
@ImplementedBy(value=Default.class)
public interface DocumentChoiceChoice
extends Validator<DocumentChoice> {
    public static final String NAME = "DocumentChoiceChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements DocumentChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DocumentChoice documentChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements DocumentChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, DocumentChoice documentChoice) {
            ComparisonResult result = this.executeDataRule(documentChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)DocumentChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DocumentChoice", (RosettaPath)path, (String)DocumentChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == DocumentChoiceChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)DocumentChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"DocumentChoice", (RosettaPath)path, (String)DocumentChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(DocumentChoice documentChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)documentChoice), Arrays.asList("LoanNotificationAcknowledgement", "LoanNotificationException", "ExecutionAdviceException", "ClearingException", "VerificationStatusException", "ConfirmationException", "CreditEventException", "TradeReferenceInformationUpdateException", "EventStatusException", "ServiceNotificationException", "CollateralAllocationRejected", "ClearingEligibilityException", "MessageRejected", "ExecutionException", "AllocationException", "MaturityException", "TradeChangeAdviceException", "ConsentException", "LoanAllocationNotification", "RequestAllocation", "ExecutionAdvice", "RequestClearingEligibility", "RequestConfirmation", "RequestCollateralAllocation", "RequestConsent", "LoanPartyProfileStatement", "RequestTradeReferenceInformationUpdate", "CreditEventNotification", "RequestExecution", "OptionExpirationNotification", "ExecutionNotification", "TradeChangeAdvice", "MaturityNotification", "LoanContractNotification", "LcNotification", "LoanBulkServicingNotification", "LoanLegalActionNotification", "FacilityNotification", "LoanCovenantObligationNotification", "LoanTradeNotification", "DealStatement", "FacilityStatement", "OutstandingContractsStatement", "FacilityPositionStatement", "LoanLegalActionStatement", "RequestClearing", "RequestRetransmission", "RequestConfirmationRetracted", "RequestConsentRetracted", "RequestEventStatus", "TradeChangeAdviceRetracted", "CreditEventNotificationRetracted", "RequestClearingRetracted", "RequestExecutionRetracted", "VerificationStatusNotification", "ExecutionRetracted", "LoanNotificationRetracted", "RequestAllocationRetracted", "RequestTradeReferenceInformationUpdateRetracted", "ExecutionAdviceRetracted", "CollateralAllocationAcknowledgement", "CreditEventAcknowledgement", "VerificationStatusAcknowledgement", "ClearingEligibilityAcknowledgement", "AllocationRefused", "ConfirmationDisputed", "ConsentRefused", "ConfirmationStatus", "AllocationApproved", "ClearingEligibility", "MaturityAcknowledgement", "ExecutionAdviceAcknowledgement", "ConfirmationAcknowledgement", "ClearingAcknowledgement", "ConsentAcknowledgement", "TradeReferenceInformationUpdateAcknowledgement", "AllocationAcknowledgement", "TradeChangeAdviceAcknowledgement", "ExecutionAcknowledgement", "ConfirmationAgreed", "CollateralAllocationAccepted", "EventStatusResponse", "ConsentGranted", "ClearingConfirmed", "ClearingStatus", "ServiceNotification", "ClearingRefused", "ApprovalStatusNotification", "ValuationDocument", "DataDocument"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

