/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.meta.VoteQuantityChoiceMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="VoteQuantityChoice", builder=VoteQuantityChoiceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="VoteQuantityChoice", model="fpml", builder=VoteQuantityChoiceBuilderImpl.class, version="0.17.2")
public interface VoteQuantityChoice
extends RosettaModelObject {
    public static final VoteQuantityChoiceMeta metaData = new VoteQuantityChoiceMeta();

    public Integer getVoteCount();

    public BigDecimal getVotePercent();

    public NonNegativeMoney getVoteAmount();

    public VoteQuantityChoice build();

    public VoteQuantityChoiceBuilder toBuilder();

    public static VoteQuantityChoiceBuilder builder() {
        return new VoteQuantityChoiceBuilderImpl();
    }

    default public RosettaMetaData<? extends VoteQuantityChoice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VoteQuantityChoice> getType() {
        return VoteQuantityChoice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("voteCount"), Integer.class, (Object)this.getVoteCount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("votePercent"), BigDecimal.class, (Object)this.getVotePercent(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("voteAmount"), processor, NonNegativeMoney.class, this.getVoteAmount(), new AttributeMeta[0]);
    }

    public static class VoteQuantityChoiceBuilderImpl
    implements VoteQuantityChoiceBuilder {
        protected Integer voteCount;
        protected BigDecimal votePercent;
        protected NonNegativeMoney.NonNegativeMoneyBuilder voteAmount;

        @Override
        @RosettaAttribute(value="voteCount")
        @RuneAttribute(value="voteCount")
        public Integer getVoteCount() {
            return this.voteCount;
        }

        @Override
        @RosettaAttribute(value="votePercent")
        @RuneAttribute(value="votePercent")
        public BigDecimal getVotePercent() {
            return this.votePercent;
        }

        @Override
        @RosettaAttribute(value="voteAmount")
        @RuneAttribute(value="voteAmount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getVoteAmount() {
            return this.voteAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateVoteAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.voteAmount != null ? this.voteAmount : (this.voteAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="voteCount")
        @RuneAttribute(value="voteCount")
        public VoteQuantityChoiceBuilder setVoteCount(Integer _voteCount) {
            this.voteCount = _voteCount == null ? null : _voteCount;
            return this;
        }

        @Override
        @RosettaAttribute(value="votePercent")
        @RuneAttribute(value="votePercent")
        public VoteQuantityChoiceBuilder setVotePercent(BigDecimal _votePercent) {
            this.votePercent = _votePercent == null ? null : _votePercent;
            return this;
        }

        @Override
        @RosettaAttribute(value="voteAmount")
        @RuneAttribute(value="voteAmount")
        public VoteQuantityChoiceBuilder setVoteAmount(NonNegativeMoney _voteAmount) {
            this.voteAmount = _voteAmount == null ? null : _voteAmount.toBuilder();
            return this;
        }

        @Override
        public VoteQuantityChoice build() {
            return new VoteQuantityChoiceImpl(this);
        }

        @Override
        public VoteQuantityChoiceBuilder toBuilder() {
            return this;
        }

        @Override
        public VoteQuantityChoiceBuilder prune() {
            if (this.voteAmount != null && !this.voteAmount.prune().hasData()) {
                this.voteAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getVoteCount() != null) {
                return true;
            }
            if (this.getVotePercent() != null) {
                return true;
            }
            return this.getVoteAmount() != null && this.getVoteAmount().hasData();
        }

        public VoteQuantityChoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            VoteQuantityChoiceBuilder o = (VoteQuantityChoiceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVoteAmount(), (RosettaModelObjectBuilder)o.getVoteAmount(), this::setVoteAmount);
            merger.mergeBasic((Object)this.getVoteCount(), (Object)o.getVoteCount(), this::setVoteCount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVotePercent(), (Object)o.getVotePercent(), this::setVotePercent, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            VoteQuantityChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.voteCount, _that.getVoteCount())) {
                return false;
            }
            if (!Objects.equals(this.votePercent, _that.getVotePercent())) {
                return false;
            }
            return Objects.equals(this.voteAmount, _that.getVoteAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.voteCount != null ? this.voteCount.hashCode() : 0);
            _result = 31 * _result + (this.votePercent != null ? this.votePercent.hashCode() : 0);
            _result = 31 * _result + (this.voteAmount != null ? this.voteAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "VoteQuantityChoiceBuilder {voteCount=" + this.voteCount + ", votePercent=" + this.votePercent + ", voteAmount=" + this.voteAmount + '}';
        }
    }

    public static interface VoteQuantityChoiceBuilder
    extends VoteQuantityChoice,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateVoteAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getVoteAmount();

        public VoteQuantityChoiceBuilder setVoteCount(Integer var1);

        public VoteQuantityChoiceBuilder setVotePercent(BigDecimal var1);

        public VoteQuantityChoiceBuilder setVoteAmount(NonNegativeMoney var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("voteCount"), Integer.class, (Object)this.getVoteCount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("votePercent"), BigDecimal.class, (Object)this.getVotePercent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("voteAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getVoteAmount(), new AttributeMeta[0]);
        }

        public VoteQuantityChoiceBuilder prune();
    }

    public static class VoteQuantityChoiceImpl
    implements VoteQuantityChoice {
        private final Integer voteCount;
        private final BigDecimal votePercent;
        private final NonNegativeMoney voteAmount;

        protected VoteQuantityChoiceImpl(VoteQuantityChoiceBuilder builder) {
            this.voteCount = builder.getVoteCount();
            this.votePercent = builder.getVotePercent();
            this.voteAmount = Optional.ofNullable(builder.getVoteAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="voteCount")
        @RuneAttribute(value="voteCount")
        public Integer getVoteCount() {
            return this.voteCount;
        }

        @Override
        @RosettaAttribute(value="votePercent")
        @RuneAttribute(value="votePercent")
        public BigDecimal getVotePercent() {
            return this.votePercent;
        }

        @Override
        @RosettaAttribute(value="voteAmount")
        @RuneAttribute(value="voteAmount")
        public NonNegativeMoney getVoteAmount() {
            return this.voteAmount;
        }

        @Override
        public VoteQuantityChoice build() {
            return this;
        }

        @Override
        public VoteQuantityChoiceBuilder toBuilder() {
            VoteQuantityChoiceBuilder builder = VoteQuantityChoice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VoteQuantityChoiceBuilder builder) {
            Optional.ofNullable(this.getVoteCount()).ifPresent(builder::setVoteCount);
            Optional.ofNullable(this.getVotePercent()).ifPresent(builder::setVotePercent);
            Optional.ofNullable(this.getVoteAmount()).ifPresent(builder::setVoteAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            VoteQuantityChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.voteCount, _that.getVoteCount())) {
                return false;
            }
            if (!Objects.equals(this.votePercent, _that.getVotePercent())) {
                return false;
            }
            return Objects.equals(this.voteAmount, _that.getVoteAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.voteCount != null ? this.voteCount.hashCode() : 0);
            _result = 31 * _result + (this.votePercent != null ? this.votePercent.hashCode() : 0);
            _result = 31 * _result + (this.voteAmount != null ? this.voteAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "VoteQuantityChoice {voteCount=" + this.voteCount + ", votePercent=" + this.votePercent + ", voteAmount=" + this.voteAmount + '}';
        }
    }
}

