/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.IdentifiedDate;
import fpml.confirmation.meta.VersionHistoryModelMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="VersionHistoryModel", builder=VersionHistoryModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="VersionHistoryModel", model="fpml", builder=VersionHistoryModelBuilderImpl.class, version="0.17.2")
public interface VersionHistoryModel
extends RosettaModelObject {
    public static final VersionHistoryModelMeta metaData = new VersionHistoryModelMeta();

    public Integer getVersion();

    public IdentifiedDate getEffectiveDate();

    public VersionHistoryModel build();

    public VersionHistoryModelBuilder toBuilder();

    public static VersionHistoryModelBuilder builder() {
        return new VersionHistoryModelBuilderImpl();
    }

    default public RosettaMetaData<? extends VersionHistoryModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VersionHistoryModel> getType() {
        return VersionHistoryModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("version"), Integer.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, IdentifiedDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
    }

    public static class VersionHistoryModelBuilderImpl
    implements VersionHistoryModelBuilder {
        protected Integer version;
        protected IdentifiedDate.IdentifiedDateBuilder effectiveDate;

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public Integer getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public IdentifiedDate.IdentifiedDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateEffectiveDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public VersionHistoryModelBuilder setVersion(Integer _version) {
            this.version = _version == null ? null : _version;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public VersionHistoryModelBuilder setEffectiveDate(IdentifiedDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        public VersionHistoryModel build() {
            return new VersionHistoryModelImpl(this);
        }

        @Override
        public VersionHistoryModelBuilder toBuilder() {
            return this;
        }

        @Override
        public VersionHistoryModelBuilder prune() {
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getVersion() != null) {
                return true;
            }
            return this.getEffectiveDate() != null && this.getEffectiveDate().hasData();
        }

        public VersionHistoryModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            VersionHistoryModelBuilder o = (VersionHistoryModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            VersionHistoryModel _that = this.getType().cast(o);
            if (!Objects.equals(this.version, _that.getVersion())) {
                return false;
            }
            return Objects.equals(this.effectiveDate, _that.getEffectiveDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "VersionHistoryModelBuilder {version=" + this.version + ", effectiveDate=" + this.effectiveDate + '}';
        }
    }

    public static interface VersionHistoryModelBuilder
    extends VersionHistoryModel,
    RosettaModelObjectBuilder {
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateEffectiveDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getEffectiveDate();

        public VersionHistoryModelBuilder setVersion(Integer var1);

        public VersionHistoryModelBuilder setEffectiveDate(IdentifiedDate var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("version"), Integer.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
        }

        public VersionHistoryModelBuilder prune();
    }

    public static class VersionHistoryModelImpl
    implements VersionHistoryModel {
        private final Integer version;
        private final IdentifiedDate effectiveDate;

        protected VersionHistoryModelImpl(VersionHistoryModelBuilder builder) {
            this.version = builder.getVersion();
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public Integer getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public IdentifiedDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public VersionHistoryModel build() {
            return this;
        }

        @Override
        public VersionHistoryModelBuilder toBuilder() {
            VersionHistoryModelBuilder builder = VersionHistoryModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VersionHistoryModelBuilder builder) {
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            VersionHistoryModel _that = this.getType().cast(o);
            if (!Objects.equals(this.version, _that.getVersion())) {
                return false;
            }
            return Objects.equals(this.effectiveDate, _that.getEffectiveDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "VersionHistoryModel {version=" + this.version + ", effectiveDate=" + this.effectiveDate + '}';
        }
    }
}

