/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.IdentifiedDate;
import fpml.confirmation.MarketReference;
import fpml.confirmation.PricingInputReplacement;
import fpml.confirmation.PricingParameterShift;
import fpml.confirmation.meta.ValuationScenarioMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationScenario", builder=ValuationScenarioBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ValuationScenario", model="fpml", builder=ValuationScenarioBuilderImpl.class, version="0.17.2")
public interface ValuationScenario
extends RosettaModelObject {
    public static final ValuationScenarioMeta metaData = new ValuationScenarioMeta();

    public String getName();

    public IdentifiedDate getValuationDate();

    public MarketReference getMarketReference();

    public List<? extends PricingParameterShift> getShift();

    public List<? extends PricingInputReplacement> getReplacement();

    public String getId();

    public ValuationScenario build();

    public ValuationScenarioBuilder toBuilder();

    public static ValuationScenarioBuilder builder() {
        return new ValuationScenarioBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationScenario> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationScenario> getType() {
        return ValuationScenario.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDate"), processor, IdentifiedDate.class, this.getValuationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marketReference"), processor, MarketReference.class, this.getMarketReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("shift"), processor, PricingParameterShift.class, this.getShift(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("replacement"), processor, PricingInputReplacement.class, this.getReplacement(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ValuationScenarioBuilderImpl
    implements ValuationScenarioBuilder {
        protected String name;
        protected IdentifiedDate.IdentifiedDateBuilder valuationDate;
        protected MarketReference.MarketReferenceBuilder marketReference;
        protected List<PricingParameterShift.PricingParameterShiftBuilder> shift = new ArrayList<PricingParameterShift.PricingParameterShiftBuilder>();
        protected List<PricingInputReplacement.PricingInputReplacementBuilder> replacement = new ArrayList<PricingInputReplacement.PricingInputReplacementBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="valuationDate", isRequired=true)
        @RuneAttribute(value="valuationDate", isRequired=true)
        public IdentifiedDate.IdentifiedDateBuilder getValuationDate() {
            return this.valuationDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateValuationDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.valuationDate != null ? this.valuationDate : (this.valuationDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="marketReference")
        @RuneAttribute(value="marketReference")
        public MarketReference.MarketReferenceBuilder getMarketReference() {
            return this.marketReference;
        }

        @Override
        public MarketReference.MarketReferenceBuilder getOrCreateMarketReference() {
            MarketReference.MarketReferenceBuilder result = this.marketReference != null ? this.marketReference : (this.marketReference = MarketReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="shift")
        @RuneAttribute(value="shift")
        public List<? extends PricingParameterShift.PricingParameterShiftBuilder> getShift() {
            return this.shift;
        }

        @Override
        public PricingParameterShift.PricingParameterShiftBuilder getOrCreateShift(int index) {
            if (this.shift == null) {
                this.shift = new ArrayList<PricingParameterShift.PricingParameterShiftBuilder>();
            }
            return (PricingParameterShift.PricingParameterShiftBuilder)this.getIndex(this.shift, index, () -> {
                PricingParameterShift.PricingParameterShiftBuilder newShift = PricingParameterShift.builder();
                return newShift;
            });
        }

        @Override
        @RosettaAttribute(value="replacement")
        @RuneAttribute(value="replacement")
        public List<? extends PricingInputReplacement.PricingInputReplacementBuilder> getReplacement() {
            return this.replacement;
        }

        @Override
        public PricingInputReplacement.PricingInputReplacementBuilder getOrCreateReplacement(int index) {
            if (this.replacement == null) {
                this.replacement = new ArrayList<PricingInputReplacement.PricingInputReplacementBuilder>();
            }
            return (PricingInputReplacement.PricingInputReplacementBuilder)this.getIndex(this.replacement, index, () -> {
                PricingInputReplacement.PricingInputReplacementBuilder newReplacement = PricingInputReplacement.builder();
                return newReplacement;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public ValuationScenarioBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDate", isRequired=true)
        @RuneAttribute(value="valuationDate", isRequired=true)
        public ValuationScenarioBuilder setValuationDate(IdentifiedDate _valuationDate) {
            this.valuationDate = _valuationDate == null ? null : _valuationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="marketReference")
        @RuneAttribute(value="marketReference")
        public ValuationScenarioBuilder setMarketReference(MarketReference _marketReference) {
            this.marketReference = _marketReference == null ? null : _marketReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="shift")
        @RuneAttribute(value="shift")
        public ValuationScenarioBuilder addShift(PricingParameterShift _shift) {
            if (_shift != null) {
                this.shift.add(_shift.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationScenarioBuilder addShift(PricingParameterShift _shift, int idx) {
            this.getIndex(this.shift, idx, () -> _shift.toBuilder());
            return this;
        }

        @Override
        public ValuationScenarioBuilder addShift(List<? extends PricingParameterShift> shifts) {
            if (shifts != null) {
                for (PricingParameterShift pricingParameterShift : shifts) {
                    this.shift.add(pricingParameterShift.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="shift")
        public ValuationScenarioBuilder setShift(List<? extends PricingParameterShift> shifts) {
            this.shift = shifts == null ? new ArrayList<PricingParameterShift.PricingParameterShiftBuilder>() : (List)shifts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="replacement")
        @RuneAttribute(value="replacement")
        public ValuationScenarioBuilder addReplacement(PricingInputReplacement _replacement) {
            if (_replacement != null) {
                this.replacement.add(_replacement.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationScenarioBuilder addReplacement(PricingInputReplacement _replacement, int idx) {
            this.getIndex(this.replacement, idx, () -> _replacement.toBuilder());
            return this;
        }

        @Override
        public ValuationScenarioBuilder addReplacement(List<? extends PricingInputReplacement> replacements) {
            if (replacements != null) {
                for (PricingInputReplacement pricingInputReplacement : replacements) {
                    this.replacement.add(pricingInputReplacement.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="replacement")
        public ValuationScenarioBuilder setReplacement(List<? extends PricingInputReplacement> replacements) {
            this.replacement = replacements == null ? new ArrayList<PricingInputReplacement.PricingInputReplacementBuilder>() : (List)replacements.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ValuationScenarioBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public ValuationScenario build() {
            return new ValuationScenarioImpl(this);
        }

        @Override
        public ValuationScenarioBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationScenarioBuilder prune() {
            if (this.valuationDate != null && !this.valuationDate.prune().hasData()) {
                this.valuationDate = null;
            }
            if (this.marketReference != null && !this.marketReference.prune().hasData()) {
                this.marketReference = null;
            }
            this.shift = this.shift.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.replacement = this.replacement.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getValuationDate() != null && this.getValuationDate().hasData()) {
                return true;
            }
            if (this.getMarketReference() != null && this.getMarketReference().hasData()) {
                return true;
            }
            if (this.getShift() != null && this.getShift().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getReplacement() != null && this.getReplacement().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public ValuationScenarioBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationScenarioBuilder o = (ValuationScenarioBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDate(), (RosettaModelObjectBuilder)o.getValuationDate(), this::setValuationDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarketReference(), (RosettaModelObjectBuilder)o.getMarketReference(), this::setMarketReference);
            merger.mergeRosetta(this.getShift(), o.getShift(), this::getOrCreateShift);
            merger.mergeRosetta(this.getReplacement(), o.getReplacement(), this::getOrCreateReplacement);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationScenario _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.marketReference, _that.getMarketReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.shift, _that.getShift())) {
                return false;
            }
            if (!ListEquals.listEquals(this.replacement, _that.getReplacement())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.marketReference != null ? this.marketReference.hashCode() : 0);
            _result = 31 * _result + (this.shift != null ? this.shift.hashCode() : 0);
            _result = 31 * _result + (this.replacement != null ? this.replacement.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationScenarioBuilder {name=" + this.name + ", valuationDate=" + this.valuationDate + ", marketReference=" + this.marketReference + ", shift=" + this.shift + ", replacement=" + this.replacement + ", id=" + this.id + '}';
        }
    }

    public static interface ValuationScenarioBuilder
    extends ValuationScenario,
    RosettaModelObjectBuilder {
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateValuationDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getValuationDate();

        public MarketReference.MarketReferenceBuilder getOrCreateMarketReference();

        @Override
        public MarketReference.MarketReferenceBuilder getMarketReference();

        public PricingParameterShift.PricingParameterShiftBuilder getOrCreateShift(int var1);

        public List<? extends PricingParameterShift.PricingParameterShiftBuilder> getShift();

        public PricingInputReplacement.PricingInputReplacementBuilder getOrCreateReplacement(int var1);

        public List<? extends PricingInputReplacement.PricingInputReplacementBuilder> getReplacement();

        public ValuationScenarioBuilder setName(String var1);

        public ValuationScenarioBuilder setValuationDate(IdentifiedDate var1);

        public ValuationScenarioBuilder setMarketReference(MarketReference var1);

        public ValuationScenarioBuilder addShift(PricingParameterShift var1);

        public ValuationScenarioBuilder addShift(PricingParameterShift var1, int var2);

        public ValuationScenarioBuilder addShift(List<? extends PricingParameterShift> var1);

        public ValuationScenarioBuilder setShift(List<? extends PricingParameterShift> var1);

        public ValuationScenarioBuilder addReplacement(PricingInputReplacement var1);

        public ValuationScenarioBuilder addReplacement(PricingInputReplacement var1, int var2);

        public ValuationScenarioBuilder addReplacement(List<? extends PricingInputReplacement> var1);

        public ValuationScenarioBuilder setReplacement(List<? extends PricingInputReplacement> var1);

        public ValuationScenarioBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getValuationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marketReference"), processor, MarketReference.MarketReferenceBuilder.class, this.getMarketReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("shift"), processor, PricingParameterShift.PricingParameterShiftBuilder.class, this.getShift(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("replacement"), processor, PricingInputReplacement.PricingInputReplacementBuilder.class, this.getReplacement(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ValuationScenarioBuilder prune();
    }

    public static class ValuationScenarioImpl
    implements ValuationScenario {
        private final String name;
        private final IdentifiedDate valuationDate;
        private final MarketReference marketReference;
        private final List<? extends PricingParameterShift> shift;
        private final List<? extends PricingInputReplacement> replacement;
        private final String id;

        protected ValuationScenarioImpl(ValuationScenarioBuilder builder) {
            this.name = builder.getName();
            this.valuationDate = Optional.ofNullable(builder.getValuationDate()).map(f -> f.build()).orElse(null);
            this.marketReference = Optional.ofNullable(builder.getMarketReference()).map(f -> f.build()).orElse(null);
            this.shift = Optional.ofNullable(builder.getShift()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.replacement = Optional.ofNullable(builder.getReplacement()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="valuationDate", isRequired=true)
        @RuneAttribute(value="valuationDate", isRequired=true)
        public IdentifiedDate getValuationDate() {
            return this.valuationDate;
        }

        @Override
        @RosettaAttribute(value="marketReference")
        @RuneAttribute(value="marketReference")
        public MarketReference getMarketReference() {
            return this.marketReference;
        }

        @Override
        @RosettaAttribute(value="shift")
        @RuneAttribute(value="shift")
        public List<? extends PricingParameterShift> getShift() {
            return this.shift;
        }

        @Override
        @RosettaAttribute(value="replacement")
        @RuneAttribute(value="replacement")
        public List<? extends PricingInputReplacement> getReplacement() {
            return this.replacement;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public ValuationScenario build() {
            return this;
        }

        @Override
        public ValuationScenarioBuilder toBuilder() {
            ValuationScenarioBuilder builder = ValuationScenario.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationScenarioBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getValuationDate()).ifPresent(builder::setValuationDate);
            Optional.ofNullable(this.getMarketReference()).ifPresent(builder::setMarketReference);
            Optional.ofNullable(this.getShift()).ifPresent(builder::setShift);
            Optional.ofNullable(this.getReplacement()).ifPresent(builder::setReplacement);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationScenario _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.marketReference, _that.getMarketReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.shift, _that.getShift())) {
                return false;
            }
            if (!ListEquals.listEquals(this.replacement, _that.getReplacement())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.marketReference != null ? this.marketReference.hashCode() : 0);
            _result = 31 * _result + (this.shift != null ? this.shift.hashCode() : 0);
            _result = 31 * _result + (this.replacement != null ? this.replacement.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationScenario {name=" + this.name + ", valuationDate=" + this.valuationDate + ", marketReference=" + this.marketReference + ", shift=" + this.shift + ", replacement=" + this.replacement + ", id=" + this.id + '}';
        }
    }
}

