/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AbstractEvent;
import fpml.confirmation.AgreementAndEffectiveDatesModel;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.PartyTradeIdentifier;
import fpml.confirmation.Trade;
import fpml.confirmation.TradeAlterationPaymentModel;
import fpml.confirmation.meta.TradeChangeBaseMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeChangeBase", builder=TradeChangeBaseBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TradeChangeBase", model="fpml", builder=TradeChangeBaseBuilderImpl.class, version="0.17.2")
public interface TradeChangeBase
extends AbstractEvent {
    public static final TradeChangeBaseMeta metaData = new TradeChangeBaseMeta();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public Trade getOriginalTrade();

    public Trade getResultingTrade();

    public AgreementAndEffectiveDatesModel getAgreementAndEffectiveDatesModel();

    public TradeAlterationPaymentModel getTradeAlterationPaymentModel();

    @Override
    public TradeChangeBase build();

    @Override
    public TradeChangeBaseBuilder toBuilder();

    public static TradeChangeBaseBuilder builder() {
        return new TradeChangeBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeChangeBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeChangeBase> getType() {
        return TradeChangeBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.class, this.getOriginalTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("resultingTrade"), processor, Trade.class, this.getResultingTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementAndEffectiveDatesModel"), processor, AgreementAndEffectiveDatesModel.class, this.getAgreementAndEffectiveDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeAlterationPaymentModel"), processor, TradeAlterationPaymentModel.class, this.getTradeAlterationPaymentModel(), new AttributeMeta[0]);
    }

    public static class TradeChangeBaseBuilderImpl
    extends AbstractEvent.AbstractEventBuilderImpl
    implements TradeChangeBaseBuilder {
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected Trade.TradeBuilder originalTrade;
        protected Trade.TradeBuilder resultingTrade;
        protected AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder agreementAndEffectiveDatesModel;
        protected TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder tradeAlterationPaymentModel;

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade.TradeBuilder getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateOriginalTrade() {
            Trade.TradeBuilder result = this.originalTrade != null ? this.originalTrade : (this.originalTrade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="resultingTrade")
        @RuneAttribute(value="resultingTrade")
        public Trade.TradeBuilder getResultingTrade() {
            return this.resultingTrade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateResultingTrade() {
            Trade.TradeBuilder result = this.resultingTrade != null ? this.resultingTrade : (this.resultingTrade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        @RuneAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getAgreementAndEffectiveDatesModel() {
            return this.agreementAndEffectiveDatesModel;
        }

        @Override
        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getOrCreateAgreementAndEffectiveDatesModel() {
            AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder result = this.agreementAndEffectiveDatesModel != null ? this.agreementAndEffectiveDatesModel : (this.agreementAndEffectiveDatesModel = AgreementAndEffectiveDatesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        @RuneAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        public TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder getTradeAlterationPaymentModel() {
            return this.tradeAlterationPaymentModel;
        }

        @Override
        public TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder getOrCreateTradeAlterationPaymentModel() {
            TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder result = this.tradeAlterationPaymentModel != null ? this.tradeAlterationPaymentModel : (this.tradeAlterationPaymentModel = TradeAlterationPaymentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public TradeChangeBaseBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeChangeBaseBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeChangeBaseBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public TradeChangeBaseBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public TradeChangeBaseBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeChangeBaseBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeChangeBaseBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public TradeChangeBaseBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public TradeChangeBaseBuilder setOriginalTrade(Trade _originalTrade) {
            this.originalTrade = _originalTrade == null ? null : _originalTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="resultingTrade")
        @RuneAttribute(value="resultingTrade")
        public TradeChangeBaseBuilder setResultingTrade(Trade _resultingTrade) {
            this.resultingTrade = _resultingTrade == null ? null : _resultingTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        @RuneAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        public TradeChangeBaseBuilder setAgreementAndEffectiveDatesModel(AgreementAndEffectiveDatesModel _agreementAndEffectiveDatesModel) {
            this.agreementAndEffectiveDatesModel = _agreementAndEffectiveDatesModel == null ? null : _agreementAndEffectiveDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        @RuneAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        public TradeChangeBaseBuilder setTradeAlterationPaymentModel(TradeAlterationPaymentModel _tradeAlterationPaymentModel) {
            this.tradeAlterationPaymentModel = _tradeAlterationPaymentModel == null ? null : _tradeAlterationPaymentModel.toBuilder();
            return this;
        }

        @Override
        public TradeChangeBase build() {
            return new TradeChangeBaseImpl(this);
        }

        @Override
        public TradeChangeBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeChangeBaseBuilder prune() {
            super.prune();
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.originalTrade != null && !this.originalTrade.prune().hasData()) {
                this.originalTrade = null;
            }
            if (this.resultingTrade != null && !this.resultingTrade.prune().hasData()) {
                this.resultingTrade = null;
            }
            if (this.agreementAndEffectiveDatesModel != null && !this.agreementAndEffectiveDatesModel.prune().hasData()) {
                this.agreementAndEffectiveDatesModel = null;
            }
            if (this.tradeAlterationPaymentModel != null && !this.tradeAlterationPaymentModel.prune().hasData()) {
                this.tradeAlterationPaymentModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getOriginalTrade() != null && this.getOriginalTrade().hasData()) {
                return true;
            }
            if (this.getResultingTrade() != null && this.getResultingTrade().hasData()) {
                return true;
            }
            if (this.getAgreementAndEffectiveDatesModel() != null && this.getAgreementAndEffectiveDatesModel().hasData()) {
                return true;
            }
            return this.getTradeAlterationPaymentModel() != null && this.getTradeAlterationPaymentModel().hasData();
        }

        @Override
        public TradeChangeBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TradeChangeBaseBuilder o = (TradeChangeBaseBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginalTrade(), (RosettaModelObjectBuilder)o.getOriginalTrade(), this::setOriginalTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getResultingTrade(), (RosettaModelObjectBuilder)o.getResultingTrade(), this::setResultingTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementAndEffectiveDatesModel(), (RosettaModelObjectBuilder)o.getAgreementAndEffectiveDatesModel(), this::setAgreementAndEffectiveDatesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeAlterationPaymentModel(), (RosettaModelObjectBuilder)o.getTradeAlterationPaymentModel(), this::setTradeAlterationPaymentModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeChangeBase _that = (TradeChangeBase)this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!Objects.equals(this.resultingTrade, _that.getResultingTrade())) {
                return false;
            }
            if (!Objects.equals(this.agreementAndEffectiveDatesModel, _that.getAgreementAndEffectiveDatesModel())) {
                return false;
            }
            return Objects.equals(this.tradeAlterationPaymentModel, _that.getTradeAlterationPaymentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.resultingTrade != null ? this.resultingTrade.hashCode() : 0);
            _result = 31 * _result + (this.agreementAndEffectiveDatesModel != null ? this.agreementAndEffectiveDatesModel.hashCode() : 0);
            _result = 31 * _result + (this.tradeAlterationPaymentModel != null ? this.tradeAlterationPaymentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeChangeBaseBuilder {tradeIdentifier=" + this.tradeIdentifier + ", originalTrade=" + this.originalTrade + ", resultingTrade=" + this.resultingTrade + ", agreementAndEffectiveDatesModel=" + this.agreementAndEffectiveDatesModel + ", tradeAlterationPaymentModel=" + this.tradeAlterationPaymentModel + '}' + " " + super.toString();
        }
    }

    public static interface TradeChangeBaseBuilder
    extends TradeChangeBase,
    AbstractEvent.AbstractEventBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public Trade.TradeBuilder getOrCreateOriginalTrade();

        @Override
        public Trade.TradeBuilder getOriginalTrade();

        public Trade.TradeBuilder getOrCreateResultingTrade();

        @Override
        public Trade.TradeBuilder getResultingTrade();

        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getOrCreateAgreementAndEffectiveDatesModel();

        @Override
        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getAgreementAndEffectiveDatesModel();

        public TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder getOrCreateTradeAlterationPaymentModel();

        @Override
        public TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder getTradeAlterationPaymentModel();

        @Override
        public TradeChangeBaseBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public TradeChangeBaseBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public TradeChangeBaseBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public TradeChangeBaseBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public TradeChangeBaseBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public TradeChangeBaseBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public TradeChangeBaseBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeChangeBaseBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeChangeBaseBuilder setOriginalTrade(Trade var1);

        public TradeChangeBaseBuilder setResultingTrade(Trade var1);

        public TradeChangeBaseBuilder setAgreementAndEffectiveDatesModel(AgreementAndEffectiveDatesModel var1);

        public TradeChangeBaseBuilder setTradeAlterationPaymentModel(TradeAlterationPaymentModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.TradeBuilder.class, this.getOriginalTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("resultingTrade"), processor, Trade.TradeBuilder.class, this.getResultingTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementAndEffectiveDatesModel"), processor, AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder.class, this.getAgreementAndEffectiveDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeAlterationPaymentModel"), processor, TradeAlterationPaymentModel.TradeAlterationPaymentModelBuilder.class, this.getTradeAlterationPaymentModel(), new AttributeMeta[0]);
        }

        @Override
        public TradeChangeBaseBuilder prune();
    }

    public static class TradeChangeBaseImpl
    extends AbstractEvent.AbstractEventImpl
    implements TradeChangeBase {
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final Trade originalTrade;
        private final Trade resultingTrade;
        private final AgreementAndEffectiveDatesModel agreementAndEffectiveDatesModel;
        private final TradeAlterationPaymentModel tradeAlterationPaymentModel;

        protected TradeChangeBaseImpl(TradeChangeBaseBuilder builder) {
            super(builder);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.originalTrade = Optional.ofNullable(builder.getOriginalTrade()).map(f -> f.build()).orElse(null);
            this.resultingTrade = Optional.ofNullable(builder.getResultingTrade()).map(f -> f.build()).orElse(null);
            this.agreementAndEffectiveDatesModel = Optional.ofNullable(builder.getAgreementAndEffectiveDatesModel()).map(f -> f.build()).orElse(null);
            this.tradeAlterationPaymentModel = Optional.ofNullable(builder.getTradeAlterationPaymentModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        @RosettaAttribute(value="resultingTrade")
        @RuneAttribute(value="resultingTrade")
        public Trade getResultingTrade() {
            return this.resultingTrade;
        }

        @Override
        @RosettaAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        @RuneAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        public AgreementAndEffectiveDatesModel getAgreementAndEffectiveDatesModel() {
            return this.agreementAndEffectiveDatesModel;
        }

        @Override
        @RosettaAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        @RuneAttribute(value="tradeAlterationPaymentModel", isRequired=true)
        public TradeAlterationPaymentModel getTradeAlterationPaymentModel() {
            return this.tradeAlterationPaymentModel;
        }

        @Override
        public TradeChangeBase build() {
            return this;
        }

        @Override
        public TradeChangeBaseBuilder toBuilder() {
            TradeChangeBaseBuilder builder = TradeChangeBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeChangeBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getOriginalTrade()).ifPresent(builder::setOriginalTrade);
            Optional.ofNullable(this.getResultingTrade()).ifPresent(builder::setResultingTrade);
            Optional.ofNullable(this.getAgreementAndEffectiveDatesModel()).ifPresent(builder::setAgreementAndEffectiveDatesModel);
            Optional.ofNullable(this.getTradeAlterationPaymentModel()).ifPresent(builder::setTradeAlterationPaymentModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TradeChangeBase _that = (TradeChangeBase)this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!Objects.equals(this.resultingTrade, _that.getResultingTrade())) {
                return false;
            }
            if (!Objects.equals(this.agreementAndEffectiveDatesModel, _that.getAgreementAndEffectiveDatesModel())) {
                return false;
            }
            return Objects.equals(this.tradeAlterationPaymentModel, _that.getTradeAlterationPaymentModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.resultingTrade != null ? this.resultingTrade.hashCode() : 0);
            _result = 31 * _result + (this.agreementAndEffectiveDatesModel != null ? this.agreementAndEffectiveDatesModel.hashCode() : 0);
            _result = 31 * _result + (this.tradeAlterationPaymentModel != null ? this.tradeAlterationPaymentModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TradeChangeBase {tradeIdentifier=" + this.tradeIdentifier + ", originalTrade=" + this.originalTrade + ", resultingTrade=" + this.resultingTrade + ", agreementAndEffectiveDatesModel=" + this.agreementAndEffectiveDatesModel + ", tradeAlterationPaymentModel=" + this.tradeAlterationPaymentModel + '}' + " " + super.toString();
        }
    }
}

