/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.WithholdingTaxReason;
import fpml.confirmation.meta.TaxWithholdingMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="TaxWithholding", builder=TaxWithholdingBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TaxWithholding", model="fpml", builder=TaxWithholdingBuilderImpl.class, version="0.17.2")
public interface TaxWithholding
extends RosettaModelObject {
    public static final TaxWithholdingMeta metaData = new TaxWithholdingMeta();

    public NonNegativeMoney getAmount();

    public BigDecimal getTaxRate();

    public WithholdingTaxReason getReason();

    public TaxWithholding build();

    public TaxWithholdingBuilder toBuilder();

    public static TaxWithholdingBuilder builder() {
        return new TaxWithholdingBuilderImpl();
    }

    default public RosettaMetaData<? extends TaxWithholding> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TaxWithholding> getType() {
        return TaxWithholding.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("taxRate"), BigDecimal.class, (Object)this.getTaxRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, WithholdingTaxReason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class TaxWithholdingBuilderImpl
    implements TaxWithholdingBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected BigDecimal taxRate;
        protected WithholdingTaxReason.WithholdingTaxReasonBuilder reason;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="taxRate")
        @RuneAttribute(value="taxRate")
        public BigDecimal getTaxRate() {
            return this.taxRate;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public WithholdingTaxReason.WithholdingTaxReasonBuilder getReason() {
            return this.reason;
        }

        @Override
        public WithholdingTaxReason.WithholdingTaxReasonBuilder getOrCreateReason() {
            WithholdingTaxReason.WithholdingTaxReasonBuilder result = this.reason != null ? this.reason : (this.reason = WithholdingTaxReason.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public TaxWithholdingBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="taxRate")
        @RuneAttribute(value="taxRate")
        public TaxWithholdingBuilder setTaxRate(BigDecimal _taxRate) {
            this.taxRate = _taxRate == null ? null : _taxRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public TaxWithholdingBuilder setReason(WithholdingTaxReason _reason) {
            this.reason = _reason == null ? null : _reason.toBuilder();
            return this;
        }

        @Override
        public TaxWithholding build() {
            return new TaxWithholdingImpl(this);
        }

        @Override
        public TaxWithholdingBuilder toBuilder() {
            return this;
        }

        @Override
        public TaxWithholdingBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.reason != null && !this.reason.prune().hasData()) {
                this.reason = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getTaxRate() != null) {
                return true;
            }
            return this.getReason() != null && this.getReason().hasData();
        }

        public TaxWithholdingBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TaxWithholdingBuilder o = (TaxWithholdingBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReason(), (RosettaModelObjectBuilder)o.getReason(), this::setReason);
            merger.mergeBasic((Object)this.getTaxRate(), (Object)o.getTaxRate(), this::setTaxRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TaxWithholding _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.taxRate, _that.getTaxRate())) {
                return false;
            }
            return Objects.equals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.taxRate != null ? this.taxRate.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TaxWithholdingBuilder {amount=" + this.amount + ", taxRate=" + this.taxRate + ", reason=" + this.reason + '}';
        }
    }

    public static interface TaxWithholdingBuilder
    extends TaxWithholding,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        public WithholdingTaxReason.WithholdingTaxReasonBuilder getOrCreateReason();

        @Override
        public WithholdingTaxReason.WithholdingTaxReasonBuilder getReason();

        public TaxWithholdingBuilder setAmount(NonNegativeMoney var1);

        public TaxWithholdingBuilder setTaxRate(BigDecimal var1);

        public TaxWithholdingBuilder setReason(WithholdingTaxReason var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("taxRate"), BigDecimal.class, (Object)this.getTaxRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, WithholdingTaxReason.WithholdingTaxReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        public TaxWithholdingBuilder prune();
    }

    public static class TaxWithholdingImpl
    implements TaxWithholding {
        private final NonNegativeMoney amount;
        private final BigDecimal taxRate;
        private final WithholdingTaxReason reason;

        protected TaxWithholdingImpl(TaxWithholdingBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.taxRate = builder.getTaxRate();
            this.reason = Optional.ofNullable(builder.getReason()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="taxRate")
        @RuneAttribute(value="taxRate")
        public BigDecimal getTaxRate() {
            return this.taxRate;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public WithholdingTaxReason getReason() {
            return this.reason;
        }

        @Override
        public TaxWithholding build() {
            return this;
        }

        @Override
        public TaxWithholdingBuilder toBuilder() {
            TaxWithholdingBuilder builder = TaxWithholding.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TaxWithholdingBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getTaxRate()).ifPresent(builder::setTaxRate);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TaxWithholding _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.taxRate, _that.getTaxRate())) {
                return false;
            }
            return Objects.equals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.taxRate != null ? this.taxRate.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TaxWithholding {amount=" + this.amount + ", taxRate=" + this.taxRate + ", reason=" + this.reason + '}';
        }
    }
}

