/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CancelableProvision;
import fpml.confirmation.EarlyTerminationProvision;
import fpml.confirmation.ExtendibleProvision;
import fpml.confirmation.InterestRateStream;
import fpml.confirmation.Payment;
import fpml.confirmation.Product;
import fpml.confirmation.ProductModel;
import fpml.confirmation.SwapAdditionalTerms;
import fpml.confirmation.meta.SwapMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Swap", builder=SwapBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Swap", model="fpml", builder=SwapBuilderImpl.class, version="0.17.2")
public interface Swap
extends Product {
    public static final SwapMeta metaData = new SwapMeta();

    public List<? extends InterestRateStream> getSwapStream();

    public EarlyTerminationProvision getEarlyTerminationProvision();

    public CancelableProvision getCancelableProvision();

    public ExtendibleProvision getExtendibleProvision();

    public List<? extends Payment> getAdditionalPayment();

    public SwapAdditionalTerms getAdditionalTerms();

    @Override
    public Swap build();

    @Override
    public SwapBuilder toBuilder();

    public static SwapBuilder builder() {
        return new SwapBuilderImpl();
    }

    default public RosettaMetaData<? extends Swap> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Swap> getType() {
        return Swap.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("swapStream"), processor, InterestRateStream.class, this.getSwapStream(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("earlyTerminationProvision"), processor, EarlyTerminationProvision.class, this.getEarlyTerminationProvision(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cancelableProvision"), processor, CancelableProvision.class, this.getCancelableProvision(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extendibleProvision"), processor, ExtendibleProvision.class, this.getExtendibleProvision(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalTerms"), processor, SwapAdditionalTerms.class, this.getAdditionalTerms(), new AttributeMeta[0]);
    }

    public static class SwapBuilderImpl
    extends Product.ProductBuilderImpl
    implements SwapBuilder {
        protected List<InterestRateStream.InterestRateStreamBuilder> swapStream = new ArrayList<InterestRateStream.InterestRateStreamBuilder>();
        protected EarlyTerminationProvision.EarlyTerminationProvisionBuilder earlyTerminationProvision;
        protected CancelableProvision.CancelableProvisionBuilder cancelableProvision;
        protected ExtendibleProvision.ExtendibleProvisionBuilder extendibleProvision;
        protected List<Payment.PaymentBuilder> additionalPayment = new ArrayList<Payment.PaymentBuilder>();
        protected SwapAdditionalTerms.SwapAdditionalTermsBuilder additionalTerms;

        @Override
        @RosettaAttribute(value="swapStream", isRequired=true)
        @RuneAttribute(value="swapStream", isRequired=true)
        public List<? extends InterestRateStream.InterestRateStreamBuilder> getSwapStream() {
            return this.swapStream;
        }

        @Override
        public InterestRateStream.InterestRateStreamBuilder getOrCreateSwapStream(int index) {
            if (this.swapStream == null) {
                this.swapStream = new ArrayList<InterestRateStream.InterestRateStreamBuilder>();
            }
            return (InterestRateStream.InterestRateStreamBuilder)this.getIndex(this.swapStream, index, () -> {
                InterestRateStream.InterestRateStreamBuilder newSwapStream = InterestRateStream.builder();
                return newSwapStream;
            });
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getEarlyTerminationProvision() {
            return this.earlyTerminationProvision;
        }

        @Override
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getOrCreateEarlyTerminationProvision() {
            EarlyTerminationProvision.EarlyTerminationProvisionBuilder result = this.earlyTerminationProvision != null ? this.earlyTerminationProvision : (this.earlyTerminationProvision = EarlyTerminationProvision.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cancelableProvision")
        @RuneAttribute(value="cancelableProvision")
        public CancelableProvision.CancelableProvisionBuilder getCancelableProvision() {
            return this.cancelableProvision;
        }

        @Override
        public CancelableProvision.CancelableProvisionBuilder getOrCreateCancelableProvision() {
            CancelableProvision.CancelableProvisionBuilder result = this.cancelableProvision != null ? this.cancelableProvision : (this.cancelableProvision = CancelableProvision.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="extendibleProvision")
        @RuneAttribute(value="extendibleProvision")
        public ExtendibleProvision.ExtendibleProvisionBuilder getExtendibleProvision() {
            return this.extendibleProvision;
        }

        @Override
        public ExtendibleProvision.ExtendibleProvisionBuilder getOrCreateExtendibleProvision() {
            ExtendibleProvision.ExtendibleProvisionBuilder result = this.extendibleProvision != null ? this.extendibleProvision : (this.extendibleProvision = ExtendibleProvision.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment.PaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                Payment.PaymentBuilder newAdditionalPayment = Payment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="additionalTerms")
        @RuneAttribute(value="additionalTerms")
        public SwapAdditionalTerms.SwapAdditionalTermsBuilder getAdditionalTerms() {
            return this.additionalTerms;
        }

        @Override
        public SwapAdditionalTerms.SwapAdditionalTermsBuilder getOrCreateAdditionalTerms() {
            SwapAdditionalTerms.SwapAdditionalTermsBuilder result = this.additionalTerms != null ? this.additionalTerms : (this.additionalTerms = SwapAdditionalTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public SwapBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SwapBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapStream", isRequired=true)
        @RuneAttribute(value="swapStream", isRequired=true)
        public SwapBuilder addSwapStream(InterestRateStream _swapStream) {
            if (_swapStream != null) {
                this.swapStream.add(_swapStream.toBuilder());
            }
            return this;
        }

        @Override
        public SwapBuilder addSwapStream(InterestRateStream _swapStream, int idx) {
            this.getIndex(this.swapStream, idx, () -> _swapStream.toBuilder());
            return this;
        }

        @Override
        public SwapBuilder addSwapStream(List<? extends InterestRateStream> swapStreams) {
            if (swapStreams != null) {
                for (InterestRateStream interestRateStream : swapStreams) {
                    this.swapStream.add(interestRateStream.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="swapStream")
        public SwapBuilder setSwapStream(List<? extends InterestRateStream> swapStreams) {
            this.swapStream = swapStreams == null ? new ArrayList<InterestRateStream.InterestRateStreamBuilder>() : (List)swapStreams.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public SwapBuilder setEarlyTerminationProvision(EarlyTerminationProvision _earlyTerminationProvision) {
            this.earlyTerminationProvision = _earlyTerminationProvision == null ? null : _earlyTerminationProvision.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cancelableProvision")
        @RuneAttribute(value="cancelableProvision")
        public SwapBuilder setCancelableProvision(CancelableProvision _cancelableProvision) {
            this.cancelableProvision = _cancelableProvision == null ? null : _cancelableProvision.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="extendibleProvision")
        @RuneAttribute(value="extendibleProvision")
        public SwapBuilder setExtendibleProvision(ExtendibleProvision _extendibleProvision) {
            this.extendibleProvision = _extendibleProvision == null ? null : _extendibleProvision.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public SwapBuilder addAdditionalPayment(Payment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public SwapBuilder addAdditionalPayment(Payment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public SwapBuilder addAdditionalPayment(List<? extends Payment> additionalPayments) {
            if (additionalPayments != null) {
                for (Payment payment : additionalPayments) {
                    this.additionalPayment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public SwapBuilder setAdditionalPayment(List<? extends Payment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalTerms")
        @RuneAttribute(value="additionalTerms")
        public SwapBuilder setAdditionalTerms(SwapAdditionalTerms _additionalTerms) {
            this.additionalTerms = _additionalTerms == null ? null : _additionalTerms.toBuilder();
            return this;
        }

        @Override
        public Swap build() {
            return new SwapImpl(this);
        }

        @Override
        public SwapBuilder toBuilder() {
            return this;
        }

        @Override
        public SwapBuilder prune() {
            super.prune();
            this.swapStream = this.swapStream.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.earlyTerminationProvision != null && !this.earlyTerminationProvision.prune().hasData()) {
                this.earlyTerminationProvision = null;
            }
            if (this.cancelableProvision != null && !this.cancelableProvision.prune().hasData()) {
                this.cancelableProvision = null;
            }
            if (this.extendibleProvision != null && !this.extendibleProvision.prune().hasData()) {
                this.extendibleProvision = null;
            }
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.additionalTerms != null && !this.additionalTerms.prune().hasData()) {
                this.additionalTerms = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSwapStream() != null && this.getSwapStream().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEarlyTerminationProvision() != null && this.getEarlyTerminationProvision().hasData()) {
                return true;
            }
            if (this.getCancelableProvision() != null && this.getCancelableProvision().hasData()) {
                return true;
            }
            if (this.getExtendibleProvision() != null && this.getExtendibleProvision().hasData()) {
                return true;
            }
            if (this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getAdditionalTerms() != null && this.getAdditionalTerms().hasData();
        }

        @Override
        public SwapBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SwapBuilder o = (SwapBuilder)other;
            merger.mergeRosetta(this.getSwapStream(), o.getSwapStream(), this::getOrCreateSwapStream);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEarlyTerminationProvision(), (RosettaModelObjectBuilder)o.getEarlyTerminationProvision(), this::setEarlyTerminationProvision);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCancelableProvision(), (RosettaModelObjectBuilder)o.getCancelableProvision(), this::setCancelableProvision);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExtendibleProvision(), (RosettaModelObjectBuilder)o.getExtendibleProvision(), this::setExtendibleProvision);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalTerms(), (RosettaModelObjectBuilder)o.getAdditionalTerms(), this::setAdditionalTerms);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Swap _that = (Swap)this.getType().cast(o);
            if (!ListEquals.listEquals(this.swapStream, _that.getSwapStream())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationProvision, _that.getEarlyTerminationProvision())) {
                return false;
            }
            if (!Objects.equals(this.cancelableProvision, _that.getCancelableProvision())) {
                return false;
            }
            if (!Objects.equals(this.extendibleProvision, _that.getExtendibleProvision())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.additionalTerms, _that.getAdditionalTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.swapStream != null ? this.swapStream.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationProvision != null ? this.earlyTerminationProvision.hashCode() : 0);
            _result = 31 * _result + (this.cancelableProvision != null ? this.cancelableProvision.hashCode() : 0);
            _result = 31 * _result + (this.extendibleProvision != null ? this.extendibleProvision.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.additionalTerms != null ? this.additionalTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SwapBuilder {swapStream=" + this.swapStream + ", earlyTerminationProvision=" + this.earlyTerminationProvision + ", cancelableProvision=" + this.cancelableProvision + ", extendibleProvision=" + this.extendibleProvision + ", additionalPayment=" + this.additionalPayment + ", additionalTerms=" + this.additionalTerms + '}' + " " + super.toString();
        }
    }

    public static interface SwapBuilder
    extends Swap,
    Product.ProductBuilder {
        public InterestRateStream.InterestRateStreamBuilder getOrCreateSwapStream(int var1);

        public List<? extends InterestRateStream.InterestRateStreamBuilder> getSwapStream();

        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getOrCreateEarlyTerminationProvision();

        @Override
        public EarlyTerminationProvision.EarlyTerminationProvisionBuilder getEarlyTerminationProvision();

        public CancelableProvision.CancelableProvisionBuilder getOrCreateCancelableProvision();

        @Override
        public CancelableProvision.CancelableProvisionBuilder getCancelableProvision();

        public ExtendibleProvision.ExtendibleProvisionBuilder getOrCreateExtendibleProvision();

        @Override
        public ExtendibleProvision.ExtendibleProvisionBuilder getExtendibleProvision();

        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends Payment.PaymentBuilder> getAdditionalPayment();

        public SwapAdditionalTerms.SwapAdditionalTermsBuilder getOrCreateAdditionalTerms();

        @Override
        public SwapAdditionalTerms.SwapAdditionalTermsBuilder getAdditionalTerms();

        @Override
        public SwapBuilder setProductModel(ProductModel var1);

        @Override
        public SwapBuilder setId(String var1);

        public SwapBuilder addSwapStream(InterestRateStream var1);

        public SwapBuilder addSwapStream(InterestRateStream var1, int var2);

        public SwapBuilder addSwapStream(List<? extends InterestRateStream> var1);

        public SwapBuilder setSwapStream(List<? extends InterestRateStream> var1);

        public SwapBuilder setEarlyTerminationProvision(EarlyTerminationProvision var1);

        public SwapBuilder setCancelableProvision(CancelableProvision var1);

        public SwapBuilder setExtendibleProvision(ExtendibleProvision var1);

        public SwapBuilder addAdditionalPayment(Payment var1);

        public SwapBuilder addAdditionalPayment(Payment var1, int var2);

        public SwapBuilder addAdditionalPayment(List<? extends Payment> var1);

        public SwapBuilder setAdditionalPayment(List<? extends Payment> var1);

        public SwapBuilder setAdditionalTerms(SwapAdditionalTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("swapStream"), processor, InterestRateStream.InterestRateStreamBuilder.class, this.getSwapStream(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("earlyTerminationProvision"), processor, EarlyTerminationProvision.EarlyTerminationProvisionBuilder.class, this.getEarlyTerminationProvision(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cancelableProvision"), processor, CancelableProvision.CancelableProvisionBuilder.class, this.getCancelableProvision(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extendibleProvision"), processor, ExtendibleProvision.ExtendibleProvisionBuilder.class, this.getExtendibleProvision(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.PaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalTerms"), processor, SwapAdditionalTerms.SwapAdditionalTermsBuilder.class, this.getAdditionalTerms(), new AttributeMeta[0]);
        }

        @Override
        public SwapBuilder prune();
    }

    public static class SwapImpl
    extends Product.ProductImpl
    implements Swap {
        private final List<? extends InterestRateStream> swapStream;
        private final EarlyTerminationProvision earlyTerminationProvision;
        private final CancelableProvision cancelableProvision;
        private final ExtendibleProvision extendibleProvision;
        private final List<? extends Payment> additionalPayment;
        private final SwapAdditionalTerms additionalTerms;

        protected SwapImpl(SwapBuilder builder) {
            super(builder);
            this.swapStream = Optional.ofNullable(builder.getSwapStream()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.earlyTerminationProvision = Optional.ofNullable(builder.getEarlyTerminationProvision()).map(f -> f.build()).orElse(null);
            this.cancelableProvision = Optional.ofNullable(builder.getCancelableProvision()).map(f -> f.build()).orElse(null);
            this.extendibleProvision = Optional.ofNullable(builder.getExtendibleProvision()).map(f -> f.build()).orElse(null);
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.additionalTerms = Optional.ofNullable(builder.getAdditionalTerms()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="swapStream", isRequired=true)
        @RuneAttribute(value="swapStream", isRequired=true)
        public List<? extends InterestRateStream> getSwapStream() {
            return this.swapStream;
        }

        @Override
        @RosettaAttribute(value="earlyTerminationProvision")
        @RuneAttribute(value="earlyTerminationProvision")
        public EarlyTerminationProvision getEarlyTerminationProvision() {
            return this.earlyTerminationProvision;
        }

        @Override
        @RosettaAttribute(value="cancelableProvision")
        @RuneAttribute(value="cancelableProvision")
        public CancelableProvision getCancelableProvision() {
            return this.cancelableProvision;
        }

        @Override
        @RosettaAttribute(value="extendibleProvision")
        @RuneAttribute(value="extendibleProvision")
        public ExtendibleProvision getExtendibleProvision() {
            return this.extendibleProvision;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        @RosettaAttribute(value="additionalTerms")
        @RuneAttribute(value="additionalTerms")
        public SwapAdditionalTerms getAdditionalTerms() {
            return this.additionalTerms;
        }

        @Override
        public Swap build() {
            return this;
        }

        @Override
        public SwapBuilder toBuilder() {
            SwapBuilder builder = Swap.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SwapBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSwapStream()).ifPresent(builder::setSwapStream);
            Optional.ofNullable(this.getEarlyTerminationProvision()).ifPresent(builder::setEarlyTerminationProvision);
            Optional.ofNullable(this.getCancelableProvision()).ifPresent(builder::setCancelableProvision);
            Optional.ofNullable(this.getExtendibleProvision()).ifPresent(builder::setExtendibleProvision);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
            Optional.ofNullable(this.getAdditionalTerms()).ifPresent(builder::setAdditionalTerms);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Swap _that = (Swap)this.getType().cast(o);
            if (!ListEquals.listEquals(this.swapStream, _that.getSwapStream())) {
                return false;
            }
            if (!Objects.equals(this.earlyTerminationProvision, _that.getEarlyTerminationProvision())) {
                return false;
            }
            if (!Objects.equals(this.cancelableProvision, _that.getCancelableProvision())) {
                return false;
            }
            if (!Objects.equals(this.extendibleProvision, _that.getExtendibleProvision())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.additionalTerms, _that.getAdditionalTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.swapStream != null ? this.swapStream.hashCode() : 0);
            _result = 31 * _result + (this.earlyTerminationProvision != null ? this.earlyTerminationProvision.hashCode() : 0);
            _result = 31 * _result + (this.cancelableProvision != null ? this.cancelableProvision.hashCode() : 0);
            _result = 31 * _result + (this.extendibleProvision != null ? this.extendibleProvision.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.additionalTerms != null ? this.additionalTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Swap {swapStream=" + this.swapStream + ", earlyTerminationProvision=" + this.earlyTerminationProvision + ", cancelableProvision=" + this.cancelableProvision + ", extendibleProvision=" + this.extendibleProvision + ", additionalPayment=" + this.additionalPayment + ", additionalTerms=" + this.additionalTerms + '}' + " " + super.toString();
        }
    }
}

