/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.meta.SignatureMethodTypeMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SignatureMethodType", builder=SignatureMethodTypeBuilderImpl.class, version="0.17.2")
@RuneDataType(value="SignatureMethodType", model="fpml", builder=SignatureMethodTypeBuilderImpl.class, version="0.17.2")
public interface SignatureMethodType
extends RosettaModelObject {
    public static final SignatureMethodTypeMeta metaData = new SignatureMethodTypeMeta();

    public Integer getHmacOutputLength();

    public List<String> getAnyContents();

    public String getAlgorithm();

    public SignatureMethodType build();

    public SignatureMethodTypeBuilder toBuilder();

    public static SignatureMethodTypeBuilder builder() {
        return new SignatureMethodTypeBuilderImpl();
    }

    default public RosettaMetaData<? extends SignatureMethodType> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SignatureMethodType> getType() {
        return SignatureMethodType.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("hmacOutputLength"), Integer.class, (Object)this.getHmacOutputLength(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("anyContents"), String.class, this.getAnyContents(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("algorithm"), String.class, (Object)this.getAlgorithm(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SignatureMethodTypeBuilderImpl
    implements SignatureMethodTypeBuilder {
        protected Integer hmacOutputLength;
        protected List<String> anyContents = new ArrayList<String>();
        protected String algorithm;

        @Override
        @RosettaAttribute(value="hmacOutputLength")
        @RuneAttribute(value="hmacOutputLength")
        public Integer getHmacOutputLength() {
            return this.hmacOutputLength;
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public List<String> getAnyContents() {
            return this.anyContents;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        @RosettaAttribute(value="hmacOutputLength")
        @RuneAttribute(value="hmacOutputLength")
        public SignatureMethodTypeBuilder setHmacOutputLength(Integer _hmacOutputLength) {
            this.hmacOutputLength = _hmacOutputLength == null ? null : _hmacOutputLength;
            return this;
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public SignatureMethodTypeBuilder addAnyContents(String _anyContents) {
            if (_anyContents != null) {
                this.anyContents.add(_anyContents);
            }
            return this;
        }

        @Override
        public SignatureMethodTypeBuilder addAnyContents(String _anyContents, int idx) {
            this.getIndex(this.anyContents, idx, () -> _anyContents);
            return this;
        }

        @Override
        public SignatureMethodTypeBuilder addAnyContents(List<String> anyContentss) {
            if (anyContentss != null) {
                for (String toAdd : anyContentss) {
                    this.anyContents.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="anyContents")
        public SignatureMethodTypeBuilder setAnyContents(List<String> anyContentss) {
            this.anyContents = anyContentss == null ? new ArrayList<String>() : (List)anyContentss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public SignatureMethodTypeBuilder setAlgorithm(String _algorithm) {
            this.algorithm = _algorithm == null ? null : _algorithm;
            return this;
        }

        @Override
        public SignatureMethodType build() {
            return new SignatureMethodTypeImpl(this);
        }

        @Override
        public SignatureMethodTypeBuilder toBuilder() {
            return this;
        }

        @Override
        public SignatureMethodTypeBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getHmacOutputLength() != null) {
                return true;
            }
            if (this.getAnyContents() != null && !this.getAnyContents().isEmpty()) {
                return true;
            }
            return this.getAlgorithm() != null;
        }

        public SignatureMethodTypeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SignatureMethodTypeBuilder o = (SignatureMethodTypeBuilder)other;
            merger.mergeBasic((Object)this.getHmacOutputLength(), (Object)o.getHmacOutputLength(), this::setHmacOutputLength, new AttributeMeta[0]);
            merger.mergeBasic(this.getAnyContents(), o.getAnyContents(), this::addAnyContents);
            merger.mergeBasic((Object)this.getAlgorithm(), (Object)o.getAlgorithm(), this::setAlgorithm, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SignatureMethodType _that = this.getType().cast(o);
            if (!Objects.equals(this.hmacOutputLength, _that.getHmacOutputLength())) {
                return false;
            }
            if (!ListEquals.listEquals(this.anyContents, _that.getAnyContents())) {
                return false;
            }
            return Objects.equals(this.algorithm, _that.getAlgorithm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.hmacOutputLength != null ? this.hmacOutputLength.hashCode() : 0);
            _result = 31 * _result + (this.anyContents != null ? this.anyContents.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SignatureMethodTypeBuilder {hmacOutputLength=" + this.hmacOutputLength + ", anyContents=" + this.anyContents + ", algorithm=" + this.algorithm + '}';
        }
    }

    public static interface SignatureMethodTypeBuilder
    extends SignatureMethodType,
    RosettaModelObjectBuilder {
        public SignatureMethodTypeBuilder setHmacOutputLength(Integer var1);

        public SignatureMethodTypeBuilder addAnyContents(String var1);

        public SignatureMethodTypeBuilder addAnyContents(String var1, int var2);

        public SignatureMethodTypeBuilder addAnyContents(List<String> var1);

        public SignatureMethodTypeBuilder setAnyContents(List<String> var1);

        public SignatureMethodTypeBuilder setAlgorithm(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("hmacOutputLength"), Integer.class, (Object)this.getHmacOutputLength(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("anyContents"), String.class, this.getAnyContents(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("algorithm"), String.class, (Object)this.getAlgorithm(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SignatureMethodTypeBuilder prune();
    }

    public static class SignatureMethodTypeImpl
    implements SignatureMethodType {
        private final Integer hmacOutputLength;
        private final List<String> anyContents;
        private final String algorithm;

        protected SignatureMethodTypeImpl(SignatureMethodTypeBuilder builder) {
            this.hmacOutputLength = builder.getHmacOutputLength();
            this.anyContents = Optional.ofNullable(builder.getAnyContents()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.algorithm = builder.getAlgorithm();
        }

        @Override
        @RosettaAttribute(value="hmacOutputLength")
        @RuneAttribute(value="hmacOutputLength")
        public Integer getHmacOutputLength() {
            return this.hmacOutputLength;
        }

        @Override
        @RosettaAttribute(value="anyContents")
        @RuneAttribute(value="anyContents")
        public List<String> getAnyContents() {
            return this.anyContents;
        }

        @Override
        @RosettaAttribute(value="algorithm", isRequired=true)
        @RuneAttribute(value="algorithm", isRequired=true)
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public SignatureMethodType build() {
            return this;
        }

        @Override
        public SignatureMethodTypeBuilder toBuilder() {
            SignatureMethodTypeBuilder builder = SignatureMethodType.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SignatureMethodTypeBuilder builder) {
            Optional.ofNullable(this.getHmacOutputLength()).ifPresent(builder::setHmacOutputLength);
            Optional.ofNullable(this.getAnyContents()).ifPresent(builder::setAnyContents);
            Optional.ofNullable(this.getAlgorithm()).ifPresent(builder::setAlgorithm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SignatureMethodType _that = this.getType().cast(o);
            if (!Objects.equals(this.hmacOutputLength, _that.getHmacOutputLength())) {
                return false;
            }
            if (!ListEquals.listEquals(this.anyContents, _that.getAnyContents())) {
                return false;
            }
            return Objects.equals(this.algorithm, _that.getAlgorithm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.hmacOutputLength != null ? this.hmacOutputLength.hashCode() : 0);
            _result = 31 * _result + (this.anyContents != null ? this.anyContents.hashCode() : 0);
            _result = 31 * _result + (this.algorithm != null ? this.algorithm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SignatureMethodType {hmacOutputLength=" + this.hmacOutputLength + ", anyContents=" + this.anyContents + ", algorithm=" + this.algorithm + '}';
        }
    }
}

