/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Currency;
import fpml.confirmation.NonDeliverableSettlement;
import fpml.confirmation.meta.SettlementProvisionMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SettlementProvision", builder=SettlementProvisionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="SettlementProvision", model="fpml", builder=SettlementProvisionBuilderImpl.class, version="0.17.2")
public interface SettlementProvision
extends RosettaModelObject {
    public static final SettlementProvisionMeta metaData = new SettlementProvisionMeta();

    public Currency getSettlementCurrency();

    public NonDeliverableSettlement getNonDeliverableSettlement();

    public SettlementProvision build();

    public SettlementProvisionBuilder toBuilder();

    public static SettlementProvisionBuilder builder() {
        return new SettlementProvisionBuilderImpl();
    }

    default public RosettaMetaData<? extends SettlementProvision> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SettlementProvision> getType() {
        return SettlementProvision.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonDeliverableSettlement"), processor, NonDeliverableSettlement.class, this.getNonDeliverableSettlement(), new AttributeMeta[0]);
    }

    public static class SettlementProvisionBuilderImpl
    implements SettlementProvisionBuilder {
        protected Currency.CurrencyBuilder settlementCurrency;
        protected NonDeliverableSettlement.NonDeliverableSettlementBuilder nonDeliverableSettlement;

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public Currency.CurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency() {
            Currency.CurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonDeliverableSettlement")
        @RuneAttribute(value="nonDeliverableSettlement")
        public NonDeliverableSettlement.NonDeliverableSettlementBuilder getNonDeliverableSettlement() {
            return this.nonDeliverableSettlement;
        }

        @Override
        public NonDeliverableSettlement.NonDeliverableSettlementBuilder getOrCreateNonDeliverableSettlement() {
            NonDeliverableSettlement.NonDeliverableSettlementBuilder result = this.nonDeliverableSettlement != null ? this.nonDeliverableSettlement : (this.nonDeliverableSettlement = NonDeliverableSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public SettlementProvisionBuilder setSettlementCurrency(Currency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonDeliverableSettlement")
        @RuneAttribute(value="nonDeliverableSettlement")
        public SettlementProvisionBuilder setNonDeliverableSettlement(NonDeliverableSettlement _nonDeliverableSettlement) {
            this.nonDeliverableSettlement = _nonDeliverableSettlement == null ? null : _nonDeliverableSettlement.toBuilder();
            return this;
        }

        @Override
        public SettlementProvision build() {
            return new SettlementProvisionImpl(this);
        }

        @Override
        public SettlementProvisionBuilder toBuilder() {
            return this;
        }

        @Override
        public SettlementProvisionBuilder prune() {
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            if (this.nonDeliverableSettlement != null && !this.nonDeliverableSettlement.prune().hasData()) {
                this.nonDeliverableSettlement = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            return this.getNonDeliverableSettlement() != null && this.getNonDeliverableSettlement().hasData();
        }

        public SettlementProvisionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SettlementProvisionBuilder o = (SettlementProvisionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNonDeliverableSettlement(), (RosettaModelObjectBuilder)o.getNonDeliverableSettlement(), this::setNonDeliverableSettlement);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementProvision _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            return Objects.equals(this.nonDeliverableSettlement, _that.getNonDeliverableSettlement());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.nonDeliverableSettlement != null ? this.nonDeliverableSettlement.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementProvisionBuilder {settlementCurrency=" + this.settlementCurrency + ", nonDeliverableSettlement=" + this.nonDeliverableSettlement + '}';
        }
    }

    public static interface SettlementProvisionBuilder
    extends SettlementProvision,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public Currency.CurrencyBuilder getSettlementCurrency();

        public NonDeliverableSettlement.NonDeliverableSettlementBuilder getOrCreateNonDeliverableSettlement();

        @Override
        public NonDeliverableSettlement.NonDeliverableSettlementBuilder getNonDeliverableSettlement();

        public SettlementProvisionBuilder setSettlementCurrency(Currency var1);

        public SettlementProvisionBuilder setNonDeliverableSettlement(NonDeliverableSettlement var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonDeliverableSettlement"), processor, NonDeliverableSettlement.NonDeliverableSettlementBuilder.class, this.getNonDeliverableSettlement(), new AttributeMeta[0]);
        }

        public SettlementProvisionBuilder prune();
    }

    public static class SettlementProvisionImpl
    implements SettlementProvision {
        private final Currency settlementCurrency;
        private final NonDeliverableSettlement nonDeliverableSettlement;

        protected SettlementProvisionImpl(SettlementProvisionBuilder builder) {
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.nonDeliverableSettlement = Optional.ofNullable(builder.getNonDeliverableSettlement()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public Currency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="nonDeliverableSettlement")
        @RuneAttribute(value="nonDeliverableSettlement")
        public NonDeliverableSettlement getNonDeliverableSettlement() {
            return this.nonDeliverableSettlement;
        }

        @Override
        public SettlementProvision build() {
            return this;
        }

        @Override
        public SettlementProvisionBuilder toBuilder() {
            SettlementProvisionBuilder builder = SettlementProvision.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SettlementProvisionBuilder builder) {
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getNonDeliverableSettlement()).ifPresent(builder::setNonDeliverableSettlement);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SettlementProvision _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            return Objects.equals(this.nonDeliverableSettlement, _that.getNonDeliverableSettlement());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.nonDeliverableSettlement != null ? this.nonDeliverableSettlement.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SettlementProvision {settlementCurrency=" + this.settlementCurrency + ", nonDeliverableSettlement=" + this.nonDeliverableSettlement + '}';
        }
    }
}

