/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.DeliveryMethod;
import fpml.confirmation.IdentifiedDate;
import fpml.confirmation.PrepaidRate;
import fpml.confirmation.SecLendTransferEvent;
import fpml.confirmation.meta.SecLendInitiationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SecLendInitiation", builder=SecLendInitiationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="SecLendInitiation", model="fpml", builder=SecLendInitiationBuilderImpl.class, version="0.17.2")
public interface SecLendInitiation
extends SecLendTransferEvent {
    public static final SecLendInitiationMeta metaData = new SecLendInitiationMeta();

    public IdentifiedDate getCollateralSettlementDate();

    public PrepaidRate getPrepaidRate();

    @Override
    public SecLendInitiation build();

    @Override
    public SecLendInitiationBuilder toBuilder();

    public static SecLendInitiationBuilder builder() {
        return new SecLendInitiationBuilderImpl();
    }

    default public RosettaMetaData<? extends SecLendInitiation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SecLendInitiation> getType() {
        return SecLendInitiation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementDate"), processor, IdentifiedDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryMethod"), processor, DeliveryMethod.class, this.getDeliveryMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralSettlementDate"), processor, IdentifiedDate.class, this.getCollateralSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("prepaidRate"), processor, PrepaidRate.class, this.getPrepaidRate(), new AttributeMeta[0]);
    }

    public static class SecLendInitiationBuilderImpl
    extends SecLendTransferEvent.SecLendTransferEventBuilderImpl
    implements SecLendInitiationBuilder {
        protected IdentifiedDate.IdentifiedDateBuilder collateralSettlementDate;
        protected PrepaidRate.PrepaidRateBuilder prepaidRate;

        @Override
        @RosettaAttribute(value="collateralSettlementDate")
        @RuneAttribute(value="collateralSettlementDate")
        public IdentifiedDate.IdentifiedDateBuilder getCollateralSettlementDate() {
            return this.collateralSettlementDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateCollateralSettlementDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.collateralSettlementDate != null ? this.collateralSettlementDate : (this.collateralSettlementDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="prepaidRate")
        @RuneAttribute(value="prepaidRate")
        public PrepaidRate.PrepaidRateBuilder getPrepaidRate() {
            return this.prepaidRate;
        }

        @Override
        public PrepaidRate.PrepaidRateBuilder getOrCreatePrepaidRate() {
            PrepaidRate.PrepaidRateBuilder result = this.prepaidRate != null ? this.prepaidRate : (this.prepaidRate = PrepaidRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public SecLendInitiationBuilder setSettlementDate(IdentifiedDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryMethod")
        @RuneAttribute(value="deliveryMethod")
        public SecLendInitiationBuilder setDeliveryMethod(DeliveryMethod _deliveryMethod) {
            this.deliveryMethod = _deliveryMethod == null ? null : _deliveryMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralSettlementDate")
        @RuneAttribute(value="collateralSettlementDate")
        public SecLendInitiationBuilder setCollateralSettlementDate(IdentifiedDate _collateralSettlementDate) {
            this.collateralSettlementDate = _collateralSettlementDate == null ? null : _collateralSettlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="prepaidRate")
        @RuneAttribute(value="prepaidRate")
        public SecLendInitiationBuilder setPrepaidRate(PrepaidRate _prepaidRate) {
            this.prepaidRate = _prepaidRate == null ? null : _prepaidRate.toBuilder();
            return this;
        }

        @Override
        public SecLendInitiation build() {
            return new SecLendInitiationImpl(this);
        }

        @Override
        public SecLendInitiationBuilder toBuilder() {
            return this;
        }

        @Override
        public SecLendInitiationBuilder prune() {
            super.prune();
            if (this.collateralSettlementDate != null && !this.collateralSettlementDate.prune().hasData()) {
                this.collateralSettlementDate = null;
            }
            if (this.prepaidRate != null && !this.prepaidRate.prune().hasData()) {
                this.prepaidRate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCollateralSettlementDate() != null && this.getCollateralSettlementDate().hasData()) {
                return true;
            }
            return this.getPrepaidRate() != null && this.getPrepaidRate().hasData();
        }

        @Override
        public SecLendInitiationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SecLendInitiationBuilder o = (SecLendInitiationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralSettlementDate(), (RosettaModelObjectBuilder)o.getCollateralSettlementDate(), this::setCollateralSettlementDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrepaidRate(), (RosettaModelObjectBuilder)o.getPrepaidRate(), this::setPrepaidRate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SecLendInitiation _that = (SecLendInitiation)this.getType().cast(o);
            if (!Objects.equals(this.collateralSettlementDate, _that.getCollateralSettlementDate())) {
                return false;
            }
            return Objects.equals(this.prepaidRate, _that.getPrepaidRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.collateralSettlementDate != null ? this.collateralSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.prepaidRate != null ? this.prepaidRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SecLendInitiationBuilder {collateralSettlementDate=" + this.collateralSettlementDate + ", prepaidRate=" + this.prepaidRate + '}' + " " + super.toString();
        }
    }

    public static interface SecLendInitiationBuilder
    extends SecLendInitiation,
    SecLendTransferEvent.SecLendTransferEventBuilder {
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateCollateralSettlementDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getCollateralSettlementDate();

        public PrepaidRate.PrepaidRateBuilder getOrCreatePrepaidRate();

        @Override
        public PrepaidRate.PrepaidRateBuilder getPrepaidRate();

        @Override
        public SecLendInitiationBuilder setSettlementDate(IdentifiedDate var1);

        @Override
        public SecLendInitiationBuilder setDeliveryMethod(DeliveryMethod var1);

        public SecLendInitiationBuilder setCollateralSettlementDate(IdentifiedDate var1);

        public SecLendInitiationBuilder setPrepaidRate(PrepaidRate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, (RosettaModelObjectBuilder)this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryMethod"), processor, DeliveryMethod.DeliveryMethodBuilder.class, (RosettaModelObjectBuilder)this.getDeliveryMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralSettlementDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getCollateralSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("prepaidRate"), processor, PrepaidRate.PrepaidRateBuilder.class, this.getPrepaidRate(), new AttributeMeta[0]);
        }

        @Override
        public SecLendInitiationBuilder prune();
    }

    public static class SecLendInitiationImpl
    extends SecLendTransferEvent.SecLendTransferEventImpl
    implements SecLendInitiation {
        private final IdentifiedDate collateralSettlementDate;
        private final PrepaidRate prepaidRate;

        protected SecLendInitiationImpl(SecLendInitiationBuilder builder) {
            super(builder);
            this.collateralSettlementDate = Optional.ofNullable(builder.getCollateralSettlementDate()).map(f -> f.build()).orElse(null);
            this.prepaidRate = Optional.ofNullable(builder.getPrepaidRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="collateralSettlementDate")
        @RuneAttribute(value="collateralSettlementDate")
        public IdentifiedDate getCollateralSettlementDate() {
            return this.collateralSettlementDate;
        }

        @Override
        @RosettaAttribute(value="prepaidRate")
        @RuneAttribute(value="prepaidRate")
        public PrepaidRate getPrepaidRate() {
            return this.prepaidRate;
        }

        @Override
        public SecLendInitiation build() {
            return this;
        }

        @Override
        public SecLendInitiationBuilder toBuilder() {
            SecLendInitiationBuilder builder = SecLendInitiation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecLendInitiationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCollateralSettlementDate()).ifPresent(builder::setCollateralSettlementDate);
            Optional.ofNullable(this.getPrepaidRate()).ifPresent(builder::setPrepaidRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SecLendInitiation _that = (SecLendInitiation)this.getType().cast(o);
            if (!Objects.equals(this.collateralSettlementDate, _that.getCollateralSettlementDate())) {
                return false;
            }
            return Objects.equals(this.prepaidRate, _that.getPrepaidRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.collateralSettlementDate != null ? this.collateralSettlementDate.hashCode() : 0);
            _result = 31 * _result + (this.prepaidRate != null ? this.prepaidRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SecLendInitiation {collateralSettlementDate=" + this.collateralSettlementDate + ", prepaidRate=" + this.prepaidRate + '}' + " " + super.toString();
        }
    }
}

