/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Message;
import fpml.confirmation.RequestMessageHeader;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.RequestMessageMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RequestMessage", builder=RequestMessageBuilderImpl.class, version="0.17.2")
@RuneDataType(value="RequestMessage", model="fpml", builder=RequestMessageBuilderImpl.class, version="0.17.2")
public interface RequestMessage
extends Message {
    public static final RequestMessageMeta metaData = new RequestMessageMeta();

    public RequestMessageHeader getHeader();

    public ValidationModel getValidationModel();

    @Override
    public RequestMessage build();

    @Override
    public RequestMessageBuilder toBuilder();

    public static RequestMessageBuilder builder() {
        return new RequestMessageBuilderImpl();
    }

    default public RosettaMetaData<? extends RequestMessage> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RequestMessage> getType() {
        return RequestMessage.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
    }

    public static class RequestMessageBuilderImpl
    extends Message.MessageBuilderImpl
    implements RequestMessageBuilder {
        protected RequestMessageHeader.RequestMessageHeaderBuilder header;
        protected ValidationModel.ValidationModelBuilder validationModel;

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public RequestMessageHeader.RequestMessageHeaderBuilder getHeader() {
            return this.header;
        }

        @Override
        public RequestMessageHeader.RequestMessageHeaderBuilder getOrCreateHeader() {
            RequestMessageHeader.RequestMessageHeaderBuilder result = this.header != null ? this.header : (this.header = RequestMessageHeader.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ValidationModel.ValidationModelBuilder getValidationModel() {
            return this.validationModel;
        }

        @Override
        public ValidationModel.ValidationModelBuilder getOrCreateValidationModel() {
            ValidationModel.ValidationModelBuilder result = this.validationModel != null ? this.validationModel : (this.validationModel = ValidationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RequestMessageBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RequestMessageBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RequestMessageBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public RequestMessageBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public RequestMessageBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        public RequestMessage build() {
            return new RequestMessageImpl(this);
        }

        @Override
        public RequestMessageBuilder toBuilder() {
            return this;
        }

        @Override
        public RequestMessageBuilder prune() {
            super.prune();
            if (this.header != null && !this.header.prune().hasData()) {
                this.header = null;
            }
            if (this.validationModel != null && !this.validationModel.prune().hasData()) {
                this.validationModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getHeader() != null && this.getHeader().hasData()) {
                return true;
            }
            return this.getValidationModel() != null && this.getValidationModel().hasData();
        }

        @Override
        public RequestMessageBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RequestMessageBuilder o = (RequestMessageBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getHeader(), (RosettaModelObjectBuilder)o.getHeader(), this::setHeader);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValidationModel(), (RosettaModelObjectBuilder)o.getValidationModel(), this::setValidationModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestMessage _that = (RequestMessage)this.getType().cast(o);
            if (!Objects.equals(this.header, _that.getHeader())) {
                return false;
            }
            return Objects.equals(this.validationModel, _that.getValidationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.header != null ? this.header.hashCode() : 0);
            _result = 31 * _result + (this.validationModel != null ? this.validationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestMessageBuilder {header=" + this.header + ", validationModel=" + this.validationModel + '}' + " " + super.toString();
        }
    }

    public static interface RequestMessageBuilder
    extends RequestMessage,
    Message.MessageBuilder {
        public RequestMessageHeader.RequestMessageHeaderBuilder getOrCreateHeader();

        @Override
        public RequestMessageHeader.RequestMessageHeaderBuilder getHeader();

        public ValidationModel.ValidationModelBuilder getOrCreateValidationModel();

        @Override
        public ValidationModel.ValidationModelBuilder getValidationModel();

        @Override
        public RequestMessageBuilder setFpmlVersion(String var1);

        @Override
        public RequestMessageBuilder setExpectedBuild(Integer var1);

        @Override
        public RequestMessageBuilder setActualBuild(Integer var1);

        public RequestMessageBuilder setHeader(RequestMessageHeader var1);

        public RequestMessageBuilder setValidationModel(ValidationModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, this.getValidationModel(), new AttributeMeta[0]);
        }

        @Override
        public RequestMessageBuilder prune();
    }

    public static class RequestMessageImpl
    extends Message.MessageImpl
    implements RequestMessage {
        private final RequestMessageHeader header;
        private final ValidationModel validationModel;

        protected RequestMessageImpl(RequestMessageBuilder builder) {
            super(builder);
            this.header = Optional.ofNullable(builder.getHeader()).map(f -> f.build()).orElse(null);
            this.validationModel = Optional.ofNullable(builder.getValidationModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public RequestMessageHeader getHeader() {
            return this.header;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ValidationModel getValidationModel() {
            return this.validationModel;
        }

        @Override
        public RequestMessage build() {
            return this;
        }

        @Override
        public RequestMessageBuilder toBuilder() {
            RequestMessageBuilder builder = RequestMessage.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RequestMessageBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getHeader()).ifPresent(builder::setHeader);
            Optional.ofNullable(this.getValidationModel()).ifPresent(builder::setValidationModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RequestMessage _that = (RequestMessage)this.getType().cast(o);
            if (!Objects.equals(this.header, _that.getHeader())) {
                return false;
            }
            return Objects.equals(this.validationModel, _that.getValidationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.header != null ? this.header.hashCode() : 0);
            _result = 31 * _result + (this.validationModel != null ? this.validationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RequestMessage {header=" + this.header + ", validationModel=" + this.validationModel + '}' + " " + super.toString();
        }
    }
}

