/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.Bond;
import fpml.confirmation.ConvertibleBond;
import fpml.confirmation.LegalEntity;
import fpml.confirmation.LegalEntityReference;
import fpml.confirmation.Loan;
import fpml.confirmation.Mortgage;
import fpml.confirmation.ReferenceObligationChoice;
import fpml.confirmation.meta.ReferenceObligationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReferenceObligation", builder=ReferenceObligationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ReferenceObligation", model="fpml", builder=ReferenceObligationBuilderImpl.class, version="0.17.2")
public interface ReferenceObligation
extends RosettaModelObject {
    public static final ReferenceObligationMeta metaData = new ReferenceObligationMeta();

    public Bond getBond();

    public ConvertibleBond getConvertibleBond();

    public Mortgage getMortgage();

    public Loan getLoan();

    public LegalEntity getPrimaryObligor();

    public LegalEntityReference getPrimaryObligorReference();

    public List<? extends ReferenceObligationChoice> getReferenceObligationChoice();

    public Boolean getStandardReferenceObligation();

    public ReferenceObligation build();

    public ReferenceObligationBuilder toBuilder();

    public static ReferenceObligationBuilder builder() {
        return new ReferenceObligationBuilderImpl();
    }

    default public RosettaMetaData<? extends ReferenceObligation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReferenceObligation> getType() {
        return ReferenceObligation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("bond"), processor, Bond.class, this.getBond(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("convertibleBond"), processor, ConvertibleBond.class, this.getConvertibleBond(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("mortgage"), processor, Mortgage.class, this.getMortgage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loan"), processor, Loan.class, this.getLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryObligor"), processor, LegalEntity.class, this.getPrimaryObligor(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("primaryObligorReference"), processor, LegalEntityReference.class, this.getPrimaryObligorReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceObligationChoice"), processor, ReferenceObligationChoice.class, this.getReferenceObligationChoice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("standardReferenceObligation"), Boolean.class, (Object)this.getStandardReferenceObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ReferenceObligationBuilderImpl
    implements ReferenceObligationBuilder {
        protected Bond.BondBuilder bond;
        protected ConvertibleBond.ConvertibleBondBuilder convertibleBond;
        protected Mortgage.MortgageBuilder mortgage;
        protected Loan.LoanBuilder loan;
        protected LegalEntity.LegalEntityBuilder primaryObligor;
        protected LegalEntityReference.LegalEntityReferenceBuilder primaryObligorReference;
        protected List<ReferenceObligationChoice.ReferenceObligationChoiceBuilder> referenceObligationChoice = new ArrayList<ReferenceObligationChoice.ReferenceObligationChoiceBuilder>();
        protected Boolean standardReferenceObligation;

        @Override
        @RosettaAttribute(value="bond")
        @RuneAttribute(value="bond")
        public Bond.BondBuilder getBond() {
            return this.bond;
        }

        @Override
        public Bond.BondBuilder getOrCreateBond() {
            Bond.BondBuilder result = this.bond != null ? this.bond : (this.bond = Bond.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="convertibleBond")
        @RuneAttribute(value="convertibleBond")
        public ConvertibleBond.ConvertibleBondBuilder getConvertibleBond() {
            return this.convertibleBond;
        }

        @Override
        public ConvertibleBond.ConvertibleBondBuilder getOrCreateConvertibleBond() {
            ConvertibleBond.ConvertibleBondBuilder result = this.convertibleBond != null ? this.convertibleBond : (this.convertibleBond = ConvertibleBond.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="mortgage")
        @RuneAttribute(value="mortgage")
        public Mortgage.MortgageBuilder getMortgage() {
            return this.mortgage;
        }

        @Override
        public Mortgage.MortgageBuilder getOrCreateMortgage() {
            Mortgage.MortgageBuilder result = this.mortgage != null ? this.mortgage : (this.mortgage = Mortgage.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public Loan.LoanBuilder getLoan() {
            return this.loan;
        }

        @Override
        public Loan.LoanBuilder getOrCreateLoan() {
            Loan.LoanBuilder result = this.loan != null ? this.loan : (this.loan = Loan.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="primaryObligor")
        @RuneAttribute(value="primaryObligor")
        public LegalEntity.LegalEntityBuilder getPrimaryObligor() {
            return this.primaryObligor;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreatePrimaryObligor() {
            LegalEntity.LegalEntityBuilder result = this.primaryObligor != null ? this.primaryObligor : (this.primaryObligor = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="primaryObligorReference")
        @RuneAttribute(value="primaryObligorReference")
        public LegalEntityReference.LegalEntityReferenceBuilder getPrimaryObligorReference() {
            return this.primaryObligorReference;
        }

        @Override
        public LegalEntityReference.LegalEntityReferenceBuilder getOrCreatePrimaryObligorReference() {
            LegalEntityReference.LegalEntityReferenceBuilder result = this.primaryObligorReference != null ? this.primaryObligorReference : (this.primaryObligorReference = LegalEntityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceObligationChoice")
        @RuneAttribute(value="referenceObligationChoice")
        public List<? extends ReferenceObligationChoice.ReferenceObligationChoiceBuilder> getReferenceObligationChoice() {
            return this.referenceObligationChoice;
        }

        @Override
        public ReferenceObligationChoice.ReferenceObligationChoiceBuilder getOrCreateReferenceObligationChoice(int index) {
            if (this.referenceObligationChoice == null) {
                this.referenceObligationChoice = new ArrayList<ReferenceObligationChoice.ReferenceObligationChoiceBuilder>();
            }
            return (ReferenceObligationChoice.ReferenceObligationChoiceBuilder)this.getIndex(this.referenceObligationChoice, index, () -> {
                ReferenceObligationChoice.ReferenceObligationChoiceBuilder newReferenceObligationChoice = ReferenceObligationChoice.builder();
                return newReferenceObligationChoice;
            });
        }

        @Override
        @RosettaAttribute(value="standardReferenceObligation")
        @RuneAttribute(value="standardReferenceObligation")
        public Boolean getStandardReferenceObligation() {
            return this.standardReferenceObligation;
        }

        @Override
        @RosettaAttribute(value="bond")
        @RuneAttribute(value="bond")
        public ReferenceObligationBuilder setBond(Bond _bond) {
            this.bond = _bond == null ? null : _bond.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="convertibleBond")
        @RuneAttribute(value="convertibleBond")
        public ReferenceObligationBuilder setConvertibleBond(ConvertibleBond _convertibleBond) {
            this.convertibleBond = _convertibleBond == null ? null : _convertibleBond.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="mortgage")
        @RuneAttribute(value="mortgage")
        public ReferenceObligationBuilder setMortgage(Mortgage _mortgage) {
            this.mortgage = _mortgage == null ? null : _mortgage.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public ReferenceObligationBuilder setLoan(Loan _loan) {
            this.loan = _loan == null ? null : _loan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryObligor")
        @RuneAttribute(value="primaryObligor")
        public ReferenceObligationBuilder setPrimaryObligor(LegalEntity _primaryObligor) {
            this.primaryObligor = _primaryObligor == null ? null : _primaryObligor.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryObligorReference")
        @RuneAttribute(value="primaryObligorReference")
        public ReferenceObligationBuilder setPrimaryObligorReference(LegalEntityReference _primaryObligorReference) {
            this.primaryObligorReference = _primaryObligorReference == null ? null : _primaryObligorReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceObligationChoice")
        @RuneAttribute(value="referenceObligationChoice")
        public ReferenceObligationBuilder addReferenceObligationChoice(ReferenceObligationChoice _referenceObligationChoice) {
            if (_referenceObligationChoice != null) {
                this.referenceObligationChoice.add(_referenceObligationChoice.toBuilder());
            }
            return this;
        }

        @Override
        public ReferenceObligationBuilder addReferenceObligationChoice(ReferenceObligationChoice _referenceObligationChoice, int idx) {
            this.getIndex(this.referenceObligationChoice, idx, () -> _referenceObligationChoice.toBuilder());
            return this;
        }

        @Override
        public ReferenceObligationBuilder addReferenceObligationChoice(List<? extends ReferenceObligationChoice> referenceObligationChoices) {
            if (referenceObligationChoices != null) {
                for (ReferenceObligationChoice referenceObligationChoice : referenceObligationChoices) {
                    this.referenceObligationChoice.add(referenceObligationChoice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="referenceObligationChoice")
        public ReferenceObligationBuilder setReferenceObligationChoice(List<? extends ReferenceObligationChoice> referenceObligationChoices) {
            this.referenceObligationChoice = referenceObligationChoices == null ? new ArrayList<ReferenceObligationChoice.ReferenceObligationChoiceBuilder>() : (List)referenceObligationChoices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="standardReferenceObligation")
        @RuneAttribute(value="standardReferenceObligation")
        public ReferenceObligationBuilder setStandardReferenceObligation(Boolean _standardReferenceObligation) {
            this.standardReferenceObligation = _standardReferenceObligation == null ? null : _standardReferenceObligation;
            return this;
        }

        @Override
        public ReferenceObligation build() {
            return new ReferenceObligationImpl(this);
        }

        @Override
        public ReferenceObligationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReferenceObligationBuilder prune() {
            if (this.bond != null && !this.bond.prune().hasData()) {
                this.bond = null;
            }
            if (this.convertibleBond != null && !this.convertibleBond.prune().hasData()) {
                this.convertibleBond = null;
            }
            if (this.mortgage != null && !this.mortgage.prune().hasData()) {
                this.mortgage = null;
            }
            if (this.loan != null && !this.loan.prune().hasData()) {
                this.loan = null;
            }
            if (this.primaryObligor != null && !this.primaryObligor.prune().hasData()) {
                this.primaryObligor = null;
            }
            if (this.primaryObligorReference != null && !this.primaryObligorReference.prune().hasData()) {
                this.primaryObligorReference = null;
            }
            this.referenceObligationChoice = this.referenceObligationChoice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getBond() != null && this.getBond().hasData()) {
                return true;
            }
            if (this.getConvertibleBond() != null && this.getConvertibleBond().hasData()) {
                return true;
            }
            if (this.getMortgage() != null && this.getMortgage().hasData()) {
                return true;
            }
            if (this.getLoan() != null && this.getLoan().hasData()) {
                return true;
            }
            if (this.getPrimaryObligor() != null && this.getPrimaryObligor().hasData()) {
                return true;
            }
            if (this.getPrimaryObligorReference() != null && this.getPrimaryObligorReference().hasData()) {
                return true;
            }
            if (this.getReferenceObligationChoice() != null && this.getReferenceObligationChoice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getStandardReferenceObligation() != null;
        }

        public ReferenceObligationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceObligationBuilder o = (ReferenceObligationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBond(), (RosettaModelObjectBuilder)o.getBond(), this::setBond);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConvertibleBond(), (RosettaModelObjectBuilder)o.getConvertibleBond(), this::setConvertibleBond);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMortgage(), (RosettaModelObjectBuilder)o.getMortgage(), this::setMortgage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoan(), (RosettaModelObjectBuilder)o.getLoan(), this::setLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryObligor(), (RosettaModelObjectBuilder)o.getPrimaryObligor(), this::setPrimaryObligor);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryObligorReference(), (RosettaModelObjectBuilder)o.getPrimaryObligorReference(), this::setPrimaryObligorReference);
            merger.mergeRosetta(this.getReferenceObligationChoice(), o.getReferenceObligationChoice(), this::getOrCreateReferenceObligationChoice);
            merger.mergeBasic((Object)this.getStandardReferenceObligation(), (Object)o.getStandardReferenceObligation(), this::setStandardReferenceObligation, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.convertibleBond, _that.getConvertibleBond())) {
                return false;
            }
            if (!Objects.equals(this.mortgage, _that.getMortgage())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligor, _that.getPrimaryObligor())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligorReference, _that.getPrimaryObligorReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.referenceObligationChoice, _that.getReferenceObligationChoice())) {
                return false;
            }
            return Objects.equals(this.standardReferenceObligation, _that.getStandardReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.convertibleBond != null ? this.convertibleBond.hashCode() : 0);
            _result = 31 * _result + (this.mortgage != null ? this.mortgage.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligor != null ? this.primaryObligor.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligorReference != null ? this.primaryObligorReference.hashCode() : 0);
            _result = 31 * _result + (this.referenceObligationChoice != null ? this.referenceObligationChoice.hashCode() : 0);
            _result = 31 * _result + (this.standardReferenceObligation != null ? this.standardReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceObligationBuilder {bond=" + this.bond + ", convertibleBond=" + this.convertibleBond + ", mortgage=" + this.mortgage + ", loan=" + this.loan + ", primaryObligor=" + this.primaryObligor + ", primaryObligorReference=" + this.primaryObligorReference + ", referenceObligationChoice=" + this.referenceObligationChoice + ", standardReferenceObligation=" + this.standardReferenceObligation + '}';
        }
    }

    public static interface ReferenceObligationBuilder
    extends ReferenceObligation,
    RosettaModelObjectBuilder {
        public Bond.BondBuilder getOrCreateBond();

        @Override
        public Bond.BondBuilder getBond();

        public ConvertibleBond.ConvertibleBondBuilder getOrCreateConvertibleBond();

        @Override
        public ConvertibleBond.ConvertibleBondBuilder getConvertibleBond();

        public Mortgage.MortgageBuilder getOrCreateMortgage();

        @Override
        public Mortgage.MortgageBuilder getMortgage();

        public Loan.LoanBuilder getOrCreateLoan();

        @Override
        public Loan.LoanBuilder getLoan();

        public LegalEntity.LegalEntityBuilder getOrCreatePrimaryObligor();

        @Override
        public LegalEntity.LegalEntityBuilder getPrimaryObligor();

        public LegalEntityReference.LegalEntityReferenceBuilder getOrCreatePrimaryObligorReference();

        @Override
        public LegalEntityReference.LegalEntityReferenceBuilder getPrimaryObligorReference();

        public ReferenceObligationChoice.ReferenceObligationChoiceBuilder getOrCreateReferenceObligationChoice(int var1);

        public List<? extends ReferenceObligationChoice.ReferenceObligationChoiceBuilder> getReferenceObligationChoice();

        public ReferenceObligationBuilder setBond(Bond var1);

        public ReferenceObligationBuilder setConvertibleBond(ConvertibleBond var1);

        public ReferenceObligationBuilder setMortgage(Mortgage var1);

        public ReferenceObligationBuilder setLoan(Loan var1);

        public ReferenceObligationBuilder setPrimaryObligor(LegalEntity var1);

        public ReferenceObligationBuilder setPrimaryObligorReference(LegalEntityReference var1);

        public ReferenceObligationBuilder addReferenceObligationChoice(ReferenceObligationChoice var1);

        public ReferenceObligationBuilder addReferenceObligationChoice(ReferenceObligationChoice var1, int var2);

        public ReferenceObligationBuilder addReferenceObligationChoice(List<? extends ReferenceObligationChoice> var1);

        public ReferenceObligationBuilder setReferenceObligationChoice(List<? extends ReferenceObligationChoice> var1);

        public ReferenceObligationBuilder setStandardReferenceObligation(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("bond"), processor, Bond.BondBuilder.class, this.getBond(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("convertibleBond"), processor, ConvertibleBond.ConvertibleBondBuilder.class, this.getConvertibleBond(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("mortgage"), processor, Mortgage.MortgageBuilder.class, this.getMortgage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loan"), processor, Loan.LoanBuilder.class, this.getLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryObligor"), processor, LegalEntity.LegalEntityBuilder.class, this.getPrimaryObligor(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("primaryObligorReference"), processor, LegalEntityReference.LegalEntityReferenceBuilder.class, this.getPrimaryObligorReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceObligationChoice"), processor, ReferenceObligationChoice.ReferenceObligationChoiceBuilder.class, this.getReferenceObligationChoice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("standardReferenceObligation"), Boolean.class, (Object)this.getStandardReferenceObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ReferenceObligationBuilder prune();
    }

    public static class ReferenceObligationImpl
    implements ReferenceObligation {
        private final Bond bond;
        private final ConvertibleBond convertibleBond;
        private final Mortgage mortgage;
        private final Loan loan;
        private final LegalEntity primaryObligor;
        private final LegalEntityReference primaryObligorReference;
        private final List<? extends ReferenceObligationChoice> referenceObligationChoice;
        private final Boolean standardReferenceObligation;

        protected ReferenceObligationImpl(ReferenceObligationBuilder builder) {
            this.bond = Optional.ofNullable(builder.getBond()).map(f -> f.build()).orElse(null);
            this.convertibleBond = Optional.ofNullable(builder.getConvertibleBond()).map(f -> f.build()).orElse(null);
            this.mortgage = Optional.ofNullable(builder.getMortgage()).map(f -> f.build()).orElse(null);
            this.loan = Optional.ofNullable(builder.getLoan()).map(f -> f.build()).orElse(null);
            this.primaryObligor = Optional.ofNullable(builder.getPrimaryObligor()).map(f -> f.build()).orElse(null);
            this.primaryObligorReference = Optional.ofNullable(builder.getPrimaryObligorReference()).map(f -> f.build()).orElse(null);
            this.referenceObligationChoice = Optional.ofNullable(builder.getReferenceObligationChoice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.standardReferenceObligation = builder.getStandardReferenceObligation();
        }

        @Override
        @RosettaAttribute(value="bond")
        @RuneAttribute(value="bond")
        public Bond getBond() {
            return this.bond;
        }

        @Override
        @RosettaAttribute(value="convertibleBond")
        @RuneAttribute(value="convertibleBond")
        public ConvertibleBond getConvertibleBond() {
            return this.convertibleBond;
        }

        @Override
        @RosettaAttribute(value="mortgage")
        @RuneAttribute(value="mortgage")
        public Mortgage getMortgage() {
            return this.mortgage;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public Loan getLoan() {
            return this.loan;
        }

        @Override
        @RosettaAttribute(value="primaryObligor")
        @RuneAttribute(value="primaryObligor")
        public LegalEntity getPrimaryObligor() {
            return this.primaryObligor;
        }

        @Override
        @RosettaAttribute(value="primaryObligorReference")
        @RuneAttribute(value="primaryObligorReference")
        public LegalEntityReference getPrimaryObligorReference() {
            return this.primaryObligorReference;
        }

        @Override
        @RosettaAttribute(value="referenceObligationChoice")
        @RuneAttribute(value="referenceObligationChoice")
        public List<? extends ReferenceObligationChoice> getReferenceObligationChoice() {
            return this.referenceObligationChoice;
        }

        @Override
        @RosettaAttribute(value="standardReferenceObligation")
        @RuneAttribute(value="standardReferenceObligation")
        public Boolean getStandardReferenceObligation() {
            return this.standardReferenceObligation;
        }

        @Override
        public ReferenceObligation build() {
            return this;
        }

        @Override
        public ReferenceObligationBuilder toBuilder() {
            ReferenceObligationBuilder builder = ReferenceObligation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReferenceObligationBuilder builder) {
            Optional.ofNullable(this.getBond()).ifPresent(builder::setBond);
            Optional.ofNullable(this.getConvertibleBond()).ifPresent(builder::setConvertibleBond);
            Optional.ofNullable(this.getMortgage()).ifPresent(builder::setMortgage);
            Optional.ofNullable(this.getLoan()).ifPresent(builder::setLoan);
            Optional.ofNullable(this.getPrimaryObligor()).ifPresent(builder::setPrimaryObligor);
            Optional.ofNullable(this.getPrimaryObligorReference()).ifPresent(builder::setPrimaryObligorReference);
            Optional.ofNullable(this.getReferenceObligationChoice()).ifPresent(builder::setReferenceObligationChoice);
            Optional.ofNullable(this.getStandardReferenceObligation()).ifPresent(builder::setStandardReferenceObligation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.convertibleBond, _that.getConvertibleBond())) {
                return false;
            }
            if (!Objects.equals(this.mortgage, _that.getMortgage())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligor, _that.getPrimaryObligor())) {
                return false;
            }
            if (!Objects.equals(this.primaryObligorReference, _that.getPrimaryObligorReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.referenceObligationChoice, _that.getReferenceObligationChoice())) {
                return false;
            }
            return Objects.equals(this.standardReferenceObligation, _that.getStandardReferenceObligation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.convertibleBond != null ? this.convertibleBond.hashCode() : 0);
            _result = 31 * _result + (this.mortgage != null ? this.mortgage.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligor != null ? this.primaryObligor.hashCode() : 0);
            _result = 31 * _result + (this.primaryObligorReference != null ? this.primaryObligorReference.hashCode() : 0);
            _result = 31 * _result + (this.referenceObligationChoice != null ? this.referenceObligationChoice.hashCode() : 0);
            _result = 31 * _result + (this.standardReferenceObligation != null ? this.standardReferenceObligation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceObligation {bond=" + this.bond + ", convertibleBond=" + this.convertibleBond + ", mortgage=" + this.mortgage + ", loan=" + this.loan + ", primaryObligor=" + this.primaryObligor + ", primaryObligorReference=" + this.primaryObligorReference + ", referenceObligationChoice=" + this.referenceObligationChoice + ", standardReferenceObligation=" + this.standardReferenceObligation + '}';
        }
    }
}

