/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.Money;
import fpml.confirmation.PaymentBase;
import fpml.confirmation.PaymentDetailSequence;
import fpml.confirmation.meta.PaymentDetailMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PaymentDetail", builder=PaymentDetailBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PaymentDetail", model="fpml", builder=PaymentDetailBuilderImpl.class, version="0.17.2")
public interface PaymentDetail
extends PaymentBase {
    public static final PaymentDetailMeta metaData = new PaymentDetailMeta();

    public AdjustableOrRelativeDate getPaymentDate();

    public Money getPaymentAmount();

    public PaymentDetailSequence getPaymentDetailSequence();

    @Override
    public PaymentDetail build();

    @Override
    public PaymentDetailBuilder toBuilder();

    public static PaymentDetailBuilder builder() {
        return new PaymentDetailBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentDetail> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentDetail> getType() {
        return PaymentDetail.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDetailSequence"), processor, PaymentDetailSequence.class, this.getPaymentDetailSequence(), new AttributeMeta[0]);
    }

    public static class PaymentDetailBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements PaymentDetailBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder paymentDate;
        protected Money.MoneyBuilder paymentAmount;
        protected PaymentDetailSequence.PaymentDetailSequenceBuilder paymentDetailSequence;

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public Money.MoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePaymentAmount() {
            Money.MoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentDetailSequence")
        @RuneAttribute(value="paymentDetailSequence")
        public PaymentDetailSequence.PaymentDetailSequenceBuilder getPaymentDetailSequence() {
            return this.paymentDetailSequence;
        }

        @Override
        public PaymentDetailSequence.PaymentDetailSequenceBuilder getOrCreatePaymentDetailSequence() {
            PaymentDetailSequence.PaymentDetailSequenceBuilder result = this.paymentDetailSequence != null ? this.paymentDetailSequence : (this.paymentDetailSequence = PaymentDetailSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public PaymentDetailBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public PaymentDetailBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public PaymentDetailBuilder setPaymentAmount(Money _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDetailSequence")
        @RuneAttribute(value="paymentDetailSequence")
        public PaymentDetailBuilder setPaymentDetailSequence(PaymentDetailSequence _paymentDetailSequence) {
            this.paymentDetailSequence = _paymentDetailSequence == null ? null : _paymentDetailSequence.toBuilder();
            return this;
        }

        @Override
        public PaymentDetail build() {
            return new PaymentDetailImpl(this);
        }

        @Override
        public PaymentDetailBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentDetailBuilder prune() {
            super.prune();
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            if (this.paymentDetailSequence != null && !this.paymentDetailSequence.prune().hasData()) {
                this.paymentDetailSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            if (this.getPaymentAmount() != null && this.getPaymentAmount().hasData()) {
                return true;
            }
            return this.getPaymentDetailSequence() != null && this.getPaymentDetailSequence().hasData();
        }

        @Override
        public PaymentDetailBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PaymentDetailBuilder o = (PaymentDetailBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDetailSequence(), (RosettaModelObjectBuilder)o.getPaymentDetailSequence(), this::setPaymentDetailSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PaymentDetail _that = (PaymentDetail)this.getType().cast(o);
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.paymentDetailSequence, _that.getPaymentDetailSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetailSequence != null ? this.paymentDetailSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PaymentDetailBuilder {paymentDate=" + this.paymentDate + ", paymentAmount=" + this.paymentAmount + ", paymentDetailSequence=" + this.paymentDetailSequence + '}' + " " + super.toString();
        }
    }

    public static interface PaymentDetailBuilder
    extends PaymentDetail,
    PaymentBase.PaymentBaseBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getPaymentDate();

        public Money.MoneyBuilder getOrCreatePaymentAmount();

        @Override
        public Money.MoneyBuilder getPaymentAmount();

        public PaymentDetailSequence.PaymentDetailSequenceBuilder getOrCreatePaymentDetailSequence();

        @Override
        public PaymentDetailSequence.PaymentDetailSequenceBuilder getPaymentDetailSequence();

        @Override
        public PaymentDetailBuilder setId(String var1);

        public PaymentDetailBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        public PaymentDetailBuilder setPaymentAmount(Money var1);

        public PaymentDetailBuilder setPaymentDetailSequence(PaymentDetailSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.MoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDetailSequence"), processor, PaymentDetailSequence.PaymentDetailSequenceBuilder.class, this.getPaymentDetailSequence(), new AttributeMeta[0]);
        }

        @Override
        public PaymentDetailBuilder prune();
    }

    public static class PaymentDetailImpl
    extends PaymentBase.PaymentBaseImpl
    implements PaymentDetail {
        private final AdjustableOrRelativeDate paymentDate;
        private final Money paymentAmount;
        private final PaymentDetailSequence paymentDetailSequence;

        protected PaymentDetailImpl(PaymentDetailBuilder builder) {
            super(builder);
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
            this.paymentDetailSequence = Optional.ofNullable(builder.getPaymentDetailSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public AdjustableOrRelativeDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentAmount")
        @RuneAttribute(value="paymentAmount")
        public Money getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        @RosettaAttribute(value="paymentDetailSequence")
        @RuneAttribute(value="paymentDetailSequence")
        public PaymentDetailSequence getPaymentDetailSequence() {
            return this.paymentDetailSequence;
        }

        @Override
        public PaymentDetail build() {
            return this;
        }

        @Override
        public PaymentDetailBuilder toBuilder() {
            PaymentDetailBuilder builder = PaymentDetail.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentDetailBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
            Optional.ofNullable(this.getPaymentDetailSequence()).ifPresent(builder::setPaymentDetailSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PaymentDetail _that = (PaymentDetail)this.getType().cast(o);
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentAmount, _that.getPaymentAmount())) {
                return false;
            }
            return Objects.equals(this.paymentDetailSequence, _that.getPaymentDetailSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetailSequence != null ? this.paymentDetailSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "PaymentDetail {paymentDate=" + this.paymentDate + ", paymentAmount=" + this.paymentAmount + ", paymentDetailSequence=" + this.paymentDetailSequence + '}' + " " + super.toString();
        }
    }
}

