/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.LegalEntity;
import fpml.confirmation.LegalEntityReference;
import fpml.confirmation.meta.LoanChoiceMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanChoice", builder=LoanChoiceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanChoice", model="fpml", builder=LoanChoiceBuilderImpl.class, version="0.17.2")
public interface LoanChoice
extends RosettaModelObject {
    public static final LoanChoiceMeta metaData = new LoanChoiceMeta();

    public LegalEntity getBorrower();

    public LegalEntityReference getBorrowerReference();

    public LoanChoice build();

    public LoanChoiceBuilder toBuilder();

    public static LoanChoiceBuilder builder() {
        return new LoanChoiceBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanChoice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanChoice> getType() {
        return LoanChoice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("borrower"), processor, LegalEntity.class, this.getBorrower(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("borrowerReference"), processor, LegalEntityReference.class, this.getBorrowerReference(), new AttributeMeta[0]);
    }

    public static class LoanChoiceBuilderImpl
    implements LoanChoiceBuilder {
        protected LegalEntity.LegalEntityBuilder borrower;
        protected LegalEntityReference.LegalEntityReferenceBuilder borrowerReference;

        @Override
        @RosettaAttribute(value="borrower")
        @RuneAttribute(value="borrower")
        public LegalEntity.LegalEntityBuilder getBorrower() {
            return this.borrower;
        }

        @Override
        public LegalEntity.LegalEntityBuilder getOrCreateBorrower() {
            LegalEntity.LegalEntityBuilder result = this.borrower != null ? this.borrower : (this.borrower = LegalEntity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="borrowerReference")
        @RuneAttribute(value="borrowerReference")
        public LegalEntityReference.LegalEntityReferenceBuilder getBorrowerReference() {
            return this.borrowerReference;
        }

        @Override
        public LegalEntityReference.LegalEntityReferenceBuilder getOrCreateBorrowerReference() {
            LegalEntityReference.LegalEntityReferenceBuilder result = this.borrowerReference != null ? this.borrowerReference : (this.borrowerReference = LegalEntityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="borrower")
        @RuneAttribute(value="borrower")
        public LoanChoiceBuilder setBorrower(LegalEntity _borrower) {
            this.borrower = _borrower == null ? null : _borrower.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="borrowerReference")
        @RuneAttribute(value="borrowerReference")
        public LoanChoiceBuilder setBorrowerReference(LegalEntityReference _borrowerReference) {
            this.borrowerReference = _borrowerReference == null ? null : _borrowerReference.toBuilder();
            return this;
        }

        @Override
        public LoanChoice build() {
            return new LoanChoiceImpl(this);
        }

        @Override
        public LoanChoiceBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanChoiceBuilder prune() {
            if (this.borrower != null && !this.borrower.prune().hasData()) {
                this.borrower = null;
            }
            if (this.borrowerReference != null && !this.borrowerReference.prune().hasData()) {
                this.borrowerReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBorrower() != null && this.getBorrower().hasData()) {
                return true;
            }
            return this.getBorrowerReference() != null && this.getBorrowerReference().hasData();
        }

        public LoanChoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanChoiceBuilder o = (LoanChoiceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBorrower(), (RosettaModelObjectBuilder)o.getBorrower(), this::setBorrower);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBorrowerReference(), (RosettaModelObjectBuilder)o.getBorrowerReference(), this::setBorrowerReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.borrower, _that.getBorrower())) {
                return false;
            }
            return Objects.equals(this.borrowerReference, _that.getBorrowerReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.borrower != null ? this.borrower.hashCode() : 0);
            _result = 31 * _result + (this.borrowerReference != null ? this.borrowerReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanChoiceBuilder {borrower=" + this.borrower + ", borrowerReference=" + this.borrowerReference + '}';
        }
    }

    public static interface LoanChoiceBuilder
    extends LoanChoice,
    RosettaModelObjectBuilder {
        public LegalEntity.LegalEntityBuilder getOrCreateBorrower();

        @Override
        public LegalEntity.LegalEntityBuilder getBorrower();

        public LegalEntityReference.LegalEntityReferenceBuilder getOrCreateBorrowerReference();

        @Override
        public LegalEntityReference.LegalEntityReferenceBuilder getBorrowerReference();

        public LoanChoiceBuilder setBorrower(LegalEntity var1);

        public LoanChoiceBuilder setBorrowerReference(LegalEntityReference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("borrower"), processor, LegalEntity.LegalEntityBuilder.class, this.getBorrower(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("borrowerReference"), processor, LegalEntityReference.LegalEntityReferenceBuilder.class, this.getBorrowerReference(), new AttributeMeta[0]);
        }

        public LoanChoiceBuilder prune();
    }

    public static class LoanChoiceImpl
    implements LoanChoice {
        private final LegalEntity borrower;
        private final LegalEntityReference borrowerReference;

        protected LoanChoiceImpl(LoanChoiceBuilder builder) {
            this.borrower = Optional.ofNullable(builder.getBorrower()).map(f -> f.build()).orElse(null);
            this.borrowerReference = Optional.ofNullable(builder.getBorrowerReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="borrower")
        @RuneAttribute(value="borrower")
        public LegalEntity getBorrower() {
            return this.borrower;
        }

        @Override
        @RosettaAttribute(value="borrowerReference")
        @RuneAttribute(value="borrowerReference")
        public LegalEntityReference getBorrowerReference() {
            return this.borrowerReference;
        }

        @Override
        public LoanChoice build() {
            return this;
        }

        @Override
        public LoanChoiceBuilder toBuilder() {
            LoanChoiceBuilder builder = LoanChoice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanChoiceBuilder builder) {
            Optional.ofNullable(this.getBorrower()).ifPresent(builder::setBorrower);
            Optional.ofNullable(this.getBorrowerReference()).ifPresent(builder::setBorrowerReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.borrower, _that.getBorrower())) {
                return false;
            }
            return Objects.equals(this.borrowerReference, _that.getBorrowerReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.borrower != null ? this.borrower.hashCode() : 0);
            _result = 31 * _result + (this.borrowerReference != null ? this.borrowerReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanChoice {borrower=" + this.borrower + ", borrowerReference=" + this.borrowerReference + '}';
        }
    }
}

