/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.FxSettlementAdjustmentMethodEnum;
import fpml.confirmation.FxTargetStyleEnum;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.meta.FxKnockoutLevelMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxKnockoutLevel", builder=FxKnockoutLevelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxKnockoutLevel", model="fpml", builder=FxKnockoutLevelBuilderImpl.class, version="0.17.2")
public interface FxKnockoutLevel
extends RosettaModelObject {
    public static final FxKnockoutLevelMeta metaData = new FxKnockoutLevelMeta();

    public NonNegativeMoney getAmount();

    public BigDecimal getIntrinsicValue();

    public FxTargetStyleEnum getTargetStyle();

    public FxSettlementAdjustmentMethodEnum getSettlementAdjustmentStyle();

    public FxKnockoutLevel build();

    public FxKnockoutLevelBuilder toBuilder();

    public static FxKnockoutLevelBuilder builder() {
        return new FxKnockoutLevelBuilderImpl();
    }

    default public RosettaMetaData<? extends FxKnockoutLevel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxKnockoutLevel> getType() {
        return FxKnockoutLevel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intrinsicValue"), BigDecimal.class, (Object)this.getIntrinsicValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("targetStyle"), FxTargetStyleEnum.class, (Object)this.getTargetStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementAdjustmentStyle"), FxSettlementAdjustmentMethodEnum.class, (Object)this.getSettlementAdjustmentStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxKnockoutLevelBuilderImpl
    implements FxKnockoutLevelBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected BigDecimal intrinsicValue;
        protected FxTargetStyleEnum targetStyle;
        protected FxSettlementAdjustmentMethodEnum settlementAdjustmentStyle;

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intrinsicValue")
        @RuneAttribute(value="intrinsicValue")
        public BigDecimal getIntrinsicValue() {
            return this.intrinsicValue;
        }

        @Override
        @RosettaAttribute(value="targetStyle", isRequired=true)
        @RuneAttribute(value="targetStyle", isRequired=true)
        public FxTargetStyleEnum getTargetStyle() {
            return this.targetStyle;
        }

        @Override
        @RosettaAttribute(value="settlementAdjustmentStyle")
        @RuneAttribute(value="settlementAdjustmentStyle")
        public FxSettlementAdjustmentMethodEnum getSettlementAdjustmentStyle() {
            return this.settlementAdjustmentStyle;
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public FxKnockoutLevelBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="intrinsicValue")
        @RuneAttribute(value="intrinsicValue")
        public FxKnockoutLevelBuilder setIntrinsicValue(BigDecimal _intrinsicValue) {
            this.intrinsicValue = _intrinsicValue == null ? null : _intrinsicValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="targetStyle", isRequired=true)
        @RuneAttribute(value="targetStyle", isRequired=true)
        public FxKnockoutLevelBuilder setTargetStyle(FxTargetStyleEnum _targetStyle) {
            this.targetStyle = _targetStyle == null ? null : _targetStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementAdjustmentStyle")
        @RuneAttribute(value="settlementAdjustmentStyle")
        public FxKnockoutLevelBuilder setSettlementAdjustmentStyle(FxSettlementAdjustmentMethodEnum _settlementAdjustmentStyle) {
            this.settlementAdjustmentStyle = _settlementAdjustmentStyle == null ? null : _settlementAdjustmentStyle;
            return this;
        }

        @Override
        public FxKnockoutLevel build() {
            return new FxKnockoutLevelImpl(this);
        }

        @Override
        public FxKnockoutLevelBuilder toBuilder() {
            return this;
        }

        @Override
        public FxKnockoutLevelBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getIntrinsicValue() != null) {
                return true;
            }
            if (this.getTargetStyle() != null) {
                return true;
            }
            return this.getSettlementAdjustmentStyle() != null;
        }

        public FxKnockoutLevelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxKnockoutLevelBuilder o = (FxKnockoutLevelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getIntrinsicValue(), (Object)o.getIntrinsicValue(), this::setIntrinsicValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTargetStyle(), (Object)o.getTargetStyle(), this::setTargetStyle, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementAdjustmentStyle(), (Object)o.getSettlementAdjustmentStyle(), this::setSettlementAdjustmentStyle, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxKnockoutLevel _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.intrinsicValue, _that.getIntrinsicValue())) {
                return false;
            }
            if (!Objects.equals((Object)this.targetStyle, (Object)_that.getTargetStyle())) {
                return false;
            }
            return Objects.equals((Object)this.settlementAdjustmentStyle, (Object)_that.getSettlementAdjustmentStyle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.intrinsicValue != null ? this.intrinsicValue.hashCode() : 0);
            _result = 31 * _result + (this.targetStyle != null ? ((Object)((Object)this.targetStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementAdjustmentStyle != null ? ((Object)((Object)this.settlementAdjustmentStyle)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxKnockoutLevelBuilder {amount=" + this.amount + ", intrinsicValue=" + this.intrinsicValue + ", targetStyle=" + (Object)((Object)this.targetStyle) + ", settlementAdjustmentStyle=" + (Object)((Object)this.settlementAdjustmentStyle) + '}';
        }
    }

    public static interface FxKnockoutLevelBuilder
    extends FxKnockoutLevel,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        public FxKnockoutLevelBuilder setAmount(NonNegativeMoney var1);

        public FxKnockoutLevelBuilder setIntrinsicValue(BigDecimal var1);

        public FxKnockoutLevelBuilder setTargetStyle(FxTargetStyleEnum var1);

        public FxKnockoutLevelBuilder setSettlementAdjustmentStyle(FxSettlementAdjustmentMethodEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intrinsicValue"), BigDecimal.class, (Object)this.getIntrinsicValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("targetStyle"), FxTargetStyleEnum.class, (Object)this.getTargetStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementAdjustmentStyle"), FxSettlementAdjustmentMethodEnum.class, (Object)this.getSettlementAdjustmentStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FxKnockoutLevelBuilder prune();
    }

    public static class FxKnockoutLevelImpl
    implements FxKnockoutLevel {
        private final NonNegativeMoney amount;
        private final BigDecimal intrinsicValue;
        private final FxTargetStyleEnum targetStyle;
        private final FxSettlementAdjustmentMethodEnum settlementAdjustmentStyle;

        protected FxKnockoutLevelImpl(FxKnockoutLevelBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.intrinsicValue = builder.getIntrinsicValue();
            this.targetStyle = builder.getTargetStyle();
            this.settlementAdjustmentStyle = builder.getSettlementAdjustmentStyle();
        }

        @Override
        @RosettaAttribute(value="amount")
        @RuneAttribute(value="amount")
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="intrinsicValue")
        @RuneAttribute(value="intrinsicValue")
        public BigDecimal getIntrinsicValue() {
            return this.intrinsicValue;
        }

        @Override
        @RosettaAttribute(value="targetStyle", isRequired=true)
        @RuneAttribute(value="targetStyle", isRequired=true)
        public FxTargetStyleEnum getTargetStyle() {
            return this.targetStyle;
        }

        @Override
        @RosettaAttribute(value="settlementAdjustmentStyle")
        @RuneAttribute(value="settlementAdjustmentStyle")
        public FxSettlementAdjustmentMethodEnum getSettlementAdjustmentStyle() {
            return this.settlementAdjustmentStyle;
        }

        @Override
        public FxKnockoutLevel build() {
            return this;
        }

        @Override
        public FxKnockoutLevelBuilder toBuilder() {
            FxKnockoutLevelBuilder builder = FxKnockoutLevel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxKnockoutLevelBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getIntrinsicValue()).ifPresent(builder::setIntrinsicValue);
            Optional.ofNullable(this.getTargetStyle()).ifPresent(builder::setTargetStyle);
            Optional.ofNullable(this.getSettlementAdjustmentStyle()).ifPresent(builder::setSettlementAdjustmentStyle);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxKnockoutLevel _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.intrinsicValue, _that.getIntrinsicValue())) {
                return false;
            }
            if (!Objects.equals((Object)this.targetStyle, (Object)_that.getTargetStyle())) {
                return false;
            }
            return Objects.equals((Object)this.settlementAdjustmentStyle, (Object)_that.getSettlementAdjustmentStyle());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.intrinsicValue != null ? this.intrinsicValue.hashCode() : 0);
            _result = 31 * _result + (this.targetStyle != null ? ((Object)((Object)this.targetStyle)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementAdjustmentStyle != null ? ((Object)((Object)this.settlementAdjustmentStyle)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxKnockoutLevel {amount=" + this.amount + ", intrinsicValue=" + this.intrinsicValue + ", targetStyle=" + (Object)((Object)this.targetStyle) + ", settlementAdjustmentStyle=" + (Object)((Object)this.settlementAdjustmentStyle) + '}';
        }
    }
}

