/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.ClearanceSystem;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.ExchangeIdentifierModel;
import fpml.confirmation.ExchangeTraded;
import fpml.confirmation.ExchangeTradedContractUnderlyer;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.InstrumentType;
import fpml.confirmation.ProductReference;
import fpml.confirmation.SettlementTypeEnum;
import fpml.confirmation.meta.FutureMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Future", builder=FutureBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Future", model="fpml", builder=FutureBuilderImpl.class, version="0.17.2")
public interface Future
extends ExchangeTraded {
    public static final FutureMeta metaData = new FutureMeta();

    public BigDecimal getMultiplier();

    public String getFutureContractReference();

    public ZonedDateTime getMaturity();

    public String getContractYearMonth();

    public ExchangeTradedContractUnderlyer getUnderlyer();

    public SettlementTypeEnum getSettlementType();

    @Override
    public Future build();

    @Override
    public FutureBuilder toBuilder();

    public static FutureBuilder builder() {
        return new FutureBuilderImpl();
    }

    default public RosettaMetaData<? extends Future> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Future> getType() {
        return Future.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("futureContractReference"), String.class, (Object)this.getFutureContractReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractYearMonth"), String.class, (Object)this.getContractYearMonth(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FutureBuilderImpl
    extends ExchangeTraded.ExchangeTradedBuilderImpl
    implements FutureBuilder {
        protected BigDecimal multiplier;
        protected String futureContractReference;
        protected ZonedDateTime maturity;
        protected String contractYearMonth;
        protected ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder underlyer;
        protected SettlementTypeEnum settlementType;

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="futureContractReference")
        @RuneAttribute(value="futureContractReference")
        public String getFutureContractReference() {
            return this.futureContractReference;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="contractYearMonth")
        @RuneAttribute(value="contractYearMonth")
        public String getContractYearMonth() {
            return this.contractYearMonth;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getUnderlyer() {
            return this.underlyer;
        }

        @Override
        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getOrCreateUnderlyer() {
            ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder result = this.underlyer != null ? this.underlyer : (this.underlyer = ExchangeTradedContractUnderlyer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FutureBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public FutureBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public FutureBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public FutureBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public FutureBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public FutureBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public FutureBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public FutureBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public FutureBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public FutureBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public FutureBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public FutureBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public FutureBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public FutureBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public FutureBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public FutureBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="futureContractReference")
        @RuneAttribute(value="futureContractReference")
        public FutureBuilder setFutureContractReference(String _futureContractReference) {
            this.futureContractReference = _futureContractReference == null ? null : _futureContractReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public FutureBuilder setMaturity(ZonedDateTime _maturity) {
            this.maturity = _maturity == null ? null : _maturity;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractYearMonth")
        @RuneAttribute(value="contractYearMonth")
        public FutureBuilder setContractYearMonth(String _contractYearMonth) {
            this.contractYearMonth = _contractYearMonth == null ? null : _contractYearMonth;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public FutureBuilder setUnderlyer(ExchangeTradedContractUnderlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public FutureBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        public Future build() {
            return new FutureImpl(this);
        }

        @Override
        public FutureBuilder toBuilder() {
            return this;
        }

        @Override
        public FutureBuilder prune() {
            super.prune();
            if (this.underlyer != null && !this.underlyer.prune().hasData()) {
                this.underlyer = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getMultiplier() != null) {
                return true;
            }
            if (this.getFutureContractReference() != null) {
                return true;
            }
            if (this.getMaturity() != null) {
                return true;
            }
            if (this.getContractYearMonth() != null) {
                return true;
            }
            if (this.getUnderlyer() != null && this.getUnderlyer().hasData()) {
                return true;
            }
            return this.getSettlementType() != null;
        }

        @Override
        public FutureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FutureBuilder o = (FutureBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyer(), (RosettaModelObjectBuilder)o.getUnderlyer(), this::setUnderlyer);
            merger.mergeBasic((Object)this.getMultiplier(), (Object)o.getMultiplier(), this::setMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFutureContractReference(), (Object)o.getFutureContractReference(), this::setFutureContractReference, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturity(), (Object)o.getMaturity(), this::setMaturity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractYearMonth(), (Object)o.getContractYearMonth(), this::setContractYearMonth, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Future _that = (Future)this.getType().cast(o);
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.futureContractReference, _that.getFutureContractReference())) {
                return false;
            }
            if (!Objects.equals(this.maturity, _that.getMaturity())) {
                return false;
            }
            if (!Objects.equals(this.contractYearMonth, _that.getContractYearMonth())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            return Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.futureContractReference != null ? this.futureContractReference.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            _result = 31 * _result + (this.contractYearMonth != null ? this.contractYearMonth.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FutureBuilder {multiplier=" + this.multiplier + ", futureContractReference=" + this.futureContractReference + ", maturity=" + this.maturity + ", contractYearMonth=" + this.contractYearMonth + ", underlyer=" + this.underlyer + ", settlementType=" + (Object)((Object)this.settlementType) + '}' + " " + super.toString();
        }
    }

    public static interface FutureBuilder
    extends Future,
    ExchangeTraded.ExchangeTradedBuilder {
        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getOrCreateUnderlyer();

        @Override
        public ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder getUnderlyer();

        @Override
        public FutureBuilder setId(String var1);

        @Override
        public FutureBuilder addInstrumentId(InstrumentId var1);

        @Override
        public FutureBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public FutureBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FutureBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public FutureBuilder addInstrumentType(InstrumentType var1);

        @Override
        public FutureBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public FutureBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public FutureBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public FutureBuilder setDescription(String var1);

        @Override
        public FutureBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public FutureBuilder setExchangeId(ExchangeId var1);

        @Override
        public FutureBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public FutureBuilder setDefinition(ProductReference var1);

        @Override
        public FutureBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        public FutureBuilder setMultiplier(BigDecimal var1);

        public FutureBuilder setFutureContractReference(String var1);

        public FutureBuilder setMaturity(ZonedDateTime var1);

        public FutureBuilder setContractYearMonth(String var1);

        public FutureBuilder setUnderlyer(ExchangeTradedContractUnderlyer var1);

        public FutureBuilder setSettlementType(SettlementTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, (RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("futureContractReference"), String.class, (Object)this.getFutureContractReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturity"), ZonedDateTime.class, (Object)this.getMaturity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractYearMonth"), String.class, (Object)this.getContractYearMonth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder.class, this.getUnderlyer(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public FutureBuilder prune();
    }

    public static class FutureImpl
    extends ExchangeTraded.ExchangeTradedImpl
    implements Future {
        private final BigDecimal multiplier;
        private final String futureContractReference;
        private final ZonedDateTime maturity;
        private final String contractYearMonth;
        private final ExchangeTradedContractUnderlyer underlyer;
        private final SettlementTypeEnum settlementType;

        protected FutureImpl(FutureBuilder builder) {
            super(builder);
            this.multiplier = builder.getMultiplier();
            this.futureContractReference = builder.getFutureContractReference();
            this.maturity = builder.getMaturity();
            this.contractYearMonth = builder.getContractYearMonth();
            this.underlyer = Optional.ofNullable(builder.getUnderlyer()).map(f -> f.build()).orElse(null);
            this.settlementType = builder.getSettlementType();
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="futureContractReference")
        @RuneAttribute(value="futureContractReference")
        public String getFutureContractReference() {
            return this.futureContractReference;
        }

        @Override
        @RosettaAttribute(value="maturity")
        @RuneAttribute(value="maturity")
        public ZonedDateTime getMaturity() {
            return this.maturity;
        }

        @Override
        @RosettaAttribute(value="contractYearMonth")
        @RuneAttribute(value="contractYearMonth")
        public String getContractYearMonth() {
            return this.contractYearMonth;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public ExchangeTradedContractUnderlyer getUnderlyer() {
            return this.underlyer;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        public Future build() {
            return this;
        }

        @Override
        public FutureBuilder toBuilder() {
            FutureBuilder builder = Future.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FutureBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
            Optional.ofNullable(this.getFutureContractReference()).ifPresent(builder::setFutureContractReference);
            Optional.ofNullable(this.getMaturity()).ifPresent(builder::setMaturity);
            Optional.ofNullable(this.getContractYearMonth()).ifPresent(builder::setContractYearMonth);
            Optional.ofNullable(this.getUnderlyer()).ifPresent(builder::setUnderlyer);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Future _that = (Future)this.getType().cast(o);
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.futureContractReference, _that.getFutureContractReference())) {
                return false;
            }
            if (!Objects.equals(this.maturity, _that.getMaturity())) {
                return false;
            }
            if (!Objects.equals(this.contractYearMonth, _that.getContractYearMonth())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            return Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.futureContractReference != null ? this.futureContractReference.hashCode() : 0);
            _result = 31 * _result + (this.maturity != null ? this.maturity.hashCode() : 0);
            _result = 31 * _result + (this.contractYearMonth != null ? this.contractYearMonth.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Future {multiplier=" + this.multiplier + ", futureContractReference=" + this.futureContractReference + ", maturity=" + this.maturity + ", contractYearMonth=" + this.contractYearMonth + ", underlyer=" + this.underlyer + ", settlementType=" + (Object)((Object)this.settlementType) + '}' + " " + super.toString();
        }
    }
}

