/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AdjustableDate;
import fpml.confirmation.BuyerSellerModel;
import fpml.confirmation.DayCountFraction;
import fpml.confirmation.FloatingRateIndex;
import fpml.confirmation.FraDiscountingEnum;
import fpml.confirmation.IdentifiedRate;
import fpml.confirmation.Money;
import fpml.confirmation.Payment;
import fpml.confirmation.Period;
import fpml.confirmation.Product;
import fpml.confirmation.ProductModel;
import fpml.confirmation.RelativeDateOffset;
import fpml.confirmation.RequiredIdentifierDate;
import fpml.confirmation.meta.FraMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Fra", builder=FraBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Fra", model="fpml", builder=FraBuilderImpl.class, version="0.17.2")
public interface Fra
extends Product {
    public static final FraMeta metaData = new FraMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public RequiredIdentifierDate getAdjustedEffectiveDate();

    public ZonedDateTime getAdjustedTerminationDate();

    public AdjustableDate getPaymentDate();

    public RelativeDateOffset getFixingDateOffset();

    public DayCountFraction getDayCountFraction();

    public Integer getCalculationPeriodNumberOfDays();

    public Money getNotional();

    public IdentifiedRate getFixedRate();

    public FloatingRateIndex getFloatingRateIndex();

    public List<? extends Period> getIndexTenor();

    public FraDiscountingEnum getFraDiscounting();

    public List<? extends Payment> getAdditionalPayment();

    @Override
    public Fra build();

    @Override
    public FraBuilder toBuilder();

    public static FraBuilder builder() {
        return new FraBuilderImpl();
    }

    default public RosettaMetaData<? extends Fra> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Fra> getType() {
        return Fra.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustedEffectiveDate"), processor, RequiredIdentifierDate.class, this.getAdjustedEffectiveDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedTerminationDate"), ZonedDateTime.class, (Object)this.getAdjustedTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingDateOffset"), processor, RelativeDateOffset.class, this.getFixingDateOffset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, Money.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedRate"), processor, IdentifiedRate.class, this.getFixedRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FloatingRateIndex.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("indexTenor"), processor, Period.class, this.getIndexTenor(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fraDiscounting"), FraDiscountingEnum.class, (Object)this.getFraDiscounting(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
    }

    public static class FraBuilderImpl
    extends Product.ProductBuilderImpl
    implements FraBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected RequiredIdentifierDate.RequiredIdentifierDateBuilder adjustedEffectiveDate;
        protected ZonedDateTime adjustedTerminationDate;
        protected AdjustableDate.AdjustableDateBuilder paymentDate;
        protected RelativeDateOffset.RelativeDateOffsetBuilder fixingDateOffset;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected Integer calculationPeriodNumberOfDays;
        protected Money.MoneyBuilder notional;
        protected IdentifiedRate.IdentifiedRateBuilder fixedRate;
        protected FloatingRateIndex.FloatingRateIndexBuilder floatingRateIndex;
        protected List<Period.PeriodBuilder> indexTenor = new ArrayList<Period.PeriodBuilder>();
        protected FraDiscountingEnum fraDiscounting;
        protected List<Payment.PaymentBuilder> additionalPayment = new ArrayList<Payment.PaymentBuilder>();

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustedEffectiveDate", isRequired=true)
        @RuneAttribute(value="adjustedEffectiveDate", isRequired=true)
        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getAdjustedEffectiveDate() {
            return this.adjustedEffectiveDate;
        }

        @Override
        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getOrCreateAdjustedEffectiveDate() {
            RequiredIdentifierDate.RequiredIdentifierDateBuilder result = this.adjustedEffectiveDate != null ? this.adjustedEffectiveDate : (this.adjustedEffectiveDate = RequiredIdentifierDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustedTerminationDate", isRequired=true)
        @RuneAttribute(value="adjustedTerminationDate", isRequired=true)
        public ZonedDateTime getAdjustedTerminationDate() {
            return this.adjustedTerminationDate;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public AdjustableDate.AdjustableDateBuilder getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate() {
            AdjustableDate.AdjustableDateBuilder result = this.paymentDate != null ? this.paymentDate : (this.paymentDate = AdjustableDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingDateOffset", isRequired=true)
        @RuneAttribute(value="fixingDateOffset", isRequired=true)
        public RelativeDateOffset.RelativeDateOffsetBuilder getFixingDateOffset() {
            return this.fixingDateOffset;
        }

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateFixingDateOffset() {
            RelativeDateOffset.RelativeDateOffsetBuilder result = this.fixingDateOffset != null ? this.fixingDateOffset : (this.fixingDateOffset = RelativeDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodNumberOfDays")
        @RuneAttribute(value="calculationPeriodNumberOfDays")
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public Money.MoneyBuilder getNotional() {
            return this.notional;
        }

        @Override
        public Money.MoneyBuilder getOrCreateNotional() {
            Money.MoneyBuilder result = this.notional != null ? this.notional : (this.notional = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRate", isRequired=true)
        @RuneAttribute(value="fixedRate", isRequired=true)
        public IdentifiedRate.IdentifiedRateBuilder getFixedRate() {
            return this.fixedRate;
        }

        @Override
        public IdentifiedRate.IdentifiedRateBuilder getOrCreateFixedRate() {
            IdentifiedRate.IdentifiedRateBuilder result = this.fixedRate != null ? this.fixedRate : (this.fixedRate = IdentifiedRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndex.FloatingRateIndexBuilder getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        public FloatingRateIndex.FloatingRateIndexBuilder getOrCreateFloatingRateIndex() {
            FloatingRateIndex.FloatingRateIndexBuilder result = this.floatingRateIndex != null ? this.floatingRateIndex : (this.floatingRateIndex = FloatingRateIndex.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexTenor", isRequired=true)
        @RuneAttribute(value="indexTenor", isRequired=true)
        public List<? extends Period.PeriodBuilder> getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        public Period.PeriodBuilder getOrCreateIndexTenor(int index) {
            if (this.indexTenor == null) {
                this.indexTenor = new ArrayList<Period.PeriodBuilder>();
            }
            return (Period.PeriodBuilder)this.getIndex(this.indexTenor, index, () -> {
                Period.PeriodBuilder newIndexTenor = Period.builder();
                return newIndexTenor;
            });
        }

        @Override
        @RosettaAttribute(value="fraDiscounting", isRequired=true)
        @RuneAttribute(value="fraDiscounting", isRequired=true)
        public FraDiscountingEnum getFraDiscounting() {
            return this.fraDiscounting;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment.PaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                Payment.PaymentBuilder newAdditionalPayment = Payment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FraBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FraBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public FraBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedEffectiveDate", isRequired=true)
        @RuneAttribute(value="adjustedEffectiveDate", isRequired=true)
        public FraBuilder setAdjustedEffectiveDate(RequiredIdentifierDate _adjustedEffectiveDate) {
            this.adjustedEffectiveDate = _adjustedEffectiveDate == null ? null : _adjustedEffectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedTerminationDate", isRequired=true)
        @RuneAttribute(value="adjustedTerminationDate", isRequired=true)
        public FraBuilder setAdjustedTerminationDate(ZonedDateTime _adjustedTerminationDate) {
            this.adjustedTerminationDate = _adjustedTerminationDate == null ? null : _adjustedTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public FraBuilder setPaymentDate(AdjustableDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDateOffset", isRequired=true)
        @RuneAttribute(value="fixingDateOffset", isRequired=true)
        public FraBuilder setFixingDateOffset(RelativeDateOffset _fixingDateOffset) {
            this.fixingDateOffset = _fixingDateOffset == null ? null : _fixingDateOffset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public FraBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodNumberOfDays")
        @RuneAttribute(value="calculationPeriodNumberOfDays")
        public FraBuilder setCalculationPeriodNumberOfDays(Integer _calculationPeriodNumberOfDays) {
            this.calculationPeriodNumberOfDays = _calculationPeriodNumberOfDays == null ? null : _calculationPeriodNumberOfDays;
            return this;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public FraBuilder setNotional(Money _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate", isRequired=true)
        @RuneAttribute(value="fixedRate", isRequired=true)
        public FraBuilder setFixedRate(IdentifiedRate _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FraBuilder setFloatingRateIndex(FloatingRateIndex _floatingRateIndex) {
            this.floatingRateIndex = _floatingRateIndex == null ? null : _floatingRateIndex.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexTenor", isRequired=true)
        @RuneAttribute(value="indexTenor", isRequired=true)
        public FraBuilder addIndexTenor(Period _indexTenor) {
            if (_indexTenor != null) {
                this.indexTenor.add(_indexTenor.toBuilder());
            }
            return this;
        }

        @Override
        public FraBuilder addIndexTenor(Period _indexTenor, int idx) {
            this.getIndex(this.indexTenor, idx, () -> _indexTenor.toBuilder());
            return this;
        }

        @Override
        public FraBuilder addIndexTenor(List<? extends Period> indexTenors) {
            if (indexTenors != null) {
                for (Period period : indexTenors) {
                    this.indexTenor.add(period.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="indexTenor")
        public FraBuilder setIndexTenor(List<? extends Period> indexTenors) {
            this.indexTenor = indexTenors == null ? new ArrayList<Period.PeriodBuilder>() : (List)indexTenors.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="fraDiscounting", isRequired=true)
        @RuneAttribute(value="fraDiscounting", isRequired=true)
        public FraBuilder setFraDiscounting(FraDiscountingEnum _fraDiscounting) {
            this.fraDiscounting = _fraDiscounting == null ? null : _fraDiscounting;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public FraBuilder addAdditionalPayment(Payment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public FraBuilder addAdditionalPayment(Payment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public FraBuilder addAdditionalPayment(List<? extends Payment> additionalPayments) {
            if (additionalPayments != null) {
                for (Payment payment : additionalPayments) {
                    this.additionalPayment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public FraBuilder setAdditionalPayment(List<? extends Payment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Fra build() {
            return new FraImpl(this);
        }

        @Override
        public FraBuilder toBuilder() {
            return this;
        }

        @Override
        public FraBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.adjustedEffectiveDate != null && !this.adjustedEffectiveDate.prune().hasData()) {
                this.adjustedEffectiveDate = null;
            }
            if (this.paymentDate != null && !this.paymentDate.prune().hasData()) {
                this.paymentDate = null;
            }
            if (this.fixingDateOffset != null && !this.fixingDateOffset.prune().hasData()) {
                this.fixingDateOffset = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            if (this.fixedRate != null && !this.fixedRate.prune().hasData()) {
                this.fixedRate = null;
            }
            if (this.floatingRateIndex != null && !this.floatingRateIndex.prune().hasData()) {
                this.floatingRateIndex = null;
            }
            this.indexTenor = this.indexTenor.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getAdjustedEffectiveDate() != null && this.getAdjustedEffectiveDate().hasData()) {
                return true;
            }
            if (this.getAdjustedTerminationDate() != null) {
                return true;
            }
            if (this.getPaymentDate() != null && this.getPaymentDate().hasData()) {
                return true;
            }
            if (this.getFixingDateOffset() != null && this.getFixingDateOffset().hasData()) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getCalculationPeriodNumberOfDays() != null) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            if (this.getFixedRate() != null && this.getFixedRate().hasData()) {
                return true;
            }
            if (this.getFloatingRateIndex() != null && this.getFloatingRateIndex().hasData()) {
                return true;
            }
            if (this.getIndexTenor() != null && this.getIndexTenor().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFraDiscounting() != null) {
                return true;
            }
            return this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FraBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FraBuilder o = (FraBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdjustedEffectiveDate(), (RosettaModelObjectBuilder)o.getAdjustedEffectiveDate(), this::setAdjustedEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentDate(), (RosettaModelObjectBuilder)o.getPaymentDate(), this::setPaymentDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingDateOffset(), (RosettaModelObjectBuilder)o.getFixingDateOffset(), this::setFixingDateOffset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedRate(), (RosettaModelObjectBuilder)o.getFixedRate(), this::setFixedRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)o.getFloatingRateIndex(), this::setFloatingRateIndex);
            merger.mergeRosetta(this.getIndexTenor(), o.getIndexTenor(), this::getOrCreateIndexTenor);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeBasic((Object)this.getAdjustedTerminationDate(), (Object)o.getAdjustedTerminationDate(), this::setAdjustedTerminationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCalculationPeriodNumberOfDays(), (Object)o.getCalculationPeriodNumberOfDays(), this::setCalculationPeriodNumberOfDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFraDiscounting(), (Object)o.getFraDiscounting(), this::setFraDiscounting, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Fra _that = (Fra)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.adjustedEffectiveDate, _that.getAdjustedEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedTerminationDate, _that.getAdjustedTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.fixingDateOffset, _that.getFixingDateOffset())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            if (!ListEquals.listEquals(this.indexTenor, _that.getIndexTenor())) {
                return false;
            }
            if (!Objects.equals((Object)this.fraDiscounting, (Object)_that.getFraDiscounting())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.adjustedEffectiveDate != null ? this.adjustedEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedTerminationDate != null ? this.adjustedTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.fixingDateOffset != null ? this.fixingDateOffset.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            _result = 31 * _result + (this.fraDiscounting != null ? ((Object)((Object)this.fraDiscounting)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FraBuilder {buyerSellerModel=" + this.buyerSellerModel + ", adjustedEffectiveDate=" + this.adjustedEffectiveDate + ", adjustedTerminationDate=" + this.adjustedTerminationDate + ", paymentDate=" + this.paymentDate + ", fixingDateOffset=" + this.fixingDateOffset + ", dayCountFraction=" + this.dayCountFraction + ", calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", notional=" + this.notional + ", fixedRate=" + this.fixedRate + ", floatingRateIndex=" + this.floatingRateIndex + ", indexTenor=" + this.indexTenor + ", fraDiscounting=" + (Object)((Object)this.fraDiscounting) + ", additionalPayment=" + this.additionalPayment + '}' + " " + super.toString();
        }
    }

    public static interface FraBuilder
    extends Fra,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getOrCreateAdjustedEffectiveDate();

        @Override
        public RequiredIdentifierDate.RequiredIdentifierDateBuilder getAdjustedEffectiveDate();

        public AdjustableDate.AdjustableDateBuilder getOrCreatePaymentDate();

        @Override
        public AdjustableDate.AdjustableDateBuilder getPaymentDate();

        public RelativeDateOffset.RelativeDateOffsetBuilder getOrCreateFixingDateOffset();

        @Override
        public RelativeDateOffset.RelativeDateOffsetBuilder getFixingDateOffset();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public Money.MoneyBuilder getOrCreateNotional();

        @Override
        public Money.MoneyBuilder getNotional();

        public IdentifiedRate.IdentifiedRateBuilder getOrCreateFixedRate();

        @Override
        public IdentifiedRate.IdentifiedRateBuilder getFixedRate();

        public FloatingRateIndex.FloatingRateIndexBuilder getOrCreateFloatingRateIndex();

        @Override
        public FloatingRateIndex.FloatingRateIndexBuilder getFloatingRateIndex();

        public Period.PeriodBuilder getOrCreateIndexTenor(int var1);

        public List<? extends Period.PeriodBuilder> getIndexTenor();

        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends Payment.PaymentBuilder> getAdditionalPayment();

        @Override
        public FraBuilder setProductModel(ProductModel var1);

        @Override
        public FraBuilder setId(String var1);

        public FraBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public FraBuilder setAdjustedEffectiveDate(RequiredIdentifierDate var1);

        public FraBuilder setAdjustedTerminationDate(ZonedDateTime var1);

        public FraBuilder setPaymentDate(AdjustableDate var1);

        public FraBuilder setFixingDateOffset(RelativeDateOffset var1);

        public FraBuilder setDayCountFraction(DayCountFraction var1);

        public FraBuilder setCalculationPeriodNumberOfDays(Integer var1);

        public FraBuilder setNotional(Money var1);

        public FraBuilder setFixedRate(IdentifiedRate var1);

        public FraBuilder setFloatingRateIndex(FloatingRateIndex var1);

        public FraBuilder addIndexTenor(Period var1);

        public FraBuilder addIndexTenor(Period var1, int var2);

        public FraBuilder addIndexTenor(List<? extends Period> var1);

        public FraBuilder setIndexTenor(List<? extends Period> var1);

        public FraBuilder setFraDiscounting(FraDiscountingEnum var1);

        public FraBuilder addAdditionalPayment(Payment var1);

        public FraBuilder addAdditionalPayment(Payment var1, int var2);

        public FraBuilder addAdditionalPayment(List<? extends Payment> var1);

        public FraBuilder setAdditionalPayment(List<? extends Payment> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustedEffectiveDate"), processor, RequiredIdentifierDate.RequiredIdentifierDateBuilder.class, this.getAdjustedEffectiveDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedTerminationDate"), ZonedDateTime.class, (Object)this.getAdjustedTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableDate.AdjustableDateBuilder.class, this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingDateOffset"), processor, RelativeDateOffset.RelativeDateOffsetBuilder.class, this.getFixingDateOffset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationPeriodNumberOfDays"), Integer.class, (Object)this.getCalculationPeriodNumberOfDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, Money.MoneyBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedRate"), processor, IdentifiedRate.IdentifiedRateBuilder.class, this.getFixedRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FloatingRateIndex.FloatingRateIndexBuilder.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("indexTenor"), processor, Period.PeriodBuilder.class, this.getIndexTenor(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fraDiscounting"), FraDiscountingEnum.class, (Object)this.getFraDiscounting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.PaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        }

        @Override
        public FraBuilder prune();
    }

    public static class FraImpl
    extends Product.ProductImpl
    implements Fra {
        private final BuyerSellerModel buyerSellerModel;
        private final RequiredIdentifierDate adjustedEffectiveDate;
        private final ZonedDateTime adjustedTerminationDate;
        private final AdjustableDate paymentDate;
        private final RelativeDateOffset fixingDateOffset;
        private final DayCountFraction dayCountFraction;
        private final Integer calculationPeriodNumberOfDays;
        private final Money notional;
        private final IdentifiedRate fixedRate;
        private final FloatingRateIndex floatingRateIndex;
        private final List<? extends Period> indexTenor;
        private final FraDiscountingEnum fraDiscounting;
        private final List<? extends Payment> additionalPayment;

        protected FraImpl(FraBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.adjustedEffectiveDate = Optional.ofNullable(builder.getAdjustedEffectiveDate()).map(f -> f.build()).orElse(null);
            this.adjustedTerminationDate = builder.getAdjustedTerminationDate();
            this.paymentDate = Optional.ofNullable(builder.getPaymentDate()).map(f -> f.build()).orElse(null);
            this.fixingDateOffset = Optional.ofNullable(builder.getFixingDateOffset()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.calculationPeriodNumberOfDays = builder.getCalculationPeriodNumberOfDays();
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.fixedRate = Optional.ofNullable(builder.getFixedRate()).map(f -> f.build()).orElse(null);
            this.floatingRateIndex = Optional.ofNullable(builder.getFloatingRateIndex()).map(f -> f.build()).orElse(null);
            this.indexTenor = Optional.ofNullable(builder.getIndexTenor()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.fraDiscounting = builder.getFraDiscounting();
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="adjustedEffectiveDate", isRequired=true)
        @RuneAttribute(value="adjustedEffectiveDate", isRequired=true)
        public RequiredIdentifierDate getAdjustedEffectiveDate() {
            return this.adjustedEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="adjustedTerminationDate", isRequired=true)
        @RuneAttribute(value="adjustedTerminationDate", isRequired=true)
        public ZonedDateTime getAdjustedTerminationDate() {
            return this.adjustedTerminationDate;
        }

        @Override
        @RosettaAttribute(value="paymentDate", isRequired=true)
        @RuneAttribute(value="paymentDate", isRequired=true)
        public AdjustableDate getPaymentDate() {
            return this.paymentDate;
        }

        @Override
        @RosettaAttribute(value="fixingDateOffset", isRequired=true)
        @RuneAttribute(value="fixingDateOffset", isRequired=true)
        public RelativeDateOffset getFixingDateOffset() {
            return this.fixingDateOffset;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="calculationPeriodNumberOfDays")
        @RuneAttribute(value="calculationPeriodNumberOfDays")
        public Integer getCalculationPeriodNumberOfDays() {
            return this.calculationPeriodNumberOfDays;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public Money getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="fixedRate", isRequired=true)
        @RuneAttribute(value="fixedRate", isRequired=true)
        public IdentifiedRate getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndex getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="indexTenor", isRequired=true)
        @RuneAttribute(value="indexTenor", isRequired=true)
        public List<? extends Period> getIndexTenor() {
            return this.indexTenor;
        }

        @Override
        @RosettaAttribute(value="fraDiscounting", isRequired=true)
        @RuneAttribute(value="fraDiscounting", isRequired=true)
        public FraDiscountingEnum getFraDiscounting() {
            return this.fraDiscounting;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public Fra build() {
            return this;
        }

        @Override
        public FraBuilder toBuilder() {
            FraBuilder builder = Fra.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FraBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getAdjustedEffectiveDate()).ifPresent(builder::setAdjustedEffectiveDate);
            Optional.ofNullable(this.getAdjustedTerminationDate()).ifPresent(builder::setAdjustedTerminationDate);
            Optional.ofNullable(this.getPaymentDate()).ifPresent(builder::setPaymentDate);
            Optional.ofNullable(this.getFixingDateOffset()).ifPresent(builder::setFixingDateOffset);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getCalculationPeriodNumberOfDays()).ifPresent(builder::setCalculationPeriodNumberOfDays);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getFloatingRateIndex()).ifPresent(builder::setFloatingRateIndex);
            Optional.ofNullable(this.getIndexTenor()).ifPresent(builder::setIndexTenor);
            Optional.ofNullable(this.getFraDiscounting()).ifPresent(builder::setFraDiscounting);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Fra _that = (Fra)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.adjustedEffectiveDate, _that.getAdjustedEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedTerminationDate, _that.getAdjustedTerminationDate())) {
                return false;
            }
            if (!Objects.equals(this.paymentDate, _that.getPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.fixingDateOffset, _that.getFixingDateOffset())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.calculationPeriodNumberOfDays, _that.getCalculationPeriodNumberOfDays())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            if (!ListEquals.listEquals(this.indexTenor, _that.getIndexTenor())) {
                return false;
            }
            if (!Objects.equals((Object)this.fraDiscounting, (Object)_that.getFraDiscounting())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.adjustedEffectiveDate != null ? this.adjustedEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedTerminationDate != null ? this.adjustedTerminationDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentDate != null ? this.paymentDate.hashCode() : 0);
            _result = 31 * _result + (this.fixingDateOffset != null ? this.fixingDateOffset.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.calculationPeriodNumberOfDays != null ? this.calculationPeriodNumberOfDays.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.indexTenor != null ? this.indexTenor.hashCode() : 0);
            _result = 31 * _result + (this.fraDiscounting != null ? ((Object)((Object)this.fraDiscounting)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Fra {buyerSellerModel=" + this.buyerSellerModel + ", adjustedEffectiveDate=" + this.adjustedEffectiveDate + ", adjustedTerminationDate=" + this.adjustedTerminationDate + ", paymentDate=" + this.paymentDate + ", fixingDateOffset=" + this.fixingDateOffset + ", dayCountFraction=" + this.dayCountFraction + ", calculationPeriodNumberOfDays=" + this.calculationPeriodNumberOfDays + ", notional=" + this.notional + ", fixedRate=" + this.fixedRate + ", floatingRateIndex=" + this.floatingRateIndex + ", indexTenor=" + this.indexTenor + ", fraDiscounting=" + (Object)((Object)this.fraDiscounting) + ", additionalPayment=" + this.additionalPayment + '}' + " " + super.toString();
        }
    }
}

