/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AbstractFixedRateOptionBase;
import fpml.confirmation.AccrualTypeId;
import fpml.confirmation.DayCountFraction;
import fpml.confirmation.FixedRateAccrualSequence;
import fpml.confirmation.PaymentProjection;
import fpml.confirmation.Period;
import fpml.confirmation.PeriodWithDaysModel;
import fpml.confirmation.meta.FixedRateAccrualMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FixedRateAccrual", builder=FixedRateAccrualBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FixedRateAccrual", model="fpml", builder=FixedRateAccrualBuilderImpl.class, version="0.17.2")
public interface FixedRateAccrual
extends AbstractFixedRateOptionBase {
    public static final FixedRateAccrualMeta metaData = new FixedRateAccrualMeta();

    public PeriodWithDaysModel getPeriodWithDaysModel();

    public FixedRateAccrualSequence getFixedRateAccrualSequence();

    public PaymentProjection getPaymentProjection();

    @Override
    public FixedRateAccrual build();

    @Override
    public FixedRateAccrualBuilder toBuilder();

    public static FixedRateAccrualBuilder builder() {
        return new FixedRateAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends FixedRateAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FixedRateAccrual> getType() {
        return FixedRateAccrual.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("pikSpread"), BigDecimal.class, (Object)this.getPikSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedRateAccrualSequence"), processor, FixedRateAccrualSequence.class, this.getFixedRateAccrualSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentProjection"), processor, PaymentProjection.class, this.getPaymentProjection(), new AttributeMeta[0]);
    }

    public static class FixedRateAccrualBuilderImpl
    extends AbstractFixedRateOptionBase.AbstractFixedRateOptionBaseBuilderImpl
    implements FixedRateAccrualBuilder {
        protected PeriodWithDaysModel.PeriodWithDaysModelBuilder periodWithDaysModel;
        protected FixedRateAccrualSequence.FixedRateAccrualSequenceBuilder fixedRateAccrualSequence;
        protected PaymentProjection.PaymentProjectionBuilder paymentProjection;

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel() {
            PeriodWithDaysModel.PeriodWithDaysModelBuilder result = this.periodWithDaysModel != null ? this.periodWithDaysModel : (this.periodWithDaysModel = PeriodWithDaysModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRateAccrualSequence")
        @RuneAttribute(value="fixedRateAccrualSequence")
        public FixedRateAccrualSequence.FixedRateAccrualSequenceBuilder getFixedRateAccrualSequence() {
            return this.fixedRateAccrualSequence;
        }

        @Override
        public FixedRateAccrualSequence.FixedRateAccrualSequenceBuilder getOrCreateFixedRateAccrualSequence() {
            FixedRateAccrualSequence.FixedRateAccrualSequenceBuilder result = this.fixedRateAccrualSequence != null ? this.fixedRateAccrualSequence : (this.fixedRateAccrualSequence = FixedRateAccrualSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentProjection")
        @RuneAttribute(value="paymentProjection")
        public PaymentProjection.PaymentProjectionBuilder getPaymentProjection() {
            return this.paymentProjection;
        }

        @Override
        public PaymentProjection.PaymentProjectionBuilder getOrCreatePaymentProjection() {
            PaymentProjection.PaymentProjectionBuilder result = this.paymentProjection != null ? this.paymentProjection : (this.paymentProjection = PaymentProjection.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public FixedRateAccrualBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public FixedRateAccrualBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public FixedRateAccrualBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public FixedRateAccrualBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="pikSpread")
        @RuneAttribute(value="pikSpread")
        public FixedRateAccrualBuilder setPikSpread(BigDecimal _pikSpread) {
            this.pikSpread = _pikSpread == null ? null : _pikSpread;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public FixedRateAccrualBuilder setPeriodWithDaysModel(PeriodWithDaysModel _periodWithDaysModel) {
            this.periodWithDaysModel = _periodWithDaysModel == null ? null : _periodWithDaysModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateAccrualSequence")
        @RuneAttribute(value="fixedRateAccrualSequence")
        public FixedRateAccrualBuilder setFixedRateAccrualSequence(FixedRateAccrualSequence _fixedRateAccrualSequence) {
            this.fixedRateAccrualSequence = _fixedRateAccrualSequence == null ? null : _fixedRateAccrualSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentProjection")
        @RuneAttribute(value="paymentProjection")
        public FixedRateAccrualBuilder setPaymentProjection(PaymentProjection _paymentProjection) {
            this.paymentProjection = _paymentProjection == null ? null : _paymentProjection.toBuilder();
            return this;
        }

        @Override
        public FixedRateAccrual build() {
            return new FixedRateAccrualImpl(this);
        }

        @Override
        public FixedRateAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public FixedRateAccrualBuilder prune() {
            super.prune();
            if (this.periodWithDaysModel != null && !this.periodWithDaysModel.prune().hasData()) {
                this.periodWithDaysModel = null;
            }
            if (this.fixedRateAccrualSequence != null && !this.fixedRateAccrualSequence.prune().hasData()) {
                this.fixedRateAccrualSequence = null;
            }
            if (this.paymentProjection != null && !this.paymentProjection.prune().hasData()) {
                this.paymentProjection = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodWithDaysModel() != null && this.getPeriodWithDaysModel().hasData()) {
                return true;
            }
            if (this.getFixedRateAccrualSequence() != null && this.getFixedRateAccrualSequence().hasData()) {
                return true;
            }
            return this.getPaymentProjection() != null && this.getPaymentProjection().hasData();
        }

        @Override
        public FixedRateAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FixedRateAccrualBuilder o = (FixedRateAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodWithDaysModel(), (RosettaModelObjectBuilder)o.getPeriodWithDaysModel(), this::setPeriodWithDaysModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedRateAccrualSequence(), (RosettaModelObjectBuilder)o.getFixedRateAccrualSequence(), this::setFixedRateAccrualSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentProjection(), (RosettaModelObjectBuilder)o.getPaymentProjection(), this::setPaymentProjection);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedRateAccrual _that = (FixedRateAccrual)this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateAccrualSequence, _that.getFixedRateAccrualSequence())) {
                return false;
            }
            return Objects.equals(this.paymentProjection, _that.getPaymentProjection());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateAccrualSequence != null ? this.fixedRateAccrualSequence.hashCode() : 0);
            _result = 31 * _result + (this.paymentProjection != null ? this.paymentProjection.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedRateAccrualBuilder {periodWithDaysModel=" + this.periodWithDaysModel + ", fixedRateAccrualSequence=" + this.fixedRateAccrualSequence + ", paymentProjection=" + this.paymentProjection + '}' + " " + super.toString();
        }
    }

    public static interface FixedRateAccrualBuilder
    extends FixedRateAccrual,
    AbstractFixedRateOptionBase.AbstractFixedRateOptionBaseBuilder {
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getOrCreatePeriodWithDaysModel();

        @Override
        public PeriodWithDaysModel.PeriodWithDaysModelBuilder getPeriodWithDaysModel();

        public FixedRateAccrualSequence.FixedRateAccrualSequenceBuilder getOrCreateFixedRateAccrualSequence();

        @Override
        public FixedRateAccrualSequence.FixedRateAccrualSequenceBuilder getFixedRateAccrualSequence();

        public PaymentProjection.PaymentProjectionBuilder getOrCreatePaymentProjection();

        @Override
        public PaymentProjection.PaymentProjectionBuilder getPaymentProjection();

        @Override
        public FixedRateAccrualBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public FixedRateAccrualBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public FixedRateAccrualBuilder setPaymentFrequency(Period var1);

        @Override
        public FixedRateAccrualBuilder setRate(BigDecimal var1);

        @Override
        public FixedRateAccrualBuilder setPikSpread(BigDecimal var1);

        public FixedRateAccrualBuilder setPeriodWithDaysModel(PeriodWithDaysModel var1);

        public FixedRateAccrualBuilder setFixedRateAccrualSequence(FixedRateAccrualSequence var1);

        public FixedRateAccrualBuilder setPaymentProjection(PaymentProjection var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("pikSpread"), BigDecimal.class, (Object)this.getPikSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodWithDaysModel"), processor, PeriodWithDaysModel.PeriodWithDaysModelBuilder.class, this.getPeriodWithDaysModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedRateAccrualSequence"), processor, FixedRateAccrualSequence.FixedRateAccrualSequenceBuilder.class, this.getFixedRateAccrualSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentProjection"), processor, PaymentProjection.PaymentProjectionBuilder.class, this.getPaymentProjection(), new AttributeMeta[0]);
        }

        @Override
        public FixedRateAccrualBuilder prune();
    }

    public static class FixedRateAccrualImpl
    extends AbstractFixedRateOptionBase.AbstractFixedRateOptionBaseImpl
    implements FixedRateAccrual {
        private final PeriodWithDaysModel periodWithDaysModel;
        private final FixedRateAccrualSequence fixedRateAccrualSequence;
        private final PaymentProjection paymentProjection;

        protected FixedRateAccrualImpl(FixedRateAccrualBuilder builder) {
            super(builder);
            this.periodWithDaysModel = Optional.ofNullable(builder.getPeriodWithDaysModel()).map(f -> f.build()).orElse(null);
            this.fixedRateAccrualSequence = Optional.ofNullable(builder.getFixedRateAccrualSequence()).map(f -> f.build()).orElse(null);
            this.paymentProjection = Optional.ofNullable(builder.getPaymentProjection()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodWithDaysModel", isRequired=true)
        @RuneAttribute(value="periodWithDaysModel", isRequired=true)
        public PeriodWithDaysModel getPeriodWithDaysModel() {
            return this.periodWithDaysModel;
        }

        @Override
        @RosettaAttribute(value="fixedRateAccrualSequence")
        @RuneAttribute(value="fixedRateAccrualSequence")
        public FixedRateAccrualSequence getFixedRateAccrualSequence() {
            return this.fixedRateAccrualSequence;
        }

        @Override
        @RosettaAttribute(value="paymentProjection")
        @RuneAttribute(value="paymentProjection")
        public PaymentProjection getPaymentProjection() {
            return this.paymentProjection;
        }

        @Override
        public FixedRateAccrual build() {
            return this;
        }

        @Override
        public FixedRateAccrualBuilder toBuilder() {
            FixedRateAccrualBuilder builder = FixedRateAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FixedRateAccrualBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodWithDaysModel()).ifPresent(builder::setPeriodWithDaysModel);
            Optional.ofNullable(this.getFixedRateAccrualSequence()).ifPresent(builder::setFixedRateAccrualSequence);
            Optional.ofNullable(this.getPaymentProjection()).ifPresent(builder::setPaymentProjection);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FixedRateAccrual _that = (FixedRateAccrual)this.getType().cast(o);
            if (!Objects.equals(this.periodWithDaysModel, _that.getPeriodWithDaysModel())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateAccrualSequence, _that.getFixedRateAccrualSequence())) {
                return false;
            }
            return Objects.equals(this.paymentProjection, _that.getPaymentProjection());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodWithDaysModel != null ? this.periodWithDaysModel.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateAccrualSequence != null ? this.fixedRateAccrualSequence.hashCode() : 0);
            _result = 31 * _result + (this.paymentProjection != null ? this.paymentProjection.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FixedRateAccrual {periodWithDaysModel=" + this.periodWithDaysModel + ", fixedRateAccrualSequence=" + this.fixedRateAccrualSequence + ", paymentProjection=" + this.paymentProjection + '}' + " " + super.toString();
        }
    }
}

