/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.meta.ExerciseEventMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExerciseEvent", builder=ExerciseEventBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ExerciseEvent", model="fpml", builder=ExerciseEventBuilderImpl.class, version="0.17.2")
public interface ExerciseEvent
extends RosettaModelObject {
    public static final ExerciseEventMeta metaData = new ExerciseEventMeta();

    public ZonedDateTime getAdjustedExerciseDate();

    public ZonedDateTime getAdjustedRelevantSwapEffectiveDate();

    public ZonedDateTime getAdjustedCashSettlementValuationDate();

    public ZonedDateTime getAdjustedCashSettlementPaymentDate();

    public ZonedDateTime getAdjustedExerciseFeePaymentDate();

    public String getId();

    public ExerciseEvent build();

    public ExerciseEventBuilder toBuilder();

    public static ExerciseEventBuilder builder() {
        return new ExerciseEventBuilderImpl();
    }

    default public RosettaMetaData<? extends ExerciseEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExerciseEvent> getType() {
        return ExerciseEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustedExerciseDate"), ZonedDateTime.class, (Object)this.getAdjustedExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedRelevantSwapEffectiveDate"), ZonedDateTime.class, (Object)this.getAdjustedRelevantSwapEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedCashSettlementValuationDate"), ZonedDateTime.class, (Object)this.getAdjustedCashSettlementValuationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedCashSettlementPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedCashSettlementPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedExerciseFeePaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedExerciseFeePaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ExerciseEventBuilderImpl
    implements ExerciseEventBuilder {
        protected ZonedDateTime adjustedExerciseDate;
        protected ZonedDateTime adjustedRelevantSwapEffectiveDate;
        protected ZonedDateTime adjustedCashSettlementValuationDate;
        protected ZonedDateTime adjustedCashSettlementPaymentDate;
        protected ZonedDateTime adjustedExerciseFeePaymentDate;
        protected String id;

        @Override
        @RosettaAttribute(value="adjustedExerciseDate", isRequired=true)
        @RuneAttribute(value="adjustedExerciseDate", isRequired=true)
        public ZonedDateTime getAdjustedExerciseDate() {
            return this.adjustedExerciseDate;
        }

        @Override
        @RosettaAttribute(value="adjustedRelevantSwapEffectiveDate", isRequired=true)
        @RuneAttribute(value="adjustedRelevantSwapEffectiveDate", isRequired=true)
        public ZonedDateTime getAdjustedRelevantSwapEffectiveDate() {
            return this.adjustedRelevantSwapEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementValuationDate")
        @RuneAttribute(value="adjustedCashSettlementValuationDate")
        public ZonedDateTime getAdjustedCashSettlementValuationDate() {
            return this.adjustedCashSettlementValuationDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementPaymentDate")
        @RuneAttribute(value="adjustedCashSettlementPaymentDate")
        public ZonedDateTime getAdjustedCashSettlementPaymentDate() {
            return this.adjustedCashSettlementPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseFeePaymentDate")
        @RuneAttribute(value="adjustedExerciseFeePaymentDate")
        public ZonedDateTime getAdjustedExerciseFeePaymentDate() {
            return this.adjustedExerciseFeePaymentDate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseDate", isRequired=true)
        @RuneAttribute(value="adjustedExerciseDate", isRequired=true)
        public ExerciseEventBuilder setAdjustedExerciseDate(ZonedDateTime _adjustedExerciseDate) {
            this.adjustedExerciseDate = _adjustedExerciseDate == null ? null : _adjustedExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedRelevantSwapEffectiveDate", isRequired=true)
        @RuneAttribute(value="adjustedRelevantSwapEffectiveDate", isRequired=true)
        public ExerciseEventBuilder setAdjustedRelevantSwapEffectiveDate(ZonedDateTime _adjustedRelevantSwapEffectiveDate) {
            this.adjustedRelevantSwapEffectiveDate = _adjustedRelevantSwapEffectiveDate == null ? null : _adjustedRelevantSwapEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementValuationDate")
        @RuneAttribute(value="adjustedCashSettlementValuationDate")
        public ExerciseEventBuilder setAdjustedCashSettlementValuationDate(ZonedDateTime _adjustedCashSettlementValuationDate) {
            this.adjustedCashSettlementValuationDate = _adjustedCashSettlementValuationDate == null ? null : _adjustedCashSettlementValuationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementPaymentDate")
        @RuneAttribute(value="adjustedCashSettlementPaymentDate")
        public ExerciseEventBuilder setAdjustedCashSettlementPaymentDate(ZonedDateTime _adjustedCashSettlementPaymentDate) {
            this.adjustedCashSettlementPaymentDate = _adjustedCashSettlementPaymentDate == null ? null : _adjustedCashSettlementPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseFeePaymentDate")
        @RuneAttribute(value="adjustedExerciseFeePaymentDate")
        public ExerciseEventBuilder setAdjustedExerciseFeePaymentDate(ZonedDateTime _adjustedExerciseFeePaymentDate) {
            this.adjustedExerciseFeePaymentDate = _adjustedExerciseFeePaymentDate == null ? null : _adjustedExerciseFeePaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ExerciseEventBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public ExerciseEvent build() {
            return new ExerciseEventImpl(this);
        }

        @Override
        public ExerciseEventBuilder toBuilder() {
            return this;
        }

        @Override
        public ExerciseEventBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustedExerciseDate() != null) {
                return true;
            }
            if (this.getAdjustedRelevantSwapEffectiveDate() != null) {
                return true;
            }
            if (this.getAdjustedCashSettlementValuationDate() != null) {
                return true;
            }
            if (this.getAdjustedCashSettlementPaymentDate() != null) {
                return true;
            }
            if (this.getAdjustedExerciseFeePaymentDate() != null) {
                return true;
            }
            return this.getId() != null;
        }

        public ExerciseEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExerciseEventBuilder o = (ExerciseEventBuilder)other;
            merger.mergeBasic((Object)this.getAdjustedExerciseDate(), (Object)o.getAdjustedExerciseDate(), this::setAdjustedExerciseDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedRelevantSwapEffectiveDate(), (Object)o.getAdjustedRelevantSwapEffectiveDate(), this::setAdjustedRelevantSwapEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedCashSettlementValuationDate(), (Object)o.getAdjustedCashSettlementValuationDate(), this::setAdjustedCashSettlementValuationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedCashSettlementPaymentDate(), (Object)o.getAdjustedCashSettlementPaymentDate(), this::setAdjustedCashSettlementPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedExerciseFeePaymentDate(), (Object)o.getAdjustedExerciseFeePaymentDate(), this::setAdjustedExerciseFeePaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedExerciseDate, _that.getAdjustedExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedRelevantSwapEffectiveDate, _that.getAdjustedRelevantSwapEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementValuationDate, _that.getAdjustedCashSettlementValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementPaymentDate, _that.getAdjustedCashSettlementPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedExerciseFeePaymentDate, _that.getAdjustedExerciseFeePaymentDate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedExerciseDate != null ? this.adjustedExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedRelevantSwapEffectiveDate != null ? this.adjustedRelevantSwapEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementValuationDate != null ? this.adjustedCashSettlementValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementPaymentDate != null ? this.adjustedCashSettlementPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedExerciseFeePaymentDate != null ? this.adjustedExerciseFeePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseEventBuilder {adjustedExerciseDate=" + this.adjustedExerciseDate + ", adjustedRelevantSwapEffectiveDate=" + this.adjustedRelevantSwapEffectiveDate + ", adjustedCashSettlementValuationDate=" + this.adjustedCashSettlementValuationDate + ", adjustedCashSettlementPaymentDate=" + this.adjustedCashSettlementPaymentDate + ", adjustedExerciseFeePaymentDate=" + this.adjustedExerciseFeePaymentDate + ", id=" + this.id + '}';
        }
    }

    public static interface ExerciseEventBuilder
    extends ExerciseEvent,
    RosettaModelObjectBuilder {
        public ExerciseEventBuilder setAdjustedExerciseDate(ZonedDateTime var1);

        public ExerciseEventBuilder setAdjustedRelevantSwapEffectiveDate(ZonedDateTime var1);

        public ExerciseEventBuilder setAdjustedCashSettlementValuationDate(ZonedDateTime var1);

        public ExerciseEventBuilder setAdjustedCashSettlementPaymentDate(ZonedDateTime var1);

        public ExerciseEventBuilder setAdjustedExerciseFeePaymentDate(ZonedDateTime var1);

        public ExerciseEventBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustedExerciseDate"), ZonedDateTime.class, (Object)this.getAdjustedExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedRelevantSwapEffectiveDate"), ZonedDateTime.class, (Object)this.getAdjustedRelevantSwapEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedCashSettlementValuationDate"), ZonedDateTime.class, (Object)this.getAdjustedCashSettlementValuationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedCashSettlementPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedCashSettlementPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedExerciseFeePaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedExerciseFeePaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ExerciseEventBuilder prune();
    }

    public static class ExerciseEventImpl
    implements ExerciseEvent {
        private final ZonedDateTime adjustedExerciseDate;
        private final ZonedDateTime adjustedRelevantSwapEffectiveDate;
        private final ZonedDateTime adjustedCashSettlementValuationDate;
        private final ZonedDateTime adjustedCashSettlementPaymentDate;
        private final ZonedDateTime adjustedExerciseFeePaymentDate;
        private final String id;

        protected ExerciseEventImpl(ExerciseEventBuilder builder) {
            this.adjustedExerciseDate = builder.getAdjustedExerciseDate();
            this.adjustedRelevantSwapEffectiveDate = builder.getAdjustedRelevantSwapEffectiveDate();
            this.adjustedCashSettlementValuationDate = builder.getAdjustedCashSettlementValuationDate();
            this.adjustedCashSettlementPaymentDate = builder.getAdjustedCashSettlementPaymentDate();
            this.adjustedExerciseFeePaymentDate = builder.getAdjustedExerciseFeePaymentDate();
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseDate", isRequired=true)
        @RuneAttribute(value="adjustedExerciseDate", isRequired=true)
        public ZonedDateTime getAdjustedExerciseDate() {
            return this.adjustedExerciseDate;
        }

        @Override
        @RosettaAttribute(value="adjustedRelevantSwapEffectiveDate", isRequired=true)
        @RuneAttribute(value="adjustedRelevantSwapEffectiveDate", isRequired=true)
        public ZonedDateTime getAdjustedRelevantSwapEffectiveDate() {
            return this.adjustedRelevantSwapEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementValuationDate")
        @RuneAttribute(value="adjustedCashSettlementValuationDate")
        public ZonedDateTime getAdjustedCashSettlementValuationDate() {
            return this.adjustedCashSettlementValuationDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementPaymentDate")
        @RuneAttribute(value="adjustedCashSettlementPaymentDate")
        public ZonedDateTime getAdjustedCashSettlementPaymentDate() {
            return this.adjustedCashSettlementPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseFeePaymentDate")
        @RuneAttribute(value="adjustedExerciseFeePaymentDate")
        public ZonedDateTime getAdjustedExerciseFeePaymentDate() {
            return this.adjustedExerciseFeePaymentDate;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public ExerciseEvent build() {
            return this;
        }

        @Override
        public ExerciseEventBuilder toBuilder() {
            ExerciseEventBuilder builder = ExerciseEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExerciseEventBuilder builder) {
            Optional.ofNullable(this.getAdjustedExerciseDate()).ifPresent(builder::setAdjustedExerciseDate);
            Optional.ofNullable(this.getAdjustedRelevantSwapEffectiveDate()).ifPresent(builder::setAdjustedRelevantSwapEffectiveDate);
            Optional.ofNullable(this.getAdjustedCashSettlementValuationDate()).ifPresent(builder::setAdjustedCashSettlementValuationDate);
            Optional.ofNullable(this.getAdjustedCashSettlementPaymentDate()).ifPresent(builder::setAdjustedCashSettlementPaymentDate);
            Optional.ofNullable(this.getAdjustedExerciseFeePaymentDate()).ifPresent(builder::setAdjustedExerciseFeePaymentDate);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedExerciseDate, _that.getAdjustedExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedRelevantSwapEffectiveDate, _that.getAdjustedRelevantSwapEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementValuationDate, _that.getAdjustedCashSettlementValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementPaymentDate, _that.getAdjustedCashSettlementPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedExerciseFeePaymentDate, _that.getAdjustedExerciseFeePaymentDate())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedExerciseDate != null ? this.adjustedExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedRelevantSwapEffectiveDate != null ? this.adjustedRelevantSwapEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementValuationDate != null ? this.adjustedCashSettlementValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementPaymentDate != null ? this.adjustedCashSettlementPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedExerciseFeePaymentDate != null ? this.adjustedExerciseFeePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseEvent {adjustedExerciseDate=" + this.adjustedExerciseDate + ", adjustedRelevantSwapEffectiveDate=" + this.adjustedRelevantSwapEffectiveDate + ", adjustedCashSettlementValuationDate=" + this.adjustedCashSettlementValuationDate + ", adjustedCashSettlementPaymentDate=" + this.adjustedCashSettlementPaymentDate + ", adjustedExerciseFeePaymentDate=" + this.adjustedExerciseFeePaymentDate + ", id=" + this.id + '}';
        }
    }
}

