/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Currency;
import fpml.confirmation.EquityStrikeSequence;
import fpml.confirmation.meta.EquityStrikeMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityStrike", builder=EquityStrikeBuilderImpl.class, version="0.17.2")
@RuneDataType(value="EquityStrike", model="fpml", builder=EquityStrikeBuilderImpl.class, version="0.17.2")
public interface EquityStrike
extends RosettaModelObject {
    public static final EquityStrikeMeta metaData = new EquityStrikeMeta();

    public BigDecimal getStrikePrice();

    public EquityStrikeSequence getEquityStrikeSequence();

    public Currency getCurrency();

    public EquityStrike build();

    public EquityStrikeBuilder toBuilder();

    public static EquityStrikeBuilder builder() {
        return new EquityStrikeBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityStrike> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityStrike> getType() {
        return EquityStrike.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, (Object)this.getStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("equityStrikeSequence"), processor, EquityStrikeSequence.class, this.getEquityStrikeSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
    }

    public static class EquityStrikeBuilderImpl
    implements EquityStrikeBuilder {
        protected BigDecimal strikePrice;
        protected EquityStrikeSequence.EquityStrikeSequenceBuilder equityStrikeSequence;
        protected Currency.CurrencyBuilder currency;

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public BigDecimal getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="equityStrikeSequence")
        @RuneAttribute(value="equityStrikeSequence")
        public EquityStrikeSequence.EquityStrikeSequenceBuilder getEquityStrikeSequence() {
            return this.equityStrikeSequence;
        }

        @Override
        public EquityStrikeSequence.EquityStrikeSequenceBuilder getOrCreateEquityStrikeSequence() {
            EquityStrikeSequence.EquityStrikeSequenceBuilder result = this.equityStrikeSequence != null ? this.equityStrikeSequence : (this.equityStrikeSequence = EquityStrikeSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency.CurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateCurrency() {
            Currency.CurrencyBuilder result = this.currency != null ? this.currency : (this.currency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public EquityStrikeBuilder setStrikePrice(BigDecimal _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="equityStrikeSequence")
        @RuneAttribute(value="equityStrikeSequence")
        public EquityStrikeBuilder setEquityStrikeSequence(EquityStrikeSequence _equityStrikeSequence) {
            this.equityStrikeSequence = _equityStrikeSequence == null ? null : _equityStrikeSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public EquityStrikeBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        public EquityStrike build() {
            return new EquityStrikeImpl(this);
        }

        @Override
        public EquityStrikeBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityStrikeBuilder prune() {
            if (this.equityStrikeSequence != null && !this.equityStrikeSequence.prune().hasData()) {
                this.equityStrikeSequence = null;
            }
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrikePrice() != null) {
                return true;
            }
            if (this.getEquityStrikeSequence() != null && this.getEquityStrikeSequence().hasData()) {
                return true;
            }
            return this.getCurrency() != null && this.getCurrency().hasData();
        }

        public EquityStrikeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EquityStrikeBuilder o = (EquityStrikeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquityStrikeSequence(), (RosettaModelObjectBuilder)o.getEquityStrikeSequence(), this::setEquityStrikeSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeBasic((Object)this.getStrikePrice(), (Object)o.getStrikePrice(), this::setStrikePrice, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.equityStrikeSequence, _that.getEquityStrikeSequence())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.equityStrikeSequence != null ? this.equityStrikeSequence.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityStrikeBuilder {strikePrice=" + this.strikePrice + ", equityStrikeSequence=" + this.equityStrikeSequence + ", currency=" + this.currency + '}';
        }
    }

    public static interface EquityStrikeBuilder
    extends EquityStrike,
    RosettaModelObjectBuilder {
        public EquityStrikeSequence.EquityStrikeSequenceBuilder getOrCreateEquityStrikeSequence();

        @Override
        public EquityStrikeSequence.EquityStrikeSequenceBuilder getEquityStrikeSequence();

        public Currency.CurrencyBuilder getOrCreateCurrency();

        @Override
        public Currency.CurrencyBuilder getCurrency();

        public EquityStrikeBuilder setStrikePrice(BigDecimal var1);

        public EquityStrikeBuilder setEquityStrikeSequence(EquityStrikeSequence var1);

        public EquityStrikeBuilder setCurrency(Currency var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("strikePrice"), BigDecimal.class, (Object)this.getStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("equityStrikeSequence"), processor, EquityStrikeSequence.EquityStrikeSequenceBuilder.class, this.getEquityStrikeSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
        }

        public EquityStrikeBuilder prune();
    }

    public static class EquityStrikeImpl
    implements EquityStrike {
        private final BigDecimal strikePrice;
        private final EquityStrikeSequence equityStrikeSequence;
        private final Currency currency;

        protected EquityStrikeImpl(EquityStrikeBuilder builder) {
            this.strikePrice = builder.getStrikePrice();
            this.equityStrikeSequence = Optional.ofNullable(builder.getEquityStrikeSequence()).map(f -> f.build()).orElse(null);
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public BigDecimal getStrikePrice() {
            return this.strikePrice;
        }

        @Override
        @RosettaAttribute(value="equityStrikeSequence")
        @RuneAttribute(value="equityStrikeSequence")
        public EquityStrikeSequence getEquityStrikeSequence() {
            return this.equityStrikeSequence;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public Currency getCurrency() {
            return this.currency;
        }

        @Override
        public EquityStrike build() {
            return this;
        }

        @Override
        public EquityStrikeBuilder toBuilder() {
            EquityStrikeBuilder builder = EquityStrike.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityStrikeBuilder builder) {
            Optional.ofNullable(this.getStrikePrice()).ifPresent(builder::setStrikePrice);
            Optional.ofNullable(this.getEquityStrikeSequence()).ifPresent(builder::setEquityStrikeSequence);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityStrike _that = this.getType().cast(o);
            if (!Objects.equals(this.strikePrice, _that.getStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.equityStrikeSequence, _that.getEquityStrikeSequence())) {
                return false;
            }
            return Objects.equals(this.currency, _that.getCurrency());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strikePrice != null ? this.strikePrice.hashCode() : 0);
            _result = 31 * _result + (this.equityStrikeSequence != null ? this.equityStrikeSequence.hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityStrike {strikePrice=" + this.strikePrice + ", equityStrikeSequence=" + this.equityStrikeSequence + ", currency=" + this.currency + '}';
        }
    }
}

