/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Money;
import fpml.confirmation.meta.ConstituentWeightMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ConstituentWeight", builder=ConstituentWeightBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ConstituentWeight", model="fpml", builder=ConstituentWeightBuilderImpl.class, version="0.17.2")
public interface ConstituentWeight
extends RosettaModelObject {
    public static final ConstituentWeightMeta metaData = new ConstituentWeightMeta();

    public BigDecimal getOpenUnits();

    public BigDecimal getBasketPercentage();

    public Money getBasketAmount();

    public ConstituentWeight build();

    public ConstituentWeightBuilder toBuilder();

    public static ConstituentWeightBuilder builder() {
        return new ConstituentWeightBuilderImpl();
    }

    default public RosettaMetaData<? extends ConstituentWeight> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ConstituentWeight> getType() {
        return ConstituentWeight.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("openUnits"), BigDecimal.class, (Object)this.getOpenUnits(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("basketPercentage"), BigDecimal.class, (Object)this.getBasketPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketAmount"), processor, Money.class, this.getBasketAmount(), new AttributeMeta[0]);
    }

    public static class ConstituentWeightBuilderImpl
    implements ConstituentWeightBuilder {
        protected BigDecimal openUnits;
        protected BigDecimal basketPercentage;
        protected Money.MoneyBuilder basketAmount;

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public BigDecimal getOpenUnits() {
            return this.openUnits;
        }

        @Override
        @RosettaAttribute(value="basketPercentage")
        @RuneAttribute(value="basketPercentage")
        public BigDecimal getBasketPercentage() {
            return this.basketPercentage;
        }

        @Override
        @RosettaAttribute(value="basketAmount")
        @RuneAttribute(value="basketAmount")
        public Money.MoneyBuilder getBasketAmount() {
            return this.basketAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateBasketAmount() {
            Money.MoneyBuilder result = this.basketAmount != null ? this.basketAmount : (this.basketAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public ConstituentWeightBuilder setOpenUnits(BigDecimal _openUnits) {
            this.openUnits = _openUnits == null ? null : _openUnits;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketPercentage")
        @RuneAttribute(value="basketPercentage")
        public ConstituentWeightBuilder setBasketPercentage(BigDecimal _basketPercentage) {
            this.basketPercentage = _basketPercentage == null ? null : _basketPercentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketAmount")
        @RuneAttribute(value="basketAmount")
        public ConstituentWeightBuilder setBasketAmount(Money _basketAmount) {
            this.basketAmount = _basketAmount == null ? null : _basketAmount.toBuilder();
            return this;
        }

        @Override
        public ConstituentWeight build() {
            return new ConstituentWeightImpl(this);
        }

        @Override
        public ConstituentWeightBuilder toBuilder() {
            return this;
        }

        @Override
        public ConstituentWeightBuilder prune() {
            if (this.basketAmount != null && !this.basketAmount.prune().hasData()) {
                this.basketAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getOpenUnits() != null) {
                return true;
            }
            if (this.getBasketPercentage() != null) {
                return true;
            }
            return this.getBasketAmount() != null && this.getBasketAmount().hasData();
        }

        public ConstituentWeightBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ConstituentWeightBuilder o = (ConstituentWeightBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasketAmount(), (RosettaModelObjectBuilder)o.getBasketAmount(), this::setBasketAmount);
            merger.mergeBasic((Object)this.getOpenUnits(), (Object)o.getOpenUnits(), this::setOpenUnits, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBasketPercentage(), (Object)o.getBasketPercentage(), this::setBasketPercentage, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ConstituentWeight _that = this.getType().cast(o);
            if (!Objects.equals(this.openUnits, _that.getOpenUnits())) {
                return false;
            }
            if (!Objects.equals(this.basketPercentage, _that.getBasketPercentage())) {
                return false;
            }
            return Objects.equals(this.basketAmount, _that.getBasketAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.openUnits != null ? this.openUnits.hashCode() : 0);
            _result = 31 * _result + (this.basketPercentage != null ? this.basketPercentage.hashCode() : 0);
            _result = 31 * _result + (this.basketAmount != null ? this.basketAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ConstituentWeightBuilder {openUnits=" + this.openUnits + ", basketPercentage=" + this.basketPercentage + ", basketAmount=" + this.basketAmount + '}';
        }
    }

    public static interface ConstituentWeightBuilder
    extends ConstituentWeight,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateBasketAmount();

        @Override
        public Money.MoneyBuilder getBasketAmount();

        public ConstituentWeightBuilder setOpenUnits(BigDecimal var1);

        public ConstituentWeightBuilder setBasketPercentage(BigDecimal var1);

        public ConstituentWeightBuilder setBasketAmount(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("openUnits"), BigDecimal.class, (Object)this.getOpenUnits(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("basketPercentage"), BigDecimal.class, (Object)this.getBasketPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketAmount"), processor, Money.MoneyBuilder.class, this.getBasketAmount(), new AttributeMeta[0]);
        }

        public ConstituentWeightBuilder prune();
    }

    public static class ConstituentWeightImpl
    implements ConstituentWeight {
        private final BigDecimal openUnits;
        private final BigDecimal basketPercentage;
        private final Money basketAmount;

        protected ConstituentWeightImpl(ConstituentWeightBuilder builder) {
            this.openUnits = builder.getOpenUnits();
            this.basketPercentage = builder.getBasketPercentage();
            this.basketAmount = Optional.ofNullable(builder.getBasketAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="openUnits")
        @RuneAttribute(value="openUnits")
        public BigDecimal getOpenUnits() {
            return this.openUnits;
        }

        @Override
        @RosettaAttribute(value="basketPercentage")
        @RuneAttribute(value="basketPercentage")
        public BigDecimal getBasketPercentage() {
            return this.basketPercentage;
        }

        @Override
        @RosettaAttribute(value="basketAmount")
        @RuneAttribute(value="basketAmount")
        public Money getBasketAmount() {
            return this.basketAmount;
        }

        @Override
        public ConstituentWeight build() {
            return this;
        }

        @Override
        public ConstituentWeightBuilder toBuilder() {
            ConstituentWeightBuilder builder = ConstituentWeight.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConstituentWeightBuilder builder) {
            Optional.ofNullable(this.getOpenUnits()).ifPresent(builder::setOpenUnits);
            Optional.ofNullable(this.getBasketPercentage()).ifPresent(builder::setBasketPercentage);
            Optional.ofNullable(this.getBasketAmount()).ifPresent(builder::setBasketAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ConstituentWeight _that = this.getType().cast(o);
            if (!Objects.equals(this.openUnits, _that.getOpenUnits())) {
                return false;
            }
            if (!Objects.equals(this.basketPercentage, _that.getBasketPercentage())) {
                return false;
            }
            return Objects.equals(this.basketAmount, _that.getBasketAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.openUnits != null ? this.openUnits.hashCode() : 0);
            _result = 31 * _result + (this.basketPercentage != null ? this.basketPercentage.hashCode() : 0);
            _result = 31 * _result + (this.basketAmount != null ? this.basketAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ConstituentWeight {openUnits=" + this.openUnits + ", basketPercentage=" + this.basketPercentage + ", basketAmount=" + this.basketAmount + '}';
        }
    }
}

