/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.ApprovalId;
import fpml.confirmation.ApprovalType;
import fpml.confirmation.CorrelationAndOptionalSequenceModel;
import fpml.confirmation.CreditLimitInformation;
import fpml.confirmation.EventsOrInfoModel;
import fpml.confirmation.OnBehalfOfModel;
import fpml.confirmation.PartiesAndAccountsModel;
import fpml.confirmation.PartyReference;
import fpml.confirmation.PersonId;
import fpml.confirmation.PortfolioReferenceBaseModel;
import fpml.confirmation.ResponseMessage;
import fpml.confirmation.ResponseMessageHeader;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.ConsentGrantedMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ConsentGranted", builder=ConsentGrantedBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ConsentGranted", model="fpml", builder=ConsentGrantedBuilderImpl.class, version="0.17.2")
public interface ConsentGranted
extends ResponseMessage {
    public static final ConsentGrantedMeta metaData = new ConsentGrantedMeta();

    public ApprovalType get_type();

    public PersonId getApprover();

    public PartyReference getApprovingPartyReference();

    public ApprovalId getApprovalId();

    public PortfolioReferenceBaseModel getPortfolioReferenceBaseModel();

    public EventsOrInfoModel getEventsOrInfoModel();

    public List<? extends CreditLimitInformation> getCreditLimitInformation();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ConsentGranted build();

    @Override
    public ConsentGrantedBuilder toBuilder();

    public static ConsentGrantedBuilder builder() {
        return new ConsentGrantedBuilderImpl();
    }

    default public RosettaMetaData<? extends ConsentGranted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ConsentGranted> getType() {
        return ConsentGranted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("_type"), processor, ApprovalType.class, this.get_type(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approver"), processor, PersonId.class, this.getApprover(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvingPartyReference"), processor, PartyReference.class, this.getApprovingPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvalId"), processor, ApprovalId.class, this.getApprovalId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioReferenceBaseModel"), processor, PortfolioReferenceBaseModel.class, this.getPortfolioReferenceBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventsOrInfoModel"), processor, EventsOrInfoModel.class, this.getEventsOrInfoModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ConsentGrantedBuilderImpl
    extends ResponseMessage.ResponseMessageBuilderImpl
    implements ConsentGrantedBuilder {
        protected ApprovalType.ApprovalTypeBuilder _type;
        protected PersonId.PersonIdBuilder approver;
        protected PartyReference.PartyReferenceBuilder approvingPartyReference;
        protected ApprovalId.ApprovalIdBuilder approvalId;
        protected PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder portfolioReferenceBaseModel;
        protected EventsOrInfoModel.EventsOrInfoModelBuilder eventsOrInfoModel;
        protected List<CreditLimitInformation.CreditLimitInformationBuilder> creditLimitInformation = new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="_type")
        @RuneAttribute(value="_type")
        public ApprovalType.ApprovalTypeBuilder get_type() {
            return this._type;
        }

        @Override
        public ApprovalType.ApprovalTypeBuilder getOrCreate_type() {
            ApprovalType.ApprovalTypeBuilder result = this._type != null ? this._type : (this._type = ApprovalType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="approver")
        @RuneAttribute(value="approver")
        public PersonId.PersonIdBuilder getApprover() {
            return this.approver;
        }

        @Override
        public PersonId.PersonIdBuilder getOrCreateApprover() {
            PersonId.PersonIdBuilder result = this.approver != null ? this.approver : (this.approver = PersonId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="approvingPartyReference")
        @RuneAttribute(value="approvingPartyReference")
        public PartyReference.PartyReferenceBuilder getApprovingPartyReference() {
            return this.approvingPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateApprovingPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.approvingPartyReference != null ? this.approvingPartyReference : (this.approvingPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="approvalId")
        @RuneAttribute(value="approvalId")
        public ApprovalId.ApprovalIdBuilder getApprovalId() {
            return this.approvalId;
        }

        @Override
        public ApprovalId.ApprovalIdBuilder getOrCreateApprovalId() {
            ApprovalId.ApprovalIdBuilder result = this.approvalId != null ? this.approvalId : (this.approvalId = ApprovalId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getPortfolioReferenceBaseModel() {
            return this.portfolioReferenceBaseModel;
        }

        @Override
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getOrCreatePortfolioReferenceBaseModel() {
            PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder result = this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel : (this.portfolioReferenceBaseModel = PortfolioReferenceBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventsOrInfoModel")
        @RuneAttribute(value="eventsOrInfoModel")
        public EventsOrInfoModel.EventsOrInfoModelBuilder getEventsOrInfoModel() {
            return this.eventsOrInfoModel;
        }

        @Override
        public EventsOrInfoModel.EventsOrInfoModelBuilder getOrCreateEventsOrInfoModel() {
            EventsOrInfoModel.EventsOrInfoModelBuilder result = this.eventsOrInfoModel != null ? this.eventsOrInfoModel : (this.eventsOrInfoModel = EventsOrInfoModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public List<? extends CreditLimitInformation.CreditLimitInformationBuilder> getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation(int index) {
            if (this.creditLimitInformation == null) {
                this.creditLimitInformation = new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>();
            }
            return (CreditLimitInformation.CreditLimitInformationBuilder)this.getIndex(this.creditLimitInformation, index, () -> {
                CreditLimitInformation.CreditLimitInformationBuilder newCreditLimitInformation = CreditLimitInformation.builder();
                return newCreditLimitInformation;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ConsentGrantedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ConsentGrantedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ConsentGrantedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public ConsentGrantedBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ConsentGrantedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        @RuneAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        public ConsentGrantedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ConsentGrantedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="_type")
        @RuneAttribute(value="_type")
        public ConsentGrantedBuilder set_type(ApprovalType __type) {
            this._type = __type == null ? null : __type.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="approver")
        @RuneAttribute(value="approver")
        public ConsentGrantedBuilder setApprover(PersonId _approver) {
            this.approver = _approver == null ? null : _approver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="approvingPartyReference")
        @RuneAttribute(value="approvingPartyReference")
        public ConsentGrantedBuilder setApprovingPartyReference(PartyReference _approvingPartyReference) {
            this.approvingPartyReference = _approvingPartyReference == null ? null : _approvingPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="approvalId")
        @RuneAttribute(value="approvalId")
        public ConsentGrantedBuilder setApprovalId(ApprovalId _approvalId) {
            this.approvalId = _approvalId == null ? null : _approvalId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public ConsentGrantedBuilder setPortfolioReferenceBaseModel(PortfolioReferenceBaseModel _portfolioReferenceBaseModel) {
            this.portfolioReferenceBaseModel = _portfolioReferenceBaseModel == null ? null : _portfolioReferenceBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventsOrInfoModel")
        @RuneAttribute(value="eventsOrInfoModel")
        public ConsentGrantedBuilder setEventsOrInfoModel(EventsOrInfoModel _eventsOrInfoModel) {
            this.eventsOrInfoModel = _eventsOrInfoModel == null ? null : _eventsOrInfoModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public ConsentGrantedBuilder addCreditLimitInformation(CreditLimitInformation _creditLimitInformation) {
            if (_creditLimitInformation != null) {
                this.creditLimitInformation.add(_creditLimitInformation.toBuilder());
            }
            return this;
        }

        @Override
        public ConsentGrantedBuilder addCreditLimitInformation(CreditLimitInformation _creditLimitInformation, int idx) {
            this.getIndex(this.creditLimitInformation, idx, () -> _creditLimitInformation.toBuilder());
            return this;
        }

        @Override
        public ConsentGrantedBuilder addCreditLimitInformation(List<? extends CreditLimitInformation> creditLimitInformations) {
            if (creditLimitInformations != null) {
                for (CreditLimitInformation creditLimitInformation : creditLimitInformations) {
                    this.creditLimitInformation.add(creditLimitInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditLimitInformation")
        public ConsentGrantedBuilder setCreditLimitInformation(List<? extends CreditLimitInformation> creditLimitInformations) {
            this.creditLimitInformation = creditLimitInformations == null ? new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>() : (List)creditLimitInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ConsentGrantedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ConsentGranted build() {
            return new ConsentGrantedImpl(this);
        }

        @Override
        public ConsentGrantedBuilder toBuilder() {
            return this;
        }

        @Override
        public ConsentGrantedBuilder prune() {
            super.prune();
            if (this._type != null && !this._type.prune().hasData()) {
                this._type = null;
            }
            if (this.approver != null && !this.approver.prune().hasData()) {
                this.approver = null;
            }
            if (this.approvingPartyReference != null && !this.approvingPartyReference.prune().hasData()) {
                this.approvingPartyReference = null;
            }
            if (this.approvalId != null && !this.approvalId.prune().hasData()) {
                this.approvalId = null;
            }
            if (this.portfolioReferenceBaseModel != null && !this.portfolioReferenceBaseModel.prune().hasData()) {
                this.portfolioReferenceBaseModel = null;
            }
            if (this.eventsOrInfoModel != null && !this.eventsOrInfoModel.prune().hasData()) {
                this.eventsOrInfoModel = null;
            }
            this.creditLimitInformation = this.creditLimitInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.get_type() != null && this.get_type().hasData()) {
                return true;
            }
            if (this.getApprover() != null && this.getApprover().hasData()) {
                return true;
            }
            if (this.getApprovingPartyReference() != null && this.getApprovingPartyReference().hasData()) {
                return true;
            }
            if (this.getApprovalId() != null && this.getApprovalId().hasData()) {
                return true;
            }
            if (this.getPortfolioReferenceBaseModel() != null && this.getPortfolioReferenceBaseModel().hasData()) {
                return true;
            }
            if (this.getEventsOrInfoModel() != null && this.getEventsOrInfoModel().hasData()) {
                return true;
            }
            if (this.getCreditLimitInformation() != null && this.getCreditLimitInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ConsentGrantedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ConsentGrantedBuilder o = (ConsentGrantedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.get_type(), (RosettaModelObjectBuilder)o.get_type(), this::set_type);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprover(), (RosettaModelObjectBuilder)o.getApprover(), this::setApprover);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovingPartyReference(), (RosettaModelObjectBuilder)o.getApprovingPartyReference(), this::setApprovingPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovalId(), (RosettaModelObjectBuilder)o.getApprovalId(), this::setApprovalId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolioReferenceBaseModel(), (RosettaModelObjectBuilder)o.getPortfolioReferenceBaseModel(), this::setPortfolioReferenceBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventsOrInfoModel(), (RosettaModelObjectBuilder)o.getEventsOrInfoModel(), this::setEventsOrInfoModel);
            merger.mergeRosetta(this.getCreditLimitInformation(), o.getCreditLimitInformation(), this::getOrCreateCreditLimitInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConsentGranted _that = (ConsentGranted)this.getType().cast(o);
            if (!Objects.equals(this._type, _that.get_type())) {
                return false;
            }
            if (!Objects.equals(this.approver, _that.getApprover())) {
                return false;
            }
            if (!Objects.equals(this.approvingPartyReference, _that.getApprovingPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.approvalId, _that.getApprovalId())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceBaseModel, _that.getPortfolioReferenceBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.eventsOrInfoModel, _that.getEventsOrInfoModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this._type != null ? this._type.hashCode() : 0);
            _result = 31 * _result + (this.approver != null ? this.approver.hashCode() : 0);
            _result = 31 * _result + (this.approvingPartyReference != null ? this.approvingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.approvalId != null ? this.approvalId.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.eventsOrInfoModel != null ? this.eventsOrInfoModel.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConsentGrantedBuilder {_type=" + this._type + ", approver=" + this.approver + ", approvingPartyReference=" + this.approvingPartyReference + ", approvalId=" + this.approvalId + ", portfolioReferenceBaseModel=" + this.portfolioReferenceBaseModel + ", eventsOrInfoModel=" + this.eventsOrInfoModel + ", creditLimitInformation=" + this.creditLimitInformation + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface ConsentGrantedBuilder
    extends ConsentGranted,
    ResponseMessage.ResponseMessageBuilder {
        public ApprovalType.ApprovalTypeBuilder getOrCreate_type();

        @Override
        public ApprovalType.ApprovalTypeBuilder get_type();

        public PersonId.PersonIdBuilder getOrCreateApprover();

        @Override
        public PersonId.PersonIdBuilder getApprover();

        public PartyReference.PartyReferenceBuilder getOrCreateApprovingPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getApprovingPartyReference();

        public ApprovalId.ApprovalIdBuilder getOrCreateApprovalId();

        @Override
        public ApprovalId.ApprovalIdBuilder getApprovalId();

        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getOrCreatePortfolioReferenceBaseModel();

        @Override
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getPortfolioReferenceBaseModel();

        public EventsOrInfoModel.EventsOrInfoModelBuilder getOrCreateEventsOrInfoModel();

        @Override
        public EventsOrInfoModel.EventsOrInfoModelBuilder getEventsOrInfoModel();

        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation(int var1);

        public List<? extends CreditLimitInformation.CreditLimitInformationBuilder> getCreditLimitInformation();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ConsentGrantedBuilder setFpmlVersion(String var1);

        @Override
        public ConsentGrantedBuilder setExpectedBuild(Integer var1);

        @Override
        public ConsentGrantedBuilder setActualBuild(Integer var1);

        @Override
        public ConsentGrantedBuilder setHeader(ResponseMessageHeader var1);

        @Override
        public ConsentGrantedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ConsentGrantedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ConsentGrantedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ConsentGrantedBuilder set_type(ApprovalType var1);

        public ConsentGrantedBuilder setApprover(PersonId var1);

        public ConsentGrantedBuilder setApprovingPartyReference(PartyReference var1);

        public ConsentGrantedBuilder setApprovalId(ApprovalId var1);

        public ConsentGrantedBuilder setPortfolioReferenceBaseModel(PortfolioReferenceBaseModel var1);

        public ConsentGrantedBuilder setEventsOrInfoModel(EventsOrInfoModel var1);

        public ConsentGrantedBuilder addCreditLimitInformation(CreditLimitInformation var1);

        public ConsentGrantedBuilder addCreditLimitInformation(CreditLimitInformation var1, int var2);

        public ConsentGrantedBuilder addCreditLimitInformation(List<? extends CreditLimitInformation> var1);

        public ConsentGrantedBuilder setCreditLimitInformation(List<? extends CreditLimitInformation> var1);

        public ConsentGrantedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("_type"), processor, ApprovalType.ApprovalTypeBuilder.class, this.get_type(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approver"), processor, PersonId.PersonIdBuilder.class, this.getApprover(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvingPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getApprovingPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvalId"), processor, ApprovalId.ApprovalIdBuilder.class, this.getApprovalId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioReferenceBaseModel"), processor, PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder.class, this.getPortfolioReferenceBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventsOrInfoModel"), processor, EventsOrInfoModel.EventsOrInfoModelBuilder.class, this.getEventsOrInfoModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.CreditLimitInformationBuilder.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ConsentGrantedBuilder prune();
    }

    public static class ConsentGrantedImpl
    extends ResponseMessage.ResponseMessageImpl
    implements ConsentGranted {
        private final ApprovalType _type;
        private final PersonId approver;
        private final PartyReference approvingPartyReference;
        private final ApprovalId approvalId;
        private final PortfolioReferenceBaseModel portfolioReferenceBaseModel;
        private final EventsOrInfoModel eventsOrInfoModel;
        private final List<? extends CreditLimitInformation> creditLimitInformation;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ConsentGrantedImpl(ConsentGrantedBuilder builder) {
            super(builder);
            this._type = Optional.ofNullable(builder.get_type()).map(f -> f.build()).orElse(null);
            this.approver = Optional.ofNullable(builder.getApprover()).map(f -> f.build()).orElse(null);
            this.approvingPartyReference = Optional.ofNullable(builder.getApprovingPartyReference()).map(f -> f.build()).orElse(null);
            this.approvalId = Optional.ofNullable(builder.getApprovalId()).map(f -> f.build()).orElse(null);
            this.portfolioReferenceBaseModel = Optional.ofNullable(builder.getPortfolioReferenceBaseModel()).map(f -> f.build()).orElse(null);
            this.eventsOrInfoModel = Optional.ofNullable(builder.getEventsOrInfoModel()).map(f -> f.build()).orElse(null);
            this.creditLimitInformation = Optional.ofNullable(builder.getCreditLimitInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="_type")
        @RuneAttribute(value="_type")
        public ApprovalType get_type() {
            return this._type;
        }

        @Override
        @RosettaAttribute(value="approver")
        @RuneAttribute(value="approver")
        public PersonId getApprover() {
            return this.approver;
        }

        @Override
        @RosettaAttribute(value="approvingPartyReference")
        @RuneAttribute(value="approvingPartyReference")
        public PartyReference getApprovingPartyReference() {
            return this.approvingPartyReference;
        }

        @Override
        @RosettaAttribute(value="approvalId")
        @RuneAttribute(value="approvalId")
        public ApprovalId getApprovalId() {
            return this.approvalId;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public PortfolioReferenceBaseModel getPortfolioReferenceBaseModel() {
            return this.portfolioReferenceBaseModel;
        }

        @Override
        @RosettaAttribute(value="eventsOrInfoModel")
        @RuneAttribute(value="eventsOrInfoModel")
        public EventsOrInfoModel getEventsOrInfoModel() {
            return this.eventsOrInfoModel;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public List<? extends CreditLimitInformation> getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ConsentGranted build() {
            return this;
        }

        @Override
        public ConsentGrantedBuilder toBuilder() {
            ConsentGrantedBuilder builder = ConsentGranted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConsentGrantedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.get_type()).ifPresent(builder::set_type);
            Optional.ofNullable(this.getApprover()).ifPresent(builder::setApprover);
            Optional.ofNullable(this.getApprovingPartyReference()).ifPresent(builder::setApprovingPartyReference);
            Optional.ofNullable(this.getApprovalId()).ifPresent(builder::setApprovalId);
            Optional.ofNullable(this.getPortfolioReferenceBaseModel()).ifPresent(builder::setPortfolioReferenceBaseModel);
            Optional.ofNullable(this.getEventsOrInfoModel()).ifPresent(builder::setEventsOrInfoModel);
            Optional.ofNullable(this.getCreditLimitInformation()).ifPresent(builder::setCreditLimitInformation);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConsentGranted _that = (ConsentGranted)this.getType().cast(o);
            if (!Objects.equals(this._type, _that.get_type())) {
                return false;
            }
            if (!Objects.equals(this.approver, _that.getApprover())) {
                return false;
            }
            if (!Objects.equals(this.approvingPartyReference, _that.getApprovingPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.approvalId, _that.getApprovalId())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceBaseModel, _that.getPortfolioReferenceBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.eventsOrInfoModel, _that.getEventsOrInfoModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this._type != null ? this._type.hashCode() : 0);
            _result = 31 * _result + (this.approver != null ? this.approver.hashCode() : 0);
            _result = 31 * _result + (this.approvingPartyReference != null ? this.approvingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.approvalId != null ? this.approvalId.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.eventsOrInfoModel != null ? this.eventsOrInfoModel.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConsentGranted {_type=" + this._type + ", approver=" + this.approver + ", approvingPartyReference=" + this.approvingPartyReference + ", approvalId=" + this.approvalId + ", portfolioReferenceBaseModel=" + this.portfolioReferenceBaseModel + ", eventsOrInfoModel=" + this.eventsOrInfoModel + ", creditLimitInformation=" + this.creditLimitInformation + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

